/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String b = "recipeBook";
    private static final Logger e = LogUtils.getLogger();
    private final a f;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> c = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> d = Sets.newIdentityHashSet();

    public RecipeBookServer(a recipebookserver_a) {
        this.f = recipebookserver_a;
    }

    public void a(ResourceKey<IRecipe<?>> resourcekey) {
        this.c.add(resourcekey);
    }

    public boolean b(ResourceKey<IRecipe<?>> resourcekey) {
        return this.c.contains(resourcekey);
    }

    public void c(ResourceKey<IRecipe<?>> resourcekey) {
        this.c.remove(resourcekey);
        this.d.remove(resourcekey);
    }

    public void d(ResourceKey<IRecipe<?>> resourcekey) {
        this.d.remove(resourcekey);
    }

    private void e(ResourceKey<IRecipe<?>> resourcekey) {
        this.d.add(resourcekey);
    }

    public int a(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (this.c.contains(resourcekey) || recipeholder.b().ar_() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(entityplayer, resourcekey.a())) continue;
            this.a(resourcekey);
            this.e(resourcekey);
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, recipeholder.b().i(), true)));
            CriterionTriggers.g.a(entityplayer, recipeholder);
        }
        if (!list.isEmpty() && entityplayer.g != null) {
            entityplayer.g.b(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int b(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (!this.c.contains(resourcekey)) continue;
            this.c(resourcekey);
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(recipedisplayentry.a()));
        }
        if (!list.isEmpty() && entityplayer.g != null) {
            entityplayer.g.b(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    private void a(List<ResourceKey<IRecipe<?>>> list, Consumer<ResourceKey<IRecipe<?>>> consumer, Predicate<ResourceKey<IRecipe<?>>> predicate) {
        for (ResourceKey<IRecipe<?>> resourcekey : list) {
            if (!predicate.test(resourcekey)) {
                e.error("Tried to load unrecognized recipe: {} removed now.", resourcekey);
                continue;
            }
            consumer.accept(resourcekey);
        }
    }

    public void a(EntityPlayer entityplayer) {
        entityplayer.g.b(new ClientboundRecipeBookSettingsPacket(this.a().a()));
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.c.size());
        for (ResourceKey<IRecipe<?>> resourcekey : this.c) {
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, false, this.d.contains(resourcekey))));
        }
        entityplayer.g.b(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void a(RecipeBookServer recipebookserver) {
        this.a(recipebookserver.b());
    }

    public b b() {
        return new b(this.a.a(), List.copyOf(this.c), List.copyOf(this.d));
    }

    private void a(b recipebookserver_b) {
        this.c.clear();
        this.d.clear();
        this.a.a(recipebookserver_b.b);
        this.c.addAll(recipebookserver_b.c);
        this.d.addAll(recipebookserver_b.d);
    }

    public void a(b recipebookserver_b, Predicate<ResourceKey<IRecipe<?>>> predicate) {
        this.a.a(recipebookserver_b.b);
        List<ResourceKey<IRecipe<?>>> list = recipebookserver_b.c;
        Set<ResourceKey<IRecipe<?>>> set = this.c;
        Objects.requireNonNull(this.c);
        this.a(list, set::add, predicate);
        list = recipebookserver_b.d;
        set = this.d;
        Objects.requireNonNull(this.d);
        this.a(list, set::add, predicate);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public static final class b
    extends Record {
        private final RecipeBookSettings b;
        private final List<ResourceKey<IRecipe<?>>> c;
        private final List<ResourceKey<IRecipe<?>>> d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)RecipeBookSettings.b.forGetter(b::a), (App)IRecipe.b.listOf().fieldOf("recipes").forGetter(b::b), (App)IRecipe.b.listOf().fieldOf("toBeDisplayed").forGetter(b::c)).apply((Applicative)instance, b::new));

        public b(RecipeBookSettings settings, List<ResourceKey<IRecipe<?>>> known, List<ResourceKey<IRecipe<?>>> highlight) {
            this.b = settings;
            this.c = known;
            this.d = highlight;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this, o2);
        }

        public RecipeBookSettings a() {
            return this.b;
        }

        public List<ResourceKey<IRecipe<?>>> b() {
            return this.c;
        }

        public List<ResourceKey<IRecipe<?>>> c() {
            return this.d;
        }
    }
}

