/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RecreatingChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    private static final ThreadFactory b = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String c = "new_";
    static final IChatBaseComponent d = IChatBaseComponent.c("optimizeWorld.stage.upgrading.poi");
    static final IChatBaseComponent e = IChatBaseComponent.c("optimizeWorld.stage.finished.poi");
    static final IChatBaseComponent f = IChatBaseComponent.c("optimizeWorld.stage.upgrading.entities");
    static final IChatBaseComponent g = IChatBaseComponent.c("optimizeWorld.stage.finished.entities");
    static final IChatBaseComponent h = IChatBaseComponent.c("optimizeWorld.stage.upgrading.chunks");
    static final IChatBaseComponent i = IChatBaseComponent.c("optimizeWorld.stage.finished.chunks");
    final IRegistry<WorldDimension> j;
    final Set<ResourceKey<World>> k;
    final boolean l;
    final boolean m;
    final Convertable.ConversionSession n;
    private final Thread o;
    final DataFixer p;
    volatile boolean q = true;
    private volatile boolean r;
    volatile float s;
    volatile int t;
    volatile int u;
    volatile int v;
    volatile int w;
    final Reference2FloatMap<ResourceKey<World>> x = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile IChatBaseComponent y = IChatBaseComponent.c("optimizeWorld.stage.counting");
    static final Pattern z = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final WorldPersistentData A;

    public WorldUpgrader(Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, SaveData savedata, IRegistryCustom iregistrycustom, boolean flag, boolean flag1) {
        this.j = iregistrycustom.f(Registries.by);
        this.k = Stream.of(convertable_conversionsession.dimensionType).map(Registries::a).collect(Collectors.toUnmodifiableSet());
        this.l = flag;
        this.p = datafixer;
        this.n = convertable_conversionsession;
        PersistentBase.a persistentbase_a = new PersistentBase.a(null, savedata.x().c());
        this.A = new WorldPersistentData(persistentbase_a, this.n.a(World.h).resolve("data"), datafixer, iregistrycustom);
        this.m = flag1;
        this.o = b.newThread(this::i);
        this.o.setUncaughtExceptionHandler((thread, throwable) -> {
            a.error("Error upgrading world", throwable);
            this.y = IChatBaseComponent.c("optimizeWorld.stage.failed");
            this.r = true;
        });
        this.o.start();
    }

    public void a() {
        this.q = false;
        try {
            this.o.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void i() {
        long i2 = SystemUtils.c();
        a.info("Upgrading entities");
        new d(this).a();
        a.info("Upgrading POIs");
        new f(this).a();
        a.info("Upgrading blocks");
        new b().a();
        this.A.b();
        i2 = SystemUtils.c() - i2;
        a.info("World optimizaton finished after {} seconds", (Object)(i2 / 1000L));
        this.r = true;
    }

    public boolean b() {
        return this.r;
    }

    public Set<ResourceKey<World>> c() {
        return this.k;
    }

    public float a(ResourceKey<World> resourcekey) {
        return this.x.getFloat(resourcekey);
    }

    public float d() {
        return this.s;
    }

    public int e() {
        return this.t;
    }

    public int f() {
        return this.v;
    }

    public int g() {
        return this.w;
    }

    public IChatBaseComponent h() {
        return this.y;
    }

    @Override
    public void close() {
        this.A.close();
    }

    static Path a(Path path) {
        return path.resolveSibling(c + path.getFileName().toString());
    }

    private class d
    extends g {
        d(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.u, "entities", f, g);
        }

        @Override
        protected NBTTagCompound a(SimpleRegionStorage simpleregionstorage, NBTTagCompound nbttagcompound) {
            return simpleregionstorage.a(nbttagcompound, -1);
        }
    }

    private class f
    extends g {
        f(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.s, "poi", d, e);
        }

        @Override
        protected NBTTagCompound a(SimpleRegionStorage simpleregionstorage, NBTTagCompound nbttagcompound) {
            return simpleregionstorage.a(nbttagcompound, 1945);
        }
    }

    private class b
    extends a<IChunkLoader> {
        b() {
            super(DataFixTypes.d, "chunk", "region", h, i);
        }

        @Override
        protected boolean a(IChunkLoader ichunkloader, ChunkCoordIntPair chunkcoordintpair, ResourceKey<World> resourcekey) {
            NBTTagCompound nbttagcompound = ichunkloader.d(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i2 = IChunkLoader.a(nbttagcompound);
                ChunkGenerator chunkgenerator = WorldUpgrader.this.j.g(Registries.b(resourcekey)).b();
                NBTTagCompound nbttagcompound1 = ichunkloader.upgradeChunkTag(Registries.b(resourcekey), () -> WorldUpgrader.this.A, nbttagcompound, chunkgenerator.c(), chunkcoordintpair, null);
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound1.b("xPos", 0), nbttagcompound1.b("zPos", 0));
                if (!chunkcoordintpair1.equals(chunkcoordintpair)) {
                    a.warn("Chunk {} has invalid position {}", (Object)chunkcoordintpair, (Object)chunkcoordintpair1);
                }
                boolean bl = flag = i2 < SharedConstants.b().a().b();
                if (WorldUpgrader.this.l) {
                    flag = flag || nbttagcompound1.b("Heightmaps");
                    nbttagcompound1.r("Heightmaps");
                    flag = flag || nbttagcompound1.b("isLightOn");
                    nbttagcompound1.r("isLightOn");
                    NBTTagList nbttaglist = nbttagcompound1.p("sections");
                    for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                        Optional<NBTTagCompound> optional = nbttaglist.a(j2);
                        if (optional.isEmpty()) continue;
                        NBTTagCompound nbttagcompound2 = optional.get();
                        flag = flag || nbttagcompound2.b("BlockLight");
                        nbttagcompound2.r("BlockLight");
                        flag = flag || nbttagcompound2.b("SkyLight");
                        nbttagcompound2.r("SkyLight");
                    }
                }
                if (flag || WorldUpgrader.this.m) {
                    if (this.a != null) {
                        this.a.join();
                    }
                    this.a = ichunkloader.a(chunkcoordintpair, () -> nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        protected IChunkLoader b(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.m ? new RecreatingChunkStorage(regionstorageinfo.a("source"), path, regionstorageinfo.a("target"), WorldUpgrader.a(path), WorldUpgrader.this.p, true) : new IChunkLoader(regionstorageinfo, path, WorldUpgrader.this.p, true);
        }
    }

    private abstract class g
    extends a<SimpleRegionStorage> {
        g(DataFixTypes datafixtypes, String s2, IChatBaseComponent ichatbasecomponent, IChatBaseComponent ichatbasecomponent1) {
            super(datafixtypes, s2, s2, ichatbasecomponent, ichatbasecomponent1);
        }

        protected SimpleRegionStorage b(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.m ? new RecreatingSimpleRegionStorage(regionstorageinfo.a("source"), path, regionstorageinfo.a("target"), WorldUpgrader.a(path), WorldUpgrader.this.p, true, this.b) : new SimpleRegionStorage(regionstorageinfo, path, WorldUpgrader.this.p, true, this.b);
        }

        @Override
        protected boolean a(SimpleRegionStorage simpleregionstorage, ChunkCoordIntPair chunkcoordintpair, ResourceKey<World> resourcekey) {
            NBTTagCompound nbttagcompound = simpleregionstorage.a(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i2 = IChunkLoader.a(nbttagcompound);
                NBTTagCompound nbttagcompound1 = this.a(simpleregionstorage, nbttagcompound);
                boolean bl = flag = i2 < SharedConstants.b().a().b();
                if (flag || WorldUpgrader.this.m) {
                    if (this.a != null) {
                        this.a.join();
                    }
                    this.a = simpleregionstorage.a(chunkcoordintpair, nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        protected abstract NBTTagCompound a(SimpleRegionStorage var1, NBTTagCompound var2);
    }

    private abstract class a<T extends AutoCloseable> {
        private final IChatBaseComponent d;
        private final IChatBaseComponent e;
        private final String f;
        private final String g;
        @Nullable
        protected CompletableFuture<Void> a;
        protected final DataFixTypes b;

        a(DataFixTypes datafixtypes, String s2, String s1, IChatBaseComponent ichatbasecomponent, IChatBaseComponent ichatbasecomponent1) {
            this.b = datafixtypes;
            this.f = s2;
            this.g = s1;
            this.d = ichatbasecomponent;
            this.e = ichatbasecomponent1;
        }

        public void a() {
            WorldUpgrader.this.u = 0;
            WorldUpgrader.this.t = 0;
            WorldUpgrader.this.v = 0;
            WorldUpgrader.this.w = 0;
            List<c<T>> list = this.b();
            if (WorldUpgrader.this.t != 0) {
                float f2 = WorldUpgrader.this.u;
                WorldUpgrader.this.y = this.d;
                while (WorldUpgrader.this.q) {
                    boolean flag = false;
                    float f1 = 0.0f;
                    for (c<T> worldupgrader_c : list) {
                        ResourceKey<World> resourcekey = worldupgrader_c.a;
                        ListIterator<e> listiterator = worldupgrader_c.c;
                        AutoCloseable t0 = (AutoCloseable)worldupgrader_c.b;
                        if (listiterator.hasNext()) {
                            e worldupgrader_e = listiterator.next();
                            boolean flag1 = true;
                            for (ChunkCoordIntPair chunkcoordintpair : worldupgrader_e.b) {
                                flag1 = flag1 && this.a(resourcekey, t0, chunkcoordintpair);
                                flag = true;
                            }
                            if (WorldUpgrader.this.m) {
                                if (flag1) {
                                    this.a(worldupgrader_e.a);
                                } else {
                                    a.error("Failed to convert region file {}", (Object)worldupgrader_e.a.a());
                                }
                            }
                        }
                        float f22 = (float)listiterator.nextIndex() / f2;
                        WorldUpgrader.this.x.put(resourcekey, f22);
                        f1 += f22;
                    }
                    WorldUpgrader.this.s = f1;
                    if (flag) continue;
                    break;
                }
                WorldUpgrader.this.y = this.e;
                for (c<T> worldupgrader_c1 : list) {
                    try {
                        ((AutoCloseable)worldupgrader_c1.b).close();
                    }
                    catch (Exception exception) {
                        a.error("Error upgrading chunk", (Throwable)exception);
                    }
                }
            }
        }

        private List<c<T>> b() {
            ArrayList list = Lists.newArrayList();
            for (ResourceKey<World> resourcekey : WorldUpgrader.this.k) {
                RegionStorageInfo regionstorageinfo = new RegionStorageInfo(WorldUpgrader.this.n.f(), resourcekey, this.f);
                Path path = WorldUpgrader.this.n.a(resourcekey).resolve(this.g);
                T t0 = this.a(regionstorageinfo, path);
                ListIterator<e> listiterator = this.b(regionstorageinfo, path);
                list.add(new c<T>(resourcekey, t0, listiterator));
            }
            return list;
        }

        protected abstract T a(RegionStorageInfo var1, Path var2);

        private ListIterator<e> b(RegionStorageInfo regionstorageinfo, Path path) {
            List<e> list = net.minecraft.util.worldupdate.WorldUpgrader$a.c(regionstorageinfo, path);
            WorldUpgrader.this.u += list.size();
            WorldUpgrader.this.t += list.stream().mapToInt(worldupgrader_e -> worldupgrader_e.b.size()).sum();
            return list.listIterator();
        }

        private static List<e> c(RegionStorageInfo regionstorageinfo, Path path) {
            File[] afile = path.toFile().listFiles((file, s2) -> s2.endsWith(".mca"));
            if (afile == null) {
                return List.of();
            }
            ArrayList list = Lists.newArrayList();
            for (File file2 : afile) {
                Matcher matcher = z.matcher(file2.getName());
                if (!matcher.matches()) continue;
                int i2 = Integer.parseInt(matcher.group(1)) << 5;
                int j2 = Integer.parseInt(matcher.group(2)) << 5;
                ArrayList list1 = Lists.newArrayList();
                try (RegionFile regionfile = new RegionFile(regionstorageinfo, file2.toPath(), path, true);){
                    for (int k2 = 0; k2 < 32; ++k2) {
                        for (int l2 = 0; l2 < 32; ++l2) {
                            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(k2 + i2, l2 + j2);
                            if (!regionfile.b(chunkcoordintpair)) continue;
                            list1.add(chunkcoordintpair);
                        }
                    }
                    if (list1.isEmpty()) continue;
                    list.add(new e(regionfile, list1));
                }
                catch (Throwable throwable) {
                    a.error("Failed to read chunks from region file {}", (Object)file2.toPath(), (Object)throwable);
                }
            }
            return list;
        }

        private boolean a(ResourceKey<World> resourcekey, T t0, ChunkCoordIntPair chunkcoordintpair) {
            boolean flag = false;
            try {
                flag = this.a(t0, chunkcoordintpair, resourcekey);
            }
            catch (CompletionException | ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    throw reportedexception;
                }
                a.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)throwable);
            }
            if (flag) {
                ++WorldUpgrader.this.v;
            } else {
                ++WorldUpgrader.this.w;
            }
            return flag;
        }

        protected abstract boolean a(T var1, ChunkCoordIntPair var2, ResourceKey<World> var3);

        private void a(RegionFile regionfile) {
            if (WorldUpgrader.this.m) {
                if (this.a != null) {
                    this.a.join();
                }
                Path path = regionfile.a();
                Path path1 = path.getParent();
                Path path2 = WorldUpgrader.a(path1).resolve(path.getFileName().toString());
                try {
                    if (path2.toFile().exists()) {
                        Files.delete(path);
                        Files.move(path2, path, new CopyOption[0]);
                    } else {
                        a.error("Failed to replace an old region file. New file {} does not exist.", (Object)path2);
                    }
                }
                catch (IOException ioexception) {
                    a.error("Failed to replace an old region file", (Throwable)ioexception);
                }
            }
        }
    }

    record e(RegionFile a, List<ChunkCoordIntPair> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this, o2);
        }
    }

    record c<T>(ResourceKey<World> a, T b, ListIterator<e> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this, o2);
        }
    }
}

