/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> a = UUIDUtil.a.xmap(EntityReference::new, EntityReference::c);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> b = UUIDUtil.g.a(EntityReference::new, EntityReference::c);
    private Either<UUID, StoredEntityType> c;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> a() {
        return a;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> b() {
        return b;
    }

    private EntityReference(StoredEntityType var0) {
        this.c = Either.right(var0);
    }

    private EntityReference(UUID var0) {
        this.c = Either.left((Object)var0);
    }

    @Nullable
    public static <T extends UniquelyIdentifyable> EntityReference<T> a(@Nullable T var0) {
        return var0 != null ? new EntityReference<T>(var0) : null;
    }

    public static <T extends UniquelyIdentifyable> EntityReference<T> a(UUID var0) {
        return new EntityReference(var0);
    }

    public UUID c() {
        return (UUID)this.c.map(var0 -> var0, UniquelyIdentifyable::cT);
    }

    @Nullable
    public StoredEntityType a(UUIDLookup<? extends UniquelyIdentifyable> var0, Class<StoredEntityType> var1) {
        StoredEntityType var4;
        Object var3;
        Optional var2 = this.c.right();
        if (var2.isPresent()) {
            var3 = (UniquelyIdentifyable)var2.get();
            if (var3.ec()) {
                this.c = Either.left((Object)var3.cT());
            } else {
                return (StoredEntityType)var3;
            }
        }
        if (((Optional)(var3 = this.c.left())).isPresent() && (var4 = this.a(var0.lookup((UUID)((Optional)var3).get()), var1)) != null && !var4.ec()) {
            this.c = Either.right(var4);
            return var4;
        }
        return null;
    }

    @Nullable
    public StoredEntityType a(World var0, Class<StoredEntityType> var1) {
        if (EntityHuman.class.isAssignableFrom(var1)) {
            return this.a(var0::b, var1);
        }
        return this.a(var0::a, var1);
    }

    @Nullable
    private StoredEntityType a(@Nullable UniquelyIdentifyable var0, Class<StoredEntityType> var1) {
        if (var0 != null && var1.isAssignableFrom(var0.getClass())) {
            return (StoredEntityType)((UniquelyIdentifyable)var1.cast(var0));
        }
        return null;
    }

    public boolean b(StoredEntityType var0) {
        return this.c().equals(var0.cT());
    }

    public void a(ValueOutput var0, String var1) {
        var0.a(var1, UUIDUtil.a, this.c());
    }

    public static void a(@Nullable EntityReference<?> var0, ValueOutput var1, String var2) {
        if (var0 != null) {
            var0.a(var1, var2);
        }
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType a(@Nullable EntityReference<StoredEntityType> var0, World var1, Class<StoredEntityType> var2) {
        return var0 != null ? (StoredEntityType)var0.a(var1, var2) : null;
    }

    @Nullable
    public static Entity a(@Nullable EntityReference<Entity> var0, World var1) {
        return EntityReference.a(var0, var1, Entity.class);
    }

    @Nullable
    public static EntityLiving b(@Nullable EntityReference<EntityLiving> var0, World var1) {
        return EntityReference.a(var0, var1, EntityLiving.class);
    }

    @Nullable
    public static EntityHuman c(@Nullable EntityReference<EntityHuman> var0, World var1) {
        return EntityReference.a(var0, var1, EntityHuman.class);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> a(ValueInput var0, String var1) {
        return var0.a(var1, EntityReference.a()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> a(ValueInput var0, String var12, World var2) {
        Optional<UUID> var3 = var0.a(var12, UUIDUtil.a);
        if (var3.isPresent()) {
            return EntityReference.a(var3.get());
        }
        return var0.g(var12).map(var1 -> NameReferencingFileConverter.a(var2.q(), var1)).map(EntityReference::new).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (!(var0 instanceof EntityReference)) return false;
        EntityReference var1 = (EntityReference)var0;
        if (!this.c().equals(var1.c())) return false;
        return true;
    }

    public int hashCode() {
        return this.c().hashCode();
    }
}

