/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize ct = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cA = 2;
    private static final int cB = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> cu = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.s);
    protected static final ImmutableList<MemoryModuleType<?>> cv = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.az, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int cx = 10;
    public static final double cy = 0.02;
    public static final double cz = (double)0.1f;
    private static final DataWatcherObject<Boolean> cC = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cD = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cE = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean cF = false;
    private static final boolean cG = true;
    private static final boolean cH = true;
    private boolean cI;
    private int cJ;

    public Goat(EntityTypes<? extends Goat> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.S().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack m() {
        RandomSource randomsource = RandomSource.a(this.cT().hashCode());
        TagKey<Instrument> tagkey = this.gU() ? InstrumentTags.b : InstrumentTags.a;
        return this.an().L_().f(Registries.bc).a(tagkey, randomsource).map(holder -> InstrumentItem.a(Items.yv, holder)).orElseGet(() -> new ItemStack(Items.yv));
    }

    protected BehaviorController.b<Goat> er() {
        return BehaviorController.a(cv, cu);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.er().a(dynamic));
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void h() {
        if (this.g_()) {
            this.h(GenericAttributes.c).a(1.0);
            this.gM();
        } else {
            this.h(GenericAttributes.c).a(2.0);
            this.gL();
        }
    }

    @Override
    protected int a(double d0, float f2) {
        return super.a(d0, f2) - 10;
    }

    @Override
    protected SoundEffect p() {
        return this.gU() ? SoundEffects.mp : SoundEffects.mg;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gU() ? SoundEffects.ms : SoundEffects.mj;
    }

    @Override
    protected SoundEffect f_() {
        return this.gU() ? SoundEffects.mq : SoundEffects.mh;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.mx, 0.15f, 1.0f);
    }

    protected SoundEffect s() {
        return this.gU() ? SoundEffects.mu : SoundEffects.ml;
    }

    @Nullable
    public Goat b(WorldServer worldserver, EntityAgeable entityageable) {
        Goat goat = EntityTypes.al.a(worldserver, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, worldserver.I_());
            EntityAgeable entityageable1 = worldserver.I_().h() ? this : entityageable;
            boolean flag = entityageable1 instanceof Goat && ((Goat)(goat1 = entityageable1)).gU() || !(worldserver.I_().j() >= 0.02);
            boolean flag1 = flag;
            goat.x(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> eq() {
        return super.eq();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("goatBrain");
        this.eq().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("goatActivityUpdate");
        GoatAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    public int ah() {
        return 15;
    }

    @Override
    public void r(float f2) {
        int i2 = this.ah();
        float f1 = MathHelper.c(this.bB, f2);
        float f22 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.r(this.bB + f22);
    }

    @Override
    protected void gO() {
        this.an().a((Entity)null, this, this.gU() ? SoundEffects.mr : SoundEffects.mi, SoundCategory.g, 1.0f, MathHelper.b(this.an().z, 0.8f, 1.2f));
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.aF);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.sk) && !this.g_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.an(), entityhuman, this.dF(), this.dF(), null, itemstack, Items.sq, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(this.s(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && this.i(itemstack)) {
            this.gO();
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.I_();
        GoatAi.a(this, randomsource);
        this.x(randomsource.j() < 0.02);
        this.h();
        if (!this.g_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cD : cE;
            this.az.a(datawatcherobject, false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return entitypose == EntityPose.g ? ct.a(this.ez()) : super.b(entitypose);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsScreamingGoat", this.gU());
        valueoutput.a("HasLeftHorn", this.gI());
        valueoutput.a("HasRightHorn", this.gJ());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("IsScreamingGoat", false));
        this.az.a(cD, valueinput.a("HasLeftHorn", true));
        this.az.a(cE, valueinput.a("HasRightHorn", true));
    }

    @Override
    public void b(byte b0) {
        if (b0 == 58) {
            this.cI = true;
        } else if (b0 == 59) {
            this.cI = false;
        } else {
            super.b(b0);
        }
    }

    @Override
    public void e_() {
        this.cJ = this.cI ? ++this.cJ : (this.cJ -= 2);
        this.cJ = MathHelper.a(this.cJ, 0, 20);
        super.e_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cC, false);
        datawatcher_a.a(cD, true);
        datawatcher_a.a(cE, true);
    }

    public boolean gI() {
        return this.az.a(cD);
    }

    public boolean gJ() {
        return this.az.a(cE);
    }

    public boolean gK() {
        boolean flag = this.gI();
        boolean flag1 = this.gJ();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? cE : (!flag1 ? cD : (this.as.h() ? cD : cE));
        this.az.a(datawatcherobject, false);
        Vec3D vec3d = this.dD();
        ItemStack itemstack = this.m();
        double d0 = MathHelper.b(this.as, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.as, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.as, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.an(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        this.an().b(entityitem);
        return true;
    }

    public void gL() {
        this.az.a(cD, true);
        this.az.a(cE, true);
    }

    public void gM() {
        this.az.a(cD, false);
        this.az.a(cE, false);
    }

    public boolean gU() {
        return this.az.a(cC);
    }

    public void x(boolean flag) {
        this.az.a(cC, flag);
    }

    public float gV() {
        return (float)this.cJ / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cn) && Goat.a(generatoraccess, blockposition);
    }
}

