/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap ct = new PathfinderGoalHorseTrap(this);
    private static final int cu = 18000;
    private static final boolean cv = false;
    private static final int cx = 0;
    private static final EntitySize cy = EntityTypes.bl.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bl.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cz = false;
    public int cA = 0;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> entitytypes, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)entitytypes, world);
    }

    public static AttributeProvider.Builder m() {
        return EntityHorseSkeleton.hi().a(GenericAttributes.t, 15.0).a(GenericAttributes.w, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !EntitySpawnReason.a(entityspawnreason) ? EntityAnimal.b(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource) : EntitySpawnReason.b(entityspawnreason) || EntityHorseSkeleton.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(RandomSource randomsource) {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.p);
        Objects.requireNonNull(randomsource);
        attributemodifiable.a(EntityHorseSkeleton.a(randomsource::j));
    }

    @Override
    protected void ha() {
    }

    @Override
    protected SoundEffect p() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.zn : SoundEffects.zj;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.zk;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.zl;
    }

    @Override
    protected SoundEffect bg() {
        if (this.aS()) {
            if (!this.cm()) {
                return SoundEffects.zq;
            }
            ++this.cP;
            if (this.cP > 5 && this.cP % 3 == 0) {
                return SoundEffects.zo;
            }
            if (this.cP <= 5) {
                return SoundEffects.zq;
            }
        }
        return SoundEffects.zm;
    }

    @Override
    protected void g(float f2) {
        if (this.aS()) {
            super.g(0.3f);
        } else {
            super.g(Math.min(0.1f, f2 * 25.0f));
        }
    }

    @Override
    protected void hp() {
        if (this.bu()) {
            this.a(SoundEffects.zp, 0.4f, 1.0f);
        } else {
            super.hp();
        }
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.g_() ? cy : super.b(entitypose);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.n() && this.cA++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("SkeletonTrap", this.n());
        valueoutput.a("SkeletonTrapTime", this.cA);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("SkeletonTrap", false));
        this.cA = valueinput.a("SkeletonTrapTime", 0);
    }

    @Override
    protected float fz() {
        return 0.96f;
    }

    public boolean n() {
        return this.cz;
    }

    public void x(boolean flag) {
        if (flag != this.cz) {
            this.cz = flag;
            if (flag) {
                this.cq.a(1, this.ct);
            } else {
                this.cq.a(this.ct);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bl.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return !this.gZ() ? EnumInteractionResult.e : super.b(entityhuman, enumhand);
    }
}

