/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cs = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean ct = false;
    public float d;
    public float e;
    public float f;
    private boolean cu = false;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.da();
        this.cn = new ControllerMoveSlime(this);
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.cq.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.cq.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.cq.a(5, new PathfinderGoalSlimeIdle(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dM() - this.dM()) <= 4.0));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cs, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.az.a(cs, j2);
        this.aG();
        this.l_();
        this.h(GenericAttributes.t).a(j2 * j2);
        this.h(GenericAttributes.w).a(0.2f + 0.1f * (float)j2);
        this.h(GenericAttributes.c).a(j2);
        if (flag) {
            this.x(this.fj());
        }
        this.cl = j2;
    }

    public int gI() {
        return this.az.a(cs);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Size", this.gI() - 1);
        valueoutput.a("wasOnGround", this.cu);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(valueinput.a("Size", 0) + 1, false);
        super.a(valueinput);
        this.cu = valueinput.a("wasOnGround", false);
    }

    public boolean gJ() {
        return this.gI() <= 1;
    }

    protected ParticleParam m() {
        return Particles.Y;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aS() && !this.cu) {
            float f2 = this.a(this.aE()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.as.i() * ((float)Math.PI * 2);
                float f3 = this.as.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.an().a(this.m(), this.dK() + (double)f4, this.dM(), this.dQ() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gG(), this.ft(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aS() && this.cu) {
            this.d = 1.0f;
        }
        this.cu = this.aS();
        this.s();
    }

    protected void s() {
        this.d *= 0.6f;
    }

    protected int n() {
        return this.as.a(20) + 10;
    }

    @Override
    public void l_() {
        double d0 = this.dK();
        double d1 = this.dM();
        double d2 = this.dQ();
        super.l_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cs.equals(datawatcherobject)) {
            this.l_();
            this.v(this.bD);
            this.bB = this.bD;
            if (this.bu() && this.as.a(20) == 0) {
                this.bE();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> ax() {
        return super.ax();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gI();
        if (!this.an().D_() && i2 > 1 && this.eV()) {
            float f2 = this.a(this.aE()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.as.a(3);
            ScoreboardTeam scoreboardteam = this.cD();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime converted = this.convertTo(this.ax(), new ConversionParams(ConversionType.b, false, false, scoreboardteam), EntitySpawnReason.k, entityslime -> {
                    entityslime.a(j2, true);
                    entityslime.b(this.dK() + (double)f22, this.dM() + 0.5, this.dQ() + (double)f3, this.as.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.an().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gE()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (this.gE()) {
            this.i(entityhuman);
        }
    }

    protected void i(EntityLiving entityliving) {
        World world = this.an();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            if (this.bX() && this.h(entityliving) && this.F(entityliving) && entityliving.a(worldserver, damagesource = this.ei().b(this), this.gF())) {
                this.a(SoundEffects.zu, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return new Vec3D(0.0, (double)entitysize.b() - 0.015625 * (double)this.gI() * (double)f2, 0.0);
    }

    protected boolean gE() {
        return !this.gJ() && this.dt();
    }

    protected float gF() {
        return (float)this.i(GenericAttributes.c);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gJ() ? SoundEffects.Az : SoundEffects.zw;
    }

    @Override
    protected SoundEffect f_() {
        return this.gJ() ? SoundEffects.Ay : SoundEffects.zv;
    }

    protected SoundEffect gG() {
        return this.gJ() ? SoundEffects.AB : SoundEffects.zy;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        if (generatoraccess.aq() != EnumDifficulty.a) {
            boolean flag;
            if (EntitySpawnReason.a(entityspawnreason)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (generatoraccess.v(blockposition).a(BiomeTags.as) && blockposition.v() > 50 && blockposition.v() < 70 && randomsource.i() < 0.5f && randomsource.i() < generatoraccess.av() && generatoraccess.C(blockposition) <= randomsource.a(8)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.h, chunkcoordintpair.i, ((GeneratorAccessSeed)generatoraccess).H(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float ft() {
        return 0.4f * (float)this.gI();
    }

    @Override
    public int af() {
        return 0;
    }

    protected boolean gK() {
        return this.gI() > 0;
    }

    @Override
    public void u() {
        Vec3D vec3d = this.dI();
        this.m(vec3d.g, this.fw(), vec3d.i);
        this.aF = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.I_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    float k() {
        float f2 = this.gJ() ? 1.4f : 0.8f;
        return ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gH() {
        return this.gJ() ? SoundEffects.AA : SoundEffects.zx;
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return super.b(entitypose).a(this.gI());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.dX() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.v(this.b(this.d.dX(), this.l, 90.0f));
            this.d.bD = this.d.dX();
            this.d.bB = this.d.dX();
            if (this.k != ControllerMove.Operation.b) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aS()) {
                    this.d.B((float)(this.h * this.d.i(GenericAttributes.w)));
                    if (this.m-- <= 0) {
                        this.m = this.n.n();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.R().a();
                        if (this.n.gK()) {
                            this.n.a(this.n.gH(), this.n.ft(), this.n.k());
                        }
                    } else {
                        this.n.bM = 0.0f;
                        this.n.bO = 0.0f;
                        this.d.B(0.0f);
                    }
                } else {
                    this.d.B((float)(this.h * this.d.i(GenericAttributes.w)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.S().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bu() || this.a.bJ()) && this.a.Q() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.ek().i() < 0.8f) {
                this.a.R().a();
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.Q() instanceof ControllerMoveSlime);
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.e();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dX(), this.a.gE());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.e() == null && (this.a.aS() || this.a.bu() || this.a.bJ() || this.a.d(MobEffects.y)) && this.a.Q() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ek().a(60));
                this.b = this.a.ek().a(360);
            }
            if ((controllermove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.cl();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.Q();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

