/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int ct = 40;
    private static final int cu = 200;
    private static final int cv = 500;
    private static final float cw = 0.3f;
    private static final float cx = 1.0f;
    private static final float cy = 1.5f;
    private static final int cz = 30;
    private static final int cA = 24;
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cC = 200;
    private static final int cD = 260;
    private static final int cE = 20;
    private static final int cF = 120;
    private static final int cG = 20;
    private static final int cH = 35;
    private static final int cI = 10;
    private static final int cJ = 20;
    private static final int cK = 100;
    private static final int cL = 20;
    private static final int cM = 30;
    private static final float cN = 4.5f;
    private static final float cO = 0.7f;
    private static final int cP = 30;
    private int cS;
    private int cT;
    private int cU;
    private int cV;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cW = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cX = new a();
    private VibrationSystem.a cY = new VibrationSystem.a();
    AngerManagement cZ = new AngerManagement(this::G, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entitytypes, World world) {
        super(entitytypes, world);
        this.cl = 5;
        this.S().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, this.d(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (packetplayoutspawnentity.n() == 1) {
            this.c(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return super.a(iworldreader) && iworldreader.a((Entity)this, this.ax().n().a(this.dD()));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.gL() && !damagesource.a(DamageTypeTags.d) ? true : super.a(worldserver, damagesource);
    }

    boolean gL() {
        return this.d(EntityPose.o) || this.d(EntityPose.n);
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public float gj() {
        return 5.0f;
    }

    @Override
    protected float bf() {
        return this.al + 0.55f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 500.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.q, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.n, 24.0);
    }

    @Override
    public boolean bs() {
        return true;
    }

    @Override
    protected float ft() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return !this.d(EntityPose.l) && !this.gL() ? this.n().b() : null;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Eh;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.Ed;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Er, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        worldserver.a((Entity)this, (byte)4);
        this.a(SoundEffects.Ec, 10.0f, this.fu());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(worldserver, entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cB, 0);
    }

    public int m() {
        return this.az.a(cB);
    }

    private void gO() {
        this.az.a(cB, this.gR());
    }

    @Override
    public void g() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cY, this.cX);
            if (this.gr() || this.ae()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.an().D_()) {
            if (this.at % this.gP() == 0) {
                this.cU = 10;
                if (!this.bm()) {
                    this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.Eg, this.dw(), 5.0f, this.fu(), false);
                }
            }
            this.cT = this.cS;
            if (this.cS > 0) {
                --this.cS;
            }
            this.cV = this.cU;
            if (this.cU > 0) {
                --this.cU;
            }
            switch (this.aE()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("wardenBrain");
        this.eq().a(worldserver, this);
        gameprofilerfiller.c();
        super.a(worldserver);
        if ((this.at + this.az()) % 120 == 0) {
            Warden.a(worldserver, this.dD(), this, 20);
        }
        if (this.at % 20 == 0) {
            this.cZ.a(worldserver, this::G);
            this.gO();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.a.a();
            this.e.a(this.at);
        } else if (b0 == 61) {
            this.cS = 10;
        } else if (b0 == 62) {
            this.f.a(this.at);
        } else {
            super.b(b0);
        }
    }

    private int gP() {
        float f2 = (float)this.m() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.cT, this.cS) / 10.0f;
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cV, this.cU) / 10.0f;
    }

    private void a(AnimationState animationstate) {
        if ((float)animationstate.a((float)this.at) < 4500.0f) {
            RandomSource randomsource = this.ek();
            IBlockData iblockdata = this.bG();
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dK() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dM();
                    double d2 = this.dQ() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.an().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aE.equals(datawatcherobject)) {
            switch (this.aE()) {
                case n: {
                    this.c.a(this.at);
                    break;
                }
                case o: {
                    this.d.a(this.at);
                    break;
                }
                case l: {
                    this.a.a(this.at);
                    break;
                }
                case m: {
                    this.b.a(this.at);
                }
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gL();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> eq() {
        return super.eq();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            biconsumer.accept(this.cW, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean G(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.an() == entity.an() && IEntitySelector.e.test(entity) && !this.t(entity) && entityliving.ax() != EntityTypes.h && entityliving.ax() != EntityTypes.bL && !entityliving.cP() && !entityliving.eV() && this.an().u().a(entityliving.de())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, @Nullable Entity entity, int i2) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, i2, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("anger", AngerManagement.a(this::G), this.cZ);
        valueoutput.a("listener", VibrationSystem.a.a, this.cY);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cZ = valueinput.a("anger", AngerManagement.a(this::G)).orElseGet(() -> new AngerManagement(this::G, Collections.emptyList()));
        this.gO();
        this.cY = valueinput.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    private void gQ() {
        if (!this.d(EntityPose.l)) {
            this.a(this.n().c(), 10.0f, this.fu());
        }
    }

    public AngerLevel n() {
        return AngerLevel.a(this.gR());
    }

    private int gR() {
        return this.cZ.b(this.e());
    }

    public void H(Entity entity) {
        this.cZ.a(entity);
    }

    public void I(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int i2, boolean flag) {
        if (!this.gx() && this.G(entity)) {
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.e() instanceof EntityHuman);
            int j2 = this.cZ.a(entity, i2);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.eq().b(MemoryModuleType.p);
            }
            if (flag) {
                this.gQ();
            }
        }
    }

    public Optional<EntityLiving> s() {
        return this.n().d() ? this.cZ.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.eq().a(MemoryModuleType.aI, Unit.a, 1200L);
        if (entityspawnreason == EntitySpawnReason.k) {
            this.c(EntityPose.n);
            this.eq().a(MemoryModuleType.aG, Unit.a, WardenAi.a);
            this.a(SoundEffects.DZ, 5.0f, 1.0f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean flag = super.a(worldserver, damagesource, f2);
        if (!this.gx() && !this.gL()) {
            Entity entity = damagesource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bY.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (damagesource.b() || this.a((Entity)entityliving, 5.0)) {
                    this.i(entityliving);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving entityliving) {
        this.eq().b(MemoryModuleType.aC);
        this.eq().a(MemoryModuleType.p, entityliving);
        this.eq().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        EntitySize entitysize = super.b(entitypose);
        return this.gL() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bU() {
        return !this.gL() && super.bU();
    }

    @Override
    protected void E(Entity entity) {
        if (!this.gx() && !this.eq().a(MemoryModuleType.aL)) {
            this.eq().a(MemoryModuleType.aL, Unit.a, 20L);
            this.I(entity);
            WardenAi.a(this, entity.dF());
        }
        super.E(entity);
    }

    @VisibleForTesting
    public AngerManagement gI() {
        return this.cZ;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int i2) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, i2){

                    @Override
                    protected float a(PathPoint pathpoint, PathPoint pathpoint1) {
                        return pathpoint.b(pathpoint1);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gJ() {
        return this.cY;
    }

    @Override
    public VibrationSystem.d gK() {
        return this.cX;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.df());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, GameEvent.a gameevent_a) {
            if (!(Warden.this.gx() || Warden.this.eV() || Warden.this.eq().a(MemoryModuleType.aM) || Warden.this.gL() || !worldserver.u().a(blockposition))) {
                EntityLiving entityliving;
                Entity entity = gameevent_a.a();
                if (entity instanceof EntityLiving && !Warden.this.G(entityliving = (EntityLiving)entity)) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity1, float f2) {
            if (!Warden.this.eV()) {
                Warden.this.bY.a(MemoryModuleType.aM, Unit.a, 40L);
                worldserver.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Es, 5.0f, Warden.this.fu());
                BlockPosition blockposition1 = blockposition;
                if (entity1 != null) {
                    if (Warden.this.a(entity1, 30.0)) {
                        if (Warden.this.eq().a(MemoryModuleType.aE)) {
                            if (Warden.this.G(entity1)) {
                                blockposition1 = entity1.dF();
                            }
                            Warden.this.I(entity1);
                        } else {
                            Warden.this.a(entity1, 10, true);
                        }
                    }
                    Warden.this.eq().a(MemoryModuleType.aE, Unit.a, 100L);
                } else {
                    Warden.this.I(entity);
                }
                if (!Warden.this.n().d()) {
                    Optional<EntityLiving> optional = Warden.this.cZ.a();
                    if (entity1 != null || optional.isEmpty() || optional.get() == entity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

