/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public abstract class EntityHuman
extends Avatar
implements ContainerUser {
    public static final int ca = 20;
    public static final int cb = 100;
    public static final int cc = 10;
    public static final int cd = 200;
    public static final int ce = 499;
    public static final int cf = 500;
    public static final float cg = 4.5f;
    public static final float ch = 3.0f;
    private static final int a = 40;
    private static final DataWatcherObject<Float> b = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<OptionalInt> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final DataWatcherObject<OptionalInt> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    public static final int ci = 60;
    private static final short f = 0;
    private static final float g = 0.0f;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final int cA = 0;
    private static final boolean cB = false;
    private static final int cC = 0;
    final PlayerInventory cD;
    protected InventoryEnderChest cj = new InventoryEnderChest(this);
    public final ContainerPlayer ck;
    public Container cl;
    protected FoodMetaData cm = new FoodMetaData();
    protected int cn;
    private boolean cE = false;
    protected int co = 60;
    public int cp;
    public int cF = 0;
    protected boolean cq;
    private final PlayerAbilities cG = new PlayerAbilities();
    public int cr = 0;
    public int cs = 0;
    public float ct = 0.0f;
    public int cu = 0;
    protected final float cv = 0.02f;
    private int cH;
    private final GameProfile cI;
    private boolean cJ;
    private ItemStack cK = ItemStack.l;
    private final ItemCooldown cL = this.f();
    private Optional<GlobalPos> cM = Optional.empty();
    @Nullable
    public EntityFishingHook cw;
    protected float cx;
    @Nullable
    public Vec3D cy;
    @Nullable
    public Entity cz;
    private boolean cN = false;
    private int cO = 0;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bX, world);
        this.a_(gameprofile.id());
        this.cI = gameprofile;
        this.cD = new PlayerInventory(this, this.bZ);
        this.ck = new ContainerPlayer(this.cD, !world.D_(), this);
        this.cl = this.ck;
    }

    @Override
    protected EntityEquipment ep() {
        return new PlayerEquipment(this);
    }

    public boolean a(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.f()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.d) {
            return true;
        }
        if (this.gO()) {
            return false;
        }
        ItemStack itemstack = this.fq();
        return itemstack.f() || !itemstack.b(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder go() {
        return EntityLiving.es().a(GenericAttributes.c, 1.0).a(GenericAttributes.w, 0.1f).a(GenericAttributes.e).a(GenericAttributes.r).a(GenericAttributes.g, 4.5).a(GenericAttributes.k, 3.0).a(GenericAttributes.f).a(GenericAttributes.D).a(GenericAttributes.A).a(GenericAttributes.u).a(GenericAttributes.E).a(GenericAttributes.H, 6.0E7).a(GenericAttributes.I, 6.0E7);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, Float.valueOf(0.0f));
        datawatcher_a.a(c, 0);
        datawatcher_a.a(d, OptionalInt.empty());
        datawatcher_a.a(e, OptionalInt.empty());
    }

    @Override
    public void g() {
        this.ar = this.at();
        if (this.at() || this.cl()) {
            this.e(false);
        }
        if (this.cp > 0) {
            --this.cp;
        }
        if (this.gg()) {
            ++this.cF;
            if (this.cF > 100) {
                this.cF = 100;
            }
            if (!this.an().D_() && this.an().aa()) {
                this.a(false, true);
            }
        } else if (this.cF > 0) {
            ++this.cF;
            if (this.cF >= 110) {
                this.cF = 0;
            }
        }
        this.gs();
        super.g();
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dK(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dQ(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dK() || d1 != this.dQ()) {
            this.a_(d0, this.dM(), d1);
        }
        ++this.by;
        ItemStack itemstack = this.fq();
        if (!ItemStack.a(this.cK, itemstack)) {
            if (!ItemStack.b(this.cK, itemstack)) {
                this.gV();
            }
            this.cK = itemstack.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pP)) {
            this.m();
        }
        this.cL.a();
        this.gt();
        if (this.cO > 0) {
            --this.cO;
        }
    }

    @Override
    protected float fE() {
        return this.fV() ? 15.0f : super.fE();
    }

    public boolean gp() {
        return this.cp();
    }

    protected boolean gq() {
        return this.cp();
    }

    protected boolean gr() {
        return this.cp();
    }

    protected boolean gs() {
        this.cq = ((Entity)this).a(TagsFluid.a);
        return this.cq;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.gC().b) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void m(boolean flag) {
        if (!this.gC().b) {
            super.m(flag);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            Equippable equippable = itemstack.a(DataComponents.D);
            if (!itemstack.a(item) || equippable == null || equippable.b() != enumitemslot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    protected void gt() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.n();
            EntityPose entitypose1 = !(this.at() || this.cl() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.c(entitypose1);
        }
    }

    private EntityPose n() {
        return this.gg() ? EntityPose.c : (this.cw() ? EntityPose.d : (this.fY() ? EntityPose.b : (this.fL() ? EntityPose.e : (this.cp() && !this.cG.b ? EntityPose.f : EntityPose.a))));
    }

    protected boolean h(EntityPose entitypose) {
        return this.an().a((Entity)this, this.a(entitypose).a(this.dD()).h(1.0E-7));
    }

    @Override
    protected SoundEffect bg() {
        return SoundEffects.wn;
    }

    @Override
    protected SoundEffect bh() {
        return SoundEffects.wl;
    }

    @Override
    protected SoundEffect bi() {
        return SoundEffects.wm;
    }

    @Override
    public int cj() {
        return 10;
    }

    @Override
    public void a(SoundEffect soundeffect, float f2, float f1) {
        this.an().a((Entity)this, this.dK(), this.dM(), this.dQ(), soundeffect, this.dw(), f2, f1);
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.h;
    }

    @Override
    public int dx() {
        return 20;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 9) {
            this.R_();
        } else if (b0 == 23) {
            this.v(false);
        } else if (b0 == 22) {
            this.v(true);
        } else {
            super.b(b0);
        }
    }

    public void r() {
        this.cl = this.ck;
    }

    protected void s() {
    }

    @Override
    public void t() {
        if (!this.an().D_() && this.gq() && this.cl()) {
            this.cb();
            if (!this.cl()) {
                this.h(false);
                return;
            }
        }
        super.t();
    }

    @Override
    public void e_() {
        if (this.cn > 0) {
            --this.cn;
        }
        this.i();
        this.cD.m();
        if (this.cG.b && !this.cl()) {
            this.l();
        }
        super.e_();
        this.fo();
        this.bD = this.dX();
        this.B((float)this.i(GenericAttributes.w));
        if (this.eU() > 0.0f && !this.at()) {
            AxisAlignedBB axisalignedbb = this.cl() && !this.du().ec() ? this.de().b(this.du().de()).c(1.0, 0.0, 1.0) : this.de().c(1.0, 0.5, 1.0);
            List<Entity> list = this.an().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ax() == EntityTypes.Y) {
                    list1.add(entity);
                    continue;
                }
                if (entity.ec()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.as));
            }
        }
        this.j();
    }

    protected void i() {
    }

    public void j() {
    }

    protected void k() {
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gu() {
        return this.az.a(c);
    }

    public void q(int i2) {
        this.az.a(c, i2);
    }

    public void r(int i2) {
        int j2 = this.gu();
        this.az.a(c, j2 + i2);
    }

    public void a(int i2, float f2, ItemStack itemstack) {
        this.bV = i2;
        this.bW = f2;
        this.bX = itemstack;
        if (!this.an().D_()) {
            this.k();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack el() {
        return this.fL() && this.bX != null ? this.bX : super.el();
    }

    @Override
    public void a(DamageSource damagesource) {
        World world;
        super.a(damagesource);
        this.aG();
        if (!this.at() && (world = this.an()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.b(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.m(-MathHelper.b((this.fa() + this.dX()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.fa() + this.dX()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.m(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aQ();
        this.d(false);
        this.d(Optional.of(GlobalPos.a(this.an().al(), this.dF())));
    }

    @Override
    protected void g(WorldServer worldserver) {
        super.g(worldserver);
        if (!worldserver.S().c(GameRules.e)) {
            this.gv();
            this.cD.n();
        }
    }

    protected void gv() {
        for (int i2 = 0; i2 < this.cD.b(); ++i2) {
            ItemStack itemstack = this.cD.a(i2);
            if (itemstack.f() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.cD.b(i2);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return damagesource.k().d().a();
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.wd;
    }

    public void g(ItemStack itemstack) {
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag) {
        return this.a(itemstack, false, flag);
    }

    public float c(IBlockData iblockdata) {
        float f2 = this.cD.h().a(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.i(GenericAttributes.u);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.d(MobEffects.d)) {
            float f22 = switch (this.e(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f2 *= f22;
        }
        f2 *= (float)this.i(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.h(GenericAttributes.D).g();
        }
        if (!this.aS()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData iblockdata) {
        return !iblockdata.C() || this.cD.h().b(iblockdata);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a_(this.cI.id());
        this.cD.a(valueinput.c("Inventory", ItemStackWithSlot.a));
        this.cD.c(valueinput.a("SelectedItemSlot", 0));
        this.cF = valueinput.a("SleepTimer", (short)0);
        this.ct = valueinput.a("XpP", 0.0f);
        this.cr = valueinput.a("XpLevel", 0);
        this.cs = valueinput.a("XpTotal", 0);
        this.cu = valueinput.a("XpSeed", 0);
        if (this.cu == 0) {
            this.cu = this.as.f();
        }
        this.q(valueinput.a("Score", 0));
        this.cm.a(valueinput);
        Optional<PlayerAbilities.a> optional = valueinput.a("abilities", PlayerAbilities.a.a);
        PlayerAbilities playerabilities = this.cG;
        Objects.requireNonNull(this.cG);
        optional.ifPresent(playerabilities::a);
        this.h(GenericAttributes.w).a(this.cG.b());
        this.cj.b(valueinput.c("EnderItems", ItemStackWithSlot.a));
        this.d(valueinput.a("LastDeathLocation", GlobalPos.b));
        this.cy = valueinput.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cN = valueinput.a("ignore_fall_damage_from_current_explosion", false);
        this.cO = valueinput.a("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        GameProfileSerializer.a(valueoutput);
        this.cD.a(valueoutput.a("Inventory", ItemStackWithSlot.a));
        valueoutput.a("SelectedItemSlot", this.cD.g());
        valueoutput.a("SleepTimer", (short)this.cF);
        valueoutput.a("XpP", this.ct);
        valueoutput.a("XpLevel", this.cr);
        valueoutput.a("XpTotal", this.cs);
        valueoutput.a("XpSeed", this.cu);
        valueoutput.a("Score", this.gu());
        this.cm.a(valueoutput);
        valueoutput.a("abilities", PlayerAbilities.a.a, this.cG.c());
        this.cj.b(valueoutput.a("EnderItems", ItemStackWithSlot.a));
        this.cM.ifPresent(globalpos -> valueoutput.a("LastDeathLocation", GlobalPos.b, globalpos));
        valueoutput.b("current_explosion_impact_pos", Vec3D.a, this.cy);
        valueoutput.a("ignore_fall_damage_from_current_explosion", this.cN);
        valueoutput.a("current_impulse_context_reset_grace_time", this.cO);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) ? true : (damagesource.a(DamageTypeTags.n) ? !worldserver.S().c(GameRules.I) : (damagesource.a(DamageTypeTags.m) ? !worldserver.S().c(GameRules.J) : (damagesource.a(DamageTypeTags.i) ? !worldserver.S().c(GameRules.K) : (damagesource.a(DamageTypeTags.o) ? !worldserver.S().c(GameRules.L) : false))));
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.cG.a && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bJ = 0;
        if (this.eV()) {
            return false;
        }
        if (damagesource.g()) {
            if (worldserver.aq() == EnumDifficulty.a) {
                return false;
            }
            if (worldserver.aq() == EnumDifficulty.b) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (worldserver.aq() == EnumDifficulty.d) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(worldserver, damagesource, f2)) {
            this.k();
        }
        return damaged;
    }

    @Override
    protected void a(WorldServer worldserver, EntityLiving entityliving) {
        super.a(worldserver, entityliving);
        ItemStack itemstack = this.fW();
        BlocksAttacks blocksattacks = itemstack != null ? itemstack.a(DataComponents.I) : null;
        float f2 = entityliving.gj();
        if (f2 > 0.0f && blocksattacks != null) {
            blocksattacks.a(worldserver, this, f2, itemstack);
        }
    }

    @Override
    public boolean eN() {
        return !this.gC().a && super.eN();
    }

    public boolean a(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.an().getCraftServer().getOfflinePlayer(entityhuman.cV());
            team = entityhuman.an().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.an().getCraftServer().getOfflinePlayer(this.cV()));
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(worldserver, damagesource, f2, event);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign tileentitysign, boolean flag) {
    }

    public void a(CommandBlockListenerAbstract commandblocklistenerabstract) {
    }

    public void a(TileEntityCommand tileentitycommand) {
    }

    public void a(TileEntityStructure tileentitystructure) {
    }

    public void a(TestBlockEntity testblockentity) {
    }

    public void a(TestInstanceBlockEntity testinstanceblockentity) {
    }

    public void a(TileEntityJigsaw tileentityjigsaw) {
    }

    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void b(Holder<Dialog> holder) {
    }

    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void a(ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand enumhand) {
        if (this.at()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        ItemStack itemstack = this.b(enumhand);
        ItemStack itemstack1 = itemstack.v();
        EnumInteractionResult enuminteractionresult = entity.a(this, enumhand);
        if (enuminteractionresult.a()) {
            if (this.gk() && itemstack == this.b(enumhand) && itemstack.M() < itemstack1.M()) {
                itemstack.e(itemstack1.M());
            }
            return enuminteractionresult;
        }
        if (!itemstack.f() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.gk()) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, enumhand)).a()) {
                this.an().a(GameEvent.r, entity.dD(), GameEvent.a.a(this));
                if (itemstack.f() && !this.gk()) {
                    this.a(enumhand, ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void ad() {
        super.ad();
        this.X = 0;
    }

    @Override
    protected boolean fv() {
        return super.fv() || this.gg();
    }

    @Override
    public boolean eB() {
        return !this.cG.b;
    }

    @Override
    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.eb();
        if (!this.cG.b && vec3d.h <= 0.0 && (enummovetype == EnumMoveType.a || enummovetype == EnumMoveType.b) && this.gr() && this.H(f2)) {
            double d0;
            double d1 = vec3d.i;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.g; d0 != 0.0 && this.p(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.p(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.p(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.h, d1);
        }
        return vec3d;
    }

    private boolean H(float f2) {
        return this.aS() || this.an < (double)f2 && !this.p(0.0, 0.0, (double)f2 - this.an);
    }

    private boolean p(double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.de();
        return this.an().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + 1.0E-7 + d0, axisalignedbb.b - d2 - 1.0E-7, axisalignedbb.c + 1.0E-7 + d1, axisalignedbb.d - 1.0E-7 + d0, axisalignedbb.b, axisalignedbb.f - 1.0E-7 + d1));
    }

    public void e(Entity entity) {
        if (entity.cO() && !entity.w(this)) {
            float f2 = this.fL() ? this.bW : (float)this.i(GenericAttributes.c);
            ItemStack itemstack = this.el();
            DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.ei().a(this));
            float f1 = this.a(entity, f2, damagesource) - f2;
            float f22 = this.G(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (entity.ax().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, EntityReference.a(this), true)) {
                    this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vW, this.dw());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d0;
                boolean flag2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.cv() && flag) {
                    this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vV, this.dw(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.h().a(entity, f2, damagesource);
                boolean bl2 = flag2 = flag && this.an > 0.0 && !this.aS() && !this.fe() && !this.bu() && !this.ha() && !this.cl() && entity instanceof EntityLiving && !this.cv();
                if (flag2) {
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aS() && (d0 = this.ag().j()) < MathHelper.l(d1 = (double)this.fD() * 2.5) && this.b(EnumHand.a).a(TagsItem.bV)) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (entity instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    f4 = entityliving.eU();
                }
                Vec3D vec3d = entity.dI();
                boolean flag4 = entity.b(damagesource, f3);
                if (flag4) {
                    float f5 = this.b(entity, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)entity;
                            entityliving1.o(f5 * 0.5f, MathHelper.a(this.dX() * ((float)Math.PI / 180)), -MathHelper.b(this.dX() * ((float)Math.PI / 180)));
                        } else {
                            entity.i(-MathHelper.a(this.dX() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dX() * ((float)Math.PI / 180)) * f5 * 0.5f);
                        }
                        this.k(this.dI().d(0.6, 1.0, 0.6));
                        this.i(false);
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.i(GenericAttributes.E) * f2;
                        for (EntityLiving entityliving2 : this.an().a(EntityLiving.class, entity.de().c(1.0, 0.25, 1.0))) {
                            WorldServer worldserver;
                            EntityArmorStand entityarmorstand;
                            if (entityliving2 == this || entityliving2 == entity || this.t(entityliving2) || entityliving2 instanceof EntityArmorStand && (entityarmorstand = (EntityArmorStand)entityliving2).s() || !(this.g(entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            World world = this.an();
                            if (!(world instanceof WorldServer) || !entityliving2.a(worldserver = (WorldServer)world, damagesource, f7)) continue;
                            entityliving2.o(0.4f, MathHelper.a(this.dX() * ((float)Math.PI / 180)), -MathHelper.b(this.dX() * ((float)Math.PI / 180)));
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vY, this.dw(), 1.0f, 1.0f);
                        this.gw();
                    }
                    if (entity instanceof EntityPlayer && entity.ah) {
                        boolean cancelled = false;
                        Player player = (Player)entity.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)entity).g.b(new PacketPlayOutEntityVelocity(entity));
                            entity.ah = false;
                            entity.k(vec3d);
                        }
                    }
                    if (flag2) {
                        this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vU, this.dw(), 1.0f, 1.0f);
                        this.b(entity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vX, this.dw(), 1.0f, 1.0f);
                        } else {
                            this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vZ, this.dw(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(entity);
                    }
                    this.C(entity);
                    Entity entity1 = entity;
                    if (entity instanceof EntityComplexPart) {
                        entity1 = ((EntityComplexPart)entity).a;
                    }
                    boolean flag5 = false;
                    World world1 = this.an();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (entity1 instanceof EntityLiving) {
                            EntityLiving entityliving3 = (EntityLiving)entity1;
                            flag5 = itemstack.a(entityliving3, (EntityLiving)this);
                        }
                        EnchantmentManager.a(worldserver1, entity, damagesource);
                    }
                    if (!this.an().D_() && !itemstack.f() && entity1 instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)entity1, (EntityLiving)this);
                        }
                        if (itemstack.f()) {
                            if (itemstack == this.fq()) {
                                this.a(EnumHand.a, ItemStack.l);
                            } else {
                                this.a(EnumHand.b, ItemStack.l);
                            }
                        }
                    }
                    if (entity instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)entity).eU();
                        this.a(StatisticList.H, Math.round(f8 * 10.0f));
                        if (this.an() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.an()).a(Particles.h, entity.dK(), entity.f(0.5), entity.dQ(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.an().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.vW, this.dw(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void f(EntityLiving entityliving) {
        this.e((Entity)entityliving);
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    public void gw() {
        double d0 = -MathHelper.a(this.dX() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dX() * ((float)Math.PI / 180));
        if (this.an() instanceof WorldServer) {
            ((WorldServer)this.an()).a(Particles.an, this.dK() + d0, this.f(0.5), this.dQ() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void gx() {
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.ck.a(this);
        if (this.gE()) {
            this.s();
        }
    }

    @Override
    public boolean ab_() {
        return true;
    }

    @Override
    protected boolean dr() {
        return this.gy();
    }

    public boolean gy() {
        return false;
    }

    @Override
    public boolean ds() {
        return !this.an().D_() || this.gy();
    }

    @Override
    public boolean dt() {
        return !this.an().D_() || this.gy();
    }

    public GameProfile gz() {
        return this.cI;
    }

    public NameAndId gA() {
        return new NameAndId(this.cI);
    }

    public PlayerInventory gB() {
        return this.cD;
    }

    public PlayerAbilities gC() {
        return this.cG;
    }

    @Override
    public boolean gk() {
        return this.cG.d;
    }

    public boolean gD() {
        return this.cG.d;
    }

    public void a(ItemStack itemstack, ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean gE() {
        return this.cl != this.ck;
    }

    public boolean gF() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cF = 0;
        return Either.right((Object)((Object)Unit.a));
    }

    public void a(boolean flag, boolean flag1) {
        super.gh();
        if (this.an() instanceof WorldServer && flag1) {
            ((WorldServer)this.an()).f();
        }
        this.cF = flag ? 0 : 100;
    }

    @Override
    public void gh() {
        this.a(true, true);
    }

    public boolean gG() {
        return this.gg() && this.cF >= 100;
    }

    public int gH() {
        return this.cF;
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void a(MinecraftKey minecraftkey) {
        this.b(StatisticList.i.b(minecraftkey));
    }

    public void a(MinecraftKey minecraftkey, int i2) {
        this.a(StatisticList.i.b(minecraftkey), i2);
    }

    public void b(Statistic<?> statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic<?> statistic, int i2) {
    }

    public void a(Statistic<?> statistic) {
    }

    public int a(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> list) {
    }

    public int b(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void m(Vec3D vec3d) {
        if (this.cl()) {
            super.m(vec3d);
        } else {
            if (this.cw()) {
                double d1;
                double d0 = this.cf().h;
                double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.bL || !this.an().b_(BlockPosition.a(this.dK(), this.dM() + 1.0 - 0.1, this.dQ())).c()) {
                    Vec3D vec3d1 = this.dI();
                    this.k(vec3d1.b(0.0, (d0 - vec3d1.h) * d1, 0.0));
                }
            }
            if (this.gC().b) {
                double d2 = this.dI().h;
                super.m(vec3d);
                this.k(this.dI().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.m(vec3d);
            }
        }
    }

    @Override
    protected boolean fJ() {
        return !this.cG.b && super.fJ();
    }

    @Override
    public void bB() {
        if (this.cG.b) {
            this.j(false);
        } else {
            super.bB();
        }
    }

    protected boolean h(BlockPosition blockposition) {
        return !this.an().a_(blockposition).j(this.an(), blockposition);
    }

    @Override
    public float fD() {
        return (float)this.i(GenericAttributes.w);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        double d1;
        boolean flag;
        if (this.cG.c) {
            return false;
        }
        if (d0 >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(d0 * 100.0));
        }
        boolean bl = flag = this.cy != null && this.cN;
        if (flag) {
            boolean flag1;
            d1 = Math.min(d0, this.cy.h - this.dM());
            boolean bl2 = flag1 = d1 <= 0.0;
            if (flag1) {
                this.hh();
            } else {
                this.hg();
            }
        } else {
            d1 = d0;
        }
        if (d1 > 0.0 && super.a(d1, f2, damagesource)) {
            this.hh();
            return true;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    public boolean gI() {
        if (!this.fY() && this.fJ() && !this.bu()) {
            this.gJ();
            return true;
        }
        return false;
    }

    public void gJ() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bE() {
        if (!this.at()) {
            super.bE();
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.bu()) {
            this.bj();
            this.b(iblockdata);
        } else {
            BlockPosition blockposition1 = this.e(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.an().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bA)) {
                    this.a(iblockdata1, iblockdata);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a fc() {
        return new EntityLiving.a(SoundEffects.wk, SoundEffects.wa);
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        this.b(StatisticList.g.b(entityliving.ax()));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.cG.b) {
            super.a(iblockdata, vec3d);
        }
        this.hg();
    }

    public void d(int i2) {
        this.r(i2);
        this.ct += (float)i2 / (float)this.gL();
        this.cs = MathHelper.a(this.cs + i2, 0, Integer.MAX_VALUE);
        while (this.ct < 0.0f) {
            float f2 = this.ct * (float)this.gL();
            if (this.cr > 0) {
                this.c(-1);
                this.ct = 1.0f + f2 / (float)this.gL();
                continue;
            }
            this.c(-1);
            this.ct = 0.0f;
        }
        while (this.ct >= 1.0f) {
            this.ct = (this.ct - 1.0f) * (float)this.gL();
            this.c(1);
            this.ct /= (float)this.gL();
        }
    }

    public int gK() {
        return this.cu;
    }

    public void a(ItemStack itemstack, int i2) {
        this.cr -= i2;
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        this.cu = this.as.f();
    }

    public void c(int i2) {
        this.cr = IntMath.saturatedAdd((int)this.cr, (int)i2);
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        if (i2 > 0 && this.cr % 5 == 0 && (float)this.cH < (float)this.at - 100.0f) {
            float f2 = this.cr > 30 ? 1.0f : (float)this.cr / 30.0f;
            this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.wj, this.dw(), f2 * 0.75f, 1.0f);
            this.cH = this.at;
        }
    }

    public int gL() {
        return this.cr >= 30 ? 112 + (this.cr - 30) * 9 : (this.cr >= 15 ? 37 + (this.cr - 15) * 5 : 7 + this.cr * 2);
    }

    public void a(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cG.a || this.an().D_() || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.cm.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gM() {
        return this.cm;
    }

    public boolean u(boolean flag) {
        return this.cG.a || flag || this.cm.b();
    }

    public boolean gN() {
        return this.eU() > 0.0f && this.eU() < this.fj();
    }

    public boolean gO() {
        return this.cG.e;
    }

    public boolean a(BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        if (this.cG.e) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.an(), blockposition1, false);
        return itemstack.a(shapedetectorblock);
    }

    @Override
    protected int f(WorldServer worldserver) {
        return !worldserver.S().c(GameRules.e) && !this.at() ? Math.min(this.cr * 7, 100) : 0;
    }

    @Override
    protected boolean eE() {
        return true;
    }

    @Override
    public boolean cZ() {
        return true;
    }

    @Override
    protected Entity.MovementEmission br() {
        return this.cG.b || this.aS() && this.cs() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ao() {
        return IChatBaseComponent.b(this.cI.name());
    }

    @Override
    public String ap() {
        return this.cI.name();
    }

    public InventoryEnderChest gP() {
        return this.cj;
    }

    @Override
    protected boolean b(EnumItemSlot enumitemslot) {
        return enumitemslot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(ItemStack itemstack) {
        return this.cD.g(itemstack);
    }

    @Nullable
    public abstract EnumGamemode a();

    @Override
    public boolean at() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bS() {
        return !this.at() && super.bS();
    }

    @Override
    public boolean cw() {
        return !this.cG.b && !this.at() && super.cw();
    }

    public boolean gQ() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean cW() {
        return !this.cG.b;
    }

    @Override
    public IChatBaseComponent S_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cD(), this.ao());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.gz().name();
        return ichatmutablecomponent.a(chatmodifier -> chatmodifier.a(new ChatClickable.SuggestCommand("/tell " + s2 + " ")).a(this.dd()).a(s2));
    }

    @Override
    public String cV() {
        return this.gz().name();
    }

    @Override
    protected void F(float f2) {
        this.aC().a(b, Float.valueOf(f2));
    }

    @Override
    public float fM() {
        return this.aC().a(b).floatValue();
    }

    @Override
    public SlotAccess a_(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.cl.g();
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.cl.a(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.ck.r().a(j2);
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.ck.r().a(j2, itemstack);
                    EntityHuman.this.ck.a(EntityHuman.this.cD);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.cD.j().size()) {
            return SlotAccess.a(this.cD, i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.cj.b() ? SlotAccess.a(this.cj, k2) : super.a_(i2);
    }

    public boolean gR() {
        return this.cJ;
    }

    public void v(boolean flag) {
        this.cJ = flag;
    }

    @Override
    public void h(int i2) {
        super.h(this.cG.a ? Math.min(i2, 1) : i2);
    }

    protected static Optional<EntityParrot.Variant> d(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!nbttagcompound.j() && (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) == EntityTypes.aT) {
            return nbttagcompound.a("Variant", EntityParrot.Variant.h);
        }
        return Optional.empty();
    }

    protected static OptionalInt a(Optional<EntityParrot.Variant> optional) {
        return optional.map(entityparrot_variant -> OptionalInt.of(entityparrot_variant.a())).orElse(OptionalInt.empty());
    }

    private static Optional<EntityParrot.Variant> a(OptionalInt optionalint) {
        return optionalint.isPresent() ? Optional.of(EntityParrot.Variant.a(optionalint.getAsInt())) : Optional.empty();
    }

    public void b(Optional<EntityParrot.Variant> optional) {
        this.az.a(d, EntityHuman.a(optional));
    }

    public Optional<EntityParrot.Variant> gS() {
        return EntityHuman.a(this.az.a(d));
    }

    public void c(Optional<EntityParrot.Variant> optional) {
        this.az.a(e, EntityHuman.a(optional));
    }

    public Optional<EntityParrot.Variant> gT() {
        return EntityHuman.a(this.az.a(e));
    }

    public float gU() {
        return (float)(1.0 / this.i(GenericAttributes.e) * 20.0);
    }

    public float G(float f2) {
        return MathHelper.a(((float)this.by + f2) / this.gU(), 0.0f, 1.0f);
    }

    public void gV() {
        this.by = 0;
    }

    public ItemCooldown gW() {
        return this.cL;
    }

    @Override
    protected float be() {
        return !this.cG.b && !this.fY() ? super.be() : 1.0f;
    }

    @Override
    public float ew() {
        return (float)this.i(GenericAttributes.r);
    }

    public boolean gX() {
        return this.cG.d && this.I() >= 2;
    }

    public int I() {
        return 0;
    }

    public boolean s(int i2) {
        return this.I() >= i2;
    }

    @Override
    public ImmutableList<EntityPose> gd() {
        return ImmutableList.of((Object)EntityPose.a, (Object)EntityPose.f, (Object)EntityPose.d);
    }

    @Override
    public ItemStack d(ItemStack itemstack) {
        if (!(itemstack.h() instanceof ItemProjectileWeapon)) {
            return ItemStack.l;
        }
        Predicate<ItemStack> predicate = ((ItemProjectileWeapon)itemstack.h()).c();
        ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.f()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.h()).a();
        for (int i2 = 0; i2 < this.cD.b(); ++i2) {
            ItemStack itemstack2 = this.cD.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.gk() ? new ItemStack(Items.pX) : ItemStack.l;
    }

    @Override
    public Vec3D u(float f2) {
        float f3;
        double d0 = 0.22 * (this.as() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.h(f2 * 0.5f, this.dZ(), this.ac) * ((float)Math.PI / 180);
        float f22 = MathHelper.h(f2, this.bC, this.bB) * ((float)Math.PI / 180);
        if (!this.fY() && !this.fL()) {
            if (this.cx()) {
                return this.p(f2).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f22));
            }
            double d1 = this.de().c() - 1.0;
            double d2 = this.cu() ? -0.2 : 0.07;
            return this.p(f2).e(new Vec3D(d0, d1, d2).b(-f22));
        }
        Vec3D vec3d = this.h(f2);
        Vec3D vec3d1 = this.dI();
        double d3 = vec3d1.j();
        double d4 = vec3d.j();
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = (vec3d1.g * vec3d.g + vec3d1.i * vec3d.i) / Math.sqrt(d3 * d4);
            double d6 = vec3d1.g * vec3d.i - vec3d1.i * vec3d.g;
            f3 = (float)(Math.signum(d6) * Math.acos(d5));
        } else {
            f3 = 0.0f;
        }
        return this.p(f2).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f22));
    }

    @Override
    public boolean eg() {
        return true;
    }

    public boolean gY() {
        return this.fO() && this.fQ().a(Items.tb);
    }

    @Override
    public boolean ef() {
        return false;
    }

    public Optional<GlobalPos> gZ() {
        return this.cM;
    }

    public void d(Optional<GlobalPos> optional) {
        this.cM = optional;
    }

    @Override
    public float fa() {
        return this.cx;
    }

    @Override
    public void q(float f2) {
        super.q(f2);
        this.cx = f2;
    }

    public boolean ha() {
        return this.d(MobEffects.o);
    }

    @Override
    public boolean ea() {
        return true;
    }

    @Override
    protected float fC() {
        return this.cG.b && !this.cl() ? (this.cv() ? this.cG.a() * 2.0f : this.cG.a()) : (this.cv() ? 0.025999999f : 0.02f);
    }

    public boolean hb() {
        return this.cE || this.co <= 0;
    }

    public void hc() {
        if (!this.cE) {
            --this.co;
        }
    }

    public void w(boolean flag) {
        this.cE = flag;
        if (!this.cE) {
            this.co = 60;
        }
    }

    @Override
    public boolean a(ContainerOpenersCounter containeropenerscounter, BlockPosition blockposition) {
        return containeropenerscounter.a(this);
    }

    @Override
    public double aq() {
        return this.hd();
    }

    public double hd() {
        return this.i(GenericAttributes.g);
    }

    public double he() {
        return this.i(GenericAttributes.k);
    }

    public boolean b(Entity entity, double d0) {
        return entity.ec() ? false : this.a(entity.de(), d0);
    }

    public boolean a(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.he() + d0;
        return axisalignedbb.e(this.bR()) < d1 * d1;
    }

    public boolean a(BlockPosition blockposition, double d0) {
        double d1 = this.hd() + d0;
        return new AxisAlignedBB(blockposition).e(this.bR()) < d1 * d1;
    }

    public void x(boolean flag) {
        this.cN = flag;
        this.cO = flag ? 40 : 0;
    }

    public boolean hf() {
        return this.cN;
    }

    public void hg() {
        if (this.cO == 0) {
            this.hh();
        }
    }

    public void hh() {
        this.cO = 0;
        this.cz = null;
        this.cy = null;
        this.cN = false;
    }

    public boolean hi() {
        return false;
    }

    @Override
    public boolean fe() {
        return this.cG.b ? false : super.fe();
    }

    public String hj() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.ap()).add("id", this.az()).add("pos", (Object)this.dD()).add("mode", (Object)this.a()).add("permission", this.I()).toString();
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

