/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class SpawnerCreature {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 24;
    public static final int a = 8;
    public static final int b = 128;
    public static final int c = MathHelper.d(8.0f / MathHelper.g);
    static final int f = (int)Math.pow(17.0, 2.0);
    private static final EnumCreatureType[] g = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(enumcreaturetype -> enumcreaturetype != EnumCreatureType.h).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d a(int i2, Iterable<Entity> iterable, b spawnercreature_b, LocalMobCapCalculator localmobcapcalculator) {
        SpawnerCreatureProbabilities spawnercreatureprobabilities = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : iterable) {
            EnumCreatureType enumcreaturetype;
            EntityInsentient entityinsentient;
            if (entity instanceof EntityInsentient && ((entityinsentient = (EntityInsentient)entity).gr() || entityinsentient.ae()) || (enumcreaturetype = entity.ax().f()) == EnumCreatureType.h) continue;
            BlockPosition blockposition = entity.dF();
            spawnercreature_b.query(ChunkCoordIntPair.a(blockposition), chunk -> {
                BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(blockposition, (IChunkAccess)chunk).b().a(entity.ax());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.a(entity.dF(), biomesettingsmobs_b.b());
                }
                if (entity instanceof EntityInsentient) {
                    localmobcapcalculator.a(chunk.f(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
            });
        }
        return new d(i2, (Object2IntOpenHashMap<EnumCreatureType>)object2intopenhashmap, spawnercreatureprobabilities, localmobcapcalculator);
    }

    static BiomeBase a(BlockPosition blockposition, IChunkAccess ichunkaccess) {
        return ichunkaccess.getNoiseBiome(QuartPos.a(blockposition.u()), QuartPos.a(blockposition.v()), QuartPos.a(blockposition.w())).a();
    }

    public static List<EnumCreatureType> getFilteredSpawningCategories(d spawnercreature_d, boolean flag, boolean flag1, boolean flag2, WorldServer worldserver) {
        WorldData worlddata = worldserver.F_();
        ArrayList<EnumCreatureType> list = new ArrayList<EnumCreatureType>(g.length);
        for (EnumCreatureType enumcreaturetype : g) {
            boolean spawnThisTick = true;
            int limit = enumcreaturetype.b();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.b() % worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = worldserver.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !flag && enumcreaturetype.d() || !flag1 && !enumcreaturetype.d() || !flag2 && enumcreaturetype.e() || !spawnercreature_d.canSpawnForCategoryGlobal(enumcreaturetype, limit)) continue;
            list.add(enumcreaturetype);
        }
        return list;
    }

    public static void a(WorldServer worldserver, Chunk chunk, d spawnercreature_d, List<EnumCreatureType> list) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("spawner");
        worldserver.timings.mobSpawn.startTiming();
        for (EnumCreatureType enumcreaturetype : list) {
            if (!spawnercreature_d.a(enumcreaturetype, chunk.f())) continue;
            Objects.requireNonNull(spawnercreature_d);
            c spawnercreature_c = spawnercreature_d::a;
            Objects.requireNonNull(spawnercreature_d);
            SpawnerCreature.a(enumcreaturetype, worldserver, chunk, spawnercreature_c, spawnercreature_d::a);
        }
        worldserver.timings.mobSpawn.stopTiming();
        gameprofilerfiller.c();
    }

    public static void a(EnumCreatureType enumcreaturetype, WorldServer worldserver, Chunk chunk, c spawnercreature_c, a spawnercreature_a) {
        BlockPosition blockposition = SpawnerCreature.a((World)worldserver, chunk);
        if (blockposition.v() >= worldserver.M_() + 1) {
            SpawnerCreature.a(enumcreaturetype, worldserver, chunk, blockposition, spawnercreature_c, spawnercreature_a);
        }
    }

    @VisibleForDebug
    public static void a(EnumCreatureType enumcreaturetype, WorldServer worldserver, BlockPosition blockposition) {
        SpawnerCreature.a(enumcreaturetype, worldserver, worldserver.A(blockposition), blockposition, (EntityTypes<?> entitytypes, BlockPosition blockposition1, IChunkAccess ichunkaccess) -> true, (EntityInsentient entityinsentient, IChunkAccess ichunkaccess) -> {});
    }

    public static void a(EnumCreatureType enumcreaturetype, WorldServer worldserver, IChunkAccess ichunkaccess, BlockPosition blockposition, c spawnercreature_c, a spawnercreature_a) {
        StructureManager structuremanager = worldserver.b();
        ChunkGenerator chunkgenerator = worldserver.n().g();
        int i2 = blockposition.v();
        IBlockData iblockdata = ichunkaccess.a_(blockposition);
        if (!iblockdata.d(ichunkaccess, blockposition)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int j2 = 0;
            block0: for (int k2 = 0; k2 < 3; ++k2) {
                int l2 = blockposition.u();
                int i1 = blockposition.w();
                int j1 = 6;
                BiomeSettingsMobs.c biomesettingsmobs_c = null;
                GroupDataEntity groupdataentity = null;
                int k1 = MathHelper.f(worldserver.z.i() * 4.0f);
                int l1 = 0;
                for (int i22 = 0; i22 < k1; ++i22) {
                    double d2;
                    blockposition_mutableblockposition.d(l2 += worldserver.z.a(6) - worldserver.z.a(6), i2, i1 += worldserver.z.a(6) - worldserver.z.a(6));
                    double d0 = (double)l2 + 0.5;
                    double d1 = (double)i1 + 0.5;
                    EntityHuman entityhuman = worldserver.a(d0, (double)i2, d1, -1.0, false);
                    if (entityhuman == null || !SpawnerCreature.a(worldserver, ichunkaccess, blockposition_mutableblockposition, d2 = entityhuman.h(d0, i2, d1))) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<BiomeSettingsMobs.c> optional = SpawnerCreature.a(worldserver, structuremanager, chunkgenerator, enumcreaturetype, worldserver.z, (BlockPosition)blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        k1 = biomesettingsmobs_c.b() + worldserver.z.a(1 + biomesettingsmobs_c.c() - biomesettingsmobs_c.b());
                    }
                    if (!SpawnerCreature.a(worldserver, enumcreaturetype, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2) || !spawnercreature_c.test(biomesettingsmobs_c.a(), blockposition_mutableblockposition, ichunkaccess)) continue;
                    EntityInsentient entityinsentient = SpawnerCreature.a(worldserver, biomesettingsmobs_c.a());
                    if (entityinsentient == null) {
                        return;
                    }
                    entityinsentient.b(d0, i2, d1, worldserver.z.i() * 360.0f, 0.0f);
                    if (!SpawnerCreature.a(worldserver, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.a((WorldAccess)worldserver, worldserver.d_(entityinsentient.dF()), EntitySpawnReason.a, groupdataentity);
                    worldserver.addFreshEntityWithPassengers(entityinsentient, entityinsentient instanceof EntityOcelot && !((Ageable)entityinsentient.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.ec()) {
                        ++j2;
                        ++l1;
                        spawnercreature_a.run(entityinsentient, ichunkaccess);
                    }
                    if (j2 >= entityinsentient.ak()) {
                        return;
                    }
                    if (entityinsentient.q(l1)) continue block0;
                }
            }
        }
    }

    private static boolean a(WorldServer worldserver, IChunkAccess ichunkaccess, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, double d0) {
        if (d0 <= 576.0) {
            return false;
        }
        WorldData.a worlddata_a = worldserver.A();
        if (worlddata_a.a() == worldserver.al() && worlddata_a.b().a(new Vec3D((double)blockposition_mutableblockposition.u() + 0.5, blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + 0.5), 24.0)) {
            return false;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition_mutableblockposition);
        return Objects.equals(chunkcoordintpair, ichunkaccess.f()) || worldserver.c(chunkcoordintpair);
    }

    private static boolean a(WorldServer worldserver, EnumCreatureType enumcreaturetype, StructureManager structuremanager, ChunkGenerator chunkgenerator, BiomeSettingsMobs.c biomesettingsmobs_c, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, double d0) {
        EntityTypes<?> entitytypes = biomesettingsmobs_c.a();
        return entitytypes.f() == EnumCreatureType.h ? false : (!entitytypes.e() && d0 > (double)(entitytypes.f().f() * entitytypes.f().f()) ? false : (entitytypes.c() && SpawnerCreature.a(worldserver, structuremanager, chunkgenerator, enumcreaturetype, biomesettingsmobs_c, (BlockPosition)blockposition_mutableblockposition) ? (!EntityPositionTypes.a(entitytypes, worldserver, blockposition_mutableblockposition) ? false : (!EntityPositionTypes.a(entitytypes, worldserver, EntitySpawnReason.a, blockposition_mutableblockposition, worldserver.z) ? false : worldserver.b(entitytypes.a((double)blockposition_mutableblockposition.u() + 0.5, blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + 0.5)))) : false));
    }

    @Nullable
    private static EntityInsentient a(WorldServer worldserver, EntityTypes<?> entitytypes) {
        try {
            Object entity = entitytypes.a(worldserver, EntitySpawnReason.a);
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                return entityinsentient;
            }
            d.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.g.b(entitytypes));
        }
        catch (Exception exception) {
            d.warn("Failed to create mob", (Throwable)exception);
        }
        return null;
    }

    private static boolean a(WorldServer worldserver, EntityInsentient entityinsentient, double d0) {
        return d0 > (double)(entityinsentient.ax().f().f() * entityinsentient.ax().f().f()) && entityinsentient.i(d0) ? false : entityinsentient.a((GeneratorAccess)worldserver, EntitySpawnReason.a) && entityinsentient.a((IWorldReader)worldserver);
    }

    private static Optional<BiomeSettingsMobs.c> a(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, RandomSource randomsource, BlockPosition blockposition) {
        Holder<BiomeBase> holder = worldserver.v(blockposition);
        return enumcreaturetype == EnumCreatureType.g && holder.a(BiomeTags.ao) && randomsource.i() < 0.98f ? Optional.empty() : SpawnerCreature.a(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, holder).a(randomsource);
    }

    private static boolean a(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, BiomeSettingsMobs.c biomesettingsmobs_c, BlockPosition blockposition) {
        return SpawnerCreature.a(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, (Holder<BiomeBase>)null).b(biomesettingsmobs_c);
    }

    private static WeightedList<BiomeSettingsMobs.c> a(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, BlockPosition blockposition, @Nullable Holder<BiomeBase> holder) {
        return SpawnerCreature.a(blockposition, worldserver, enumcreaturetype, structuremanager) ? NetherFortressStructure.d : chunkgenerator.a(holder != null ? holder : worldserver.v(blockposition), structuremanager, enumcreaturetype, blockposition);
    }

    public static boolean a(BlockPosition blockposition, WorldServer worldserver, EnumCreatureType enumcreaturetype, StructureManager structuremanager) {
        if (enumcreaturetype == EnumCreatureType.a && worldserver.a_(blockposition.e()).a(Blocks.gc)) {
            Structure structure = structuremanager.b().f(Registries.bm).c(BuiltinStructures.o);
            return structure == null ? false : structuremanager.a(blockposition, structure).b();
        }
        return false;
    }

    private static BlockPosition a(World world, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.d() + world.z.a(16);
        int j2 = chunkcoordintpair.e() + world.z.a(16);
        int k2 = chunk.a(HeightMap.Type.b, i2, j2) + 1;
        int l2 = MathHelper.b(world.z, world.M_(), k2);
        return new BlockPosition(i2, l2, j2);
    }

    public static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, EntityTypes<?> entitytypes) {
        return iblockdata.m(iblockaccess, blockposition) ? false : (iblockdata.p() ? false : (!fluid.c() ? false : (iblockdata.a(TagsBlock.bj) ? false : !entitytypes.a(iblockdata))));
    }

    public static void a(WorldAccess worldaccess, Holder<BiomeBase> holder, ChunkCoordIntPair chunkcoordintpair, RandomSource randomsource) {
        BiomeSettingsMobs biomesettingsmobs = holder.a().b();
        WeightedList<BiomeSettingsMobs.c> weightedlist = biomesettingsmobs.a(EnumCreatureType.b);
        if (!weightedlist.c()) {
            int i2 = chunkcoordintpair.d();
            int j2 = chunkcoordintpair.e();
            while (randomsource.i() < biomesettingsmobs.a()) {
                Optional<BiomeSettingsMobs.c> optional = weightedlist.a(randomsource);
                if (optional.isEmpty()) continue;
                BiomeSettingsMobs.c biomesettingsmobs_c = optional.get();
                int k2 = biomesettingsmobs_c.b() + randomsource.a(1 + biomesettingsmobs_c.c() - biomesettingsmobs_c.b());
                GroupDataEntity groupdataentity = null;
                int l2 = i2 + randomsource.a(16);
                int i1 = j2 + randomsource.a(16);
                int j1 = l2;
                int k1 = i1;
                for (int l1 = 0; l1 < k2; ++l1) {
                    boolean flag = false;
                    for (int i22 = 0; !flag && i22 < 4; ++i22) {
                        BlockPosition blockposition = SpawnerCreature.a((IWorldReader)worldaccess, biomesettingsmobs_c.a(), l2, i1);
                        if (biomesettingsmobs_c.a().c() && EntityPositionTypes.a(biomesettingsmobs_c.a(), worldaccess, blockposition)) {
                            EntityInsentient entityinsentient;
                            Object entity;
                            float f2 = biomesettingsmobs_c.a().l();
                            double d0 = MathHelper.a((double)l2, (double)i2 + (double)f2, (double)i2 + 16.0 - (double)f2);
                            double d1 = MathHelper.a((double)i1, (double)j2 + (double)f2, (double)j2 + 16.0 - (double)f2);
                            if (!worldaccess.b(biomesettingsmobs_c.a().a(d0, blockposition.v(), d1)) || !EntityPositionTypes.a(biomesettingsmobs_c.a(), worldaccess, EntitySpawnReason.b, BlockPosition.a(d0, (double)blockposition.v(), d1), worldaccess.I_())) continue;
                            try {
                                entity = biomesettingsmobs_c.a().a(worldaccess.a(), EntitySpawnReason.a);
                            }
                            catch (Exception exception) {
                                d.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).b(d0, blockposition.v(), d1, randomsource.i() * 360.0f, 0.0f);
                            if (entity instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).a(worldaccess, EntitySpawnReason.b) && entityinsentient.a(worldaccess)) {
                                groupdataentity = entityinsentient.a(worldaccess, worldaccess.d_(entityinsentient.dF()), EntitySpawnReason.b, groupdataentity);
                                worldaccess.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l2 += randomsource.a(5) - randomsource.a(5);
                        i1 += randomsource.a(5) - randomsource.a(5);
                        while (l2 < i2 || l2 >= i2 + 16 || i1 < j2 || i1 >= j2 + 16) {
                            l2 = j1 + randomsource.a(5) - randomsource.a(5);
                            i1 = k1 + randomsource.a(5) - randomsource.a(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPosition a(IWorldReader iworldreader, EntityTypes<?> entitytypes, int i2, int j2) {
        int k2 = iworldreader.a(EntityPositionTypes.b(entitytypes), i2, j2);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, k2, j2);
        if (iworldreader.H_().h()) {
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (!iworldreader.a_(blockposition_mutableblockposition).l());
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (iworldreader.a_(blockposition_mutableblockposition).l() && blockposition_mutableblockposition.v() > iworldreader.M_());
        }
        return EntityPositionTypes.a(entitytypes).a(iworldreader, blockposition_mutableblockposition.j());
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int a;
        private final Object2IntOpenHashMap<EnumCreatureType> b;
        private final SpawnerCreatureProbabilities c;
        private final Object2IntMap<EnumCreatureType> d;
        private final LocalMobCapCalculator e;
        @Nullable
        private BlockPosition f;
        @Nullable
        private EntityTypes<?> g;
        private double h;

        d(int i2, Object2IntOpenHashMap<EnumCreatureType> object2intopenhashmap, SpawnerCreatureProbabilities spawnercreatureprobabilities, LocalMobCapCalculator localmobcapcalculator) {
            this.a = i2;
            this.b = object2intopenhashmap;
            this.c = spawnercreatureprobabilities;
            this.e = localmobcapcalculator;
            this.d = Object2IntMaps.unmodifiable(object2intopenhashmap);
        }

        private boolean a(EntityTypes<?> entitytypes, BlockPosition blockposition, IChunkAccess ichunkaccess) {
            double d0;
            this.f = blockposition;
            this.g = entitytypes;
            BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(blockposition, ichunkaccess).b().a(entitytypes);
            if (biomesettingsmobs_b == null) {
                this.h = 0.0;
                return true;
            }
            this.h = d0 = biomesettingsmobs_b.b();
            double d1 = this.c.b(blockposition, d0);
            return d1 <= biomesettingsmobs_b.a();
        }

        private void a(EntityInsentient entityinsentient, IChunkAccess ichunkaccess) {
            BiomeSettingsMobs.b biomesettingsmobs_b;
            EntityTypes<?> entitytypes = entityinsentient.ax();
            BlockPosition blockposition = entityinsentient.dF();
            double d0 = blockposition.equals(this.f) && entitytypes == this.g ? this.h : ((biomesettingsmobs_b = SpawnerCreature.a(blockposition, ichunkaccess).b().a(entitytypes)) != null ? biomesettingsmobs_b.b() : 0.0);
            this.c.a(blockposition, d0);
            EnumCreatureType enumcreaturetype = entitytypes.f();
            this.b.addTo((Object)enumcreaturetype, 1);
            this.e.a(new ChunkCoordIntPair(blockposition), enumcreaturetype);
        }

        public int a() {
            return this.a;
        }

        public Object2IntMap<EnumCreatureType> b() {
            return this.d;
        }

        boolean canSpawnForCategoryGlobal(EnumCreatureType enumcreaturetype, int limit) {
            int i2 = limit * this.a / f;
            return this.b.getInt((Object)enumcreaturetype) < i2;
        }

        boolean a(EnumCreatureType enumcreaturetype, ChunkCoordIntPair chunkcoordintpair) {
            return this.e.a(enumcreaturetype, chunkcoordintpair) || SharedConstants.ay;
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }
}

