/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<BlockCampfire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(blockcampfire -> blockcampfire.i), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(blockcampfire -> blockcampfire.D), BlockCampfire.x()).apply((Applicative)instance, BlockCampfire::new));
    public static final BlockStateBoolean b = BlockProperties.u;
    public static final BlockStateBoolean c = BlockProperties.D;
    public static final BlockStateBoolean d = BlockProperties.I;
    public static final BlockStateEnum<EnumDirection> e = BlockProperties.T;
    private static final VoxelShape f = Block.b(16.0, 0.0, 7.0);
    private static final VoxelShape g = Block.b(4.0, 0.0, 16.0);
    private static final int h = 5;
    private final boolean i;
    private final int D;

    public MapCodec<BlockCampfire> a() {
        return a;
    }

    public BlockCampfire(boolean flag, int i2, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.i = flag;
        this.D = i2;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, true)).b(c, false)).b(d, false)).b(e, EnumDirection.c));
    }

    @Override
    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof TileEntityCampfire) {
            TileEntityCampfire tileentitycampfire = (TileEntityCampfire)tileentity;
            ItemStack itemstack1 = entityhuman.b(enumhand);
            if (world.V().a(RecipePropertySet.h).a(itemstack1)) {
                WorldServer worldserver;
                if (world instanceof WorldServer && tileentitycampfire.a(worldserver = (WorldServer)world, entityhuman, itemstack1)) {
                    entityhuman.a(StatisticList.aw);
                    return EnumInteractionResult.b;
                }
                return EnumInteractionResult.c;
            }
        }
        return EnumInteractionResult.f;
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (iblockdata.c(b).booleanValue() && entity instanceof EntityLiving) {
            entity.a(world.an().b().directBlock(world, blockposition), (float)this.D);
        }
        super.a(iblockdata, world, blockposition, entity, insideblockeffectapplier, flag);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        BlockPosition blockposition;
        World generatoraccess = blockactioncontext.q();
        boolean flag = generatoraccess.b_(blockposition = blockactioncontext.a()).a() == FluidTypes.c;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(d, flag)).b(c, this.p(generatoraccess.a_(blockposition.e())))).b(b, !flag)).b(e, blockactioncontext.g());
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(d).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return enumdirection == EnumDirection.a ? (IBlockData)iblockdata.b(c, this.p(iblockdata1)) : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private boolean p(IBlockData iblockdata) {
        return iblockdata.a(Blocks.jb);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return f;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue()) {
            if (randomsource.a(10) == 0) {
                world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.dN, SoundCategory.e, 0.5f + randomsource.i(), randomsource.i() * 0.7f + 0.6f, false);
            }
            if (this.i && randomsource.a(5) == 0) {
                for (int i2 = 0; i2 < randomsource.a(1) + 1; ++i2) {
                    world.a(Particles.ac, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, (double)(randomsource.i() / 2.0f), 5.0E-5, randomsource.i() / 2.0f);
                }
            }
        }
    }

    public static void a(@Nullable Entity entity, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        if (generatoraccess.D_()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.a((World)generatoraccess, blockposition, iblockdata.c(c), true);
            }
        }
        generatoraccess.a(entity, GameEvent.c, blockposition);
    }

    @Override
    public boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid) {
        if (!iblockdata.c(BlockProperties.I).booleanValue() && fluid.a() == FluidTypes.c) {
            boolean flag = iblockdata.c(b);
            if (flag) {
                if (!generatoraccess.D_()) {
                    generatoraccess.a((Entity)null, blockposition, SoundEffects.lx, SoundCategory.e, 1.0f, 1.0f);
                }
                BlockCampfire.a((Entity)null, generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.a(blockposition, (IBlockData)((IBlockData)iblockdata.b(d, true)).b(b, false), 3);
            generatoraccess.a(blockposition, fluid.a(), fluid.a().a(generatoraccess));
            return true;
        }
        return false;
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition = movingobjectpositionblock.b();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (iprojectile.ck() && iprojectile.c(worldserver, blockposition) && !iblockdata.c(b).booleanValue() && !iblockdata.c(d).booleanValue()) {
                if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, iprojectile).isCancelled()) {
                    return;
                }
                world.a(blockposition, (IBlockData)iblockdata.b(BlockProperties.u, true), 11);
            }
        }
    }

    public static void a(World world, BlockPosition blockposition, boolean flag, boolean flag1) {
        RandomSource randomsource = world.I_();
        ParticleType particletype = flag ? Particles.ay : Particles.ax;
        world.a(particletype, true, (double)blockposition.u() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), (double)blockposition.v() + randomsource.j() + randomsource.j(), (double)blockposition.w() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.07, 0.0);
        if (flag1) {
            world.a(Particles.ai, (double)blockposition.u() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), (double)blockposition.v() + 0.4, (double)blockposition.w() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean a(World world, BlockPosition blockposition) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockposition1 = blockposition.c(i2);
            IBlockData iblockdata = world.a_(blockposition1);
            if (BlockCampfire.h(iblockdata)) {
                return true;
            }
            boolean flag = VoxelShapes.c(g, iblockdata.b((IBlockAccess)world, blockposition, VoxelShapeCollision.a()), OperatorBoolean.i);
            if (!flag) continue;
            IBlockData iblockdata1 = world.a_(blockposition1.e());
            return BlockCampfire.h(iblockdata1);
        }
        return false;
    }

    public static boolean h(IBlockData iblockdata) {
        return iblockdata.b(b) && iblockdata.a(TagsBlock.bh) && iblockdata.c(b) != false;
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(d) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.b(e, enumblockrotation.a(iblockdata.c(e)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(e)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, c, d, e);
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityCampfire(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (iblockdata.c(b).booleanValue()) {
                CraftingManager.a craftingmanager_a = CraftingManager.a(Recipes.e);
                return BlockCampfire.a(tileentitytypes, TileEntityTypes.H, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E tileentitycampfire) -> TileEntityCampfire.a(worldserver, blockposition, iblockdata1, tileentitycampfire, craftingmanager_a));
            }
            return BlockCampfire.a(tileentitytypes, TileEntityTypes.H, TileEntityCampfire::a);
        }
        return iblockdata.c(b) != false ? BlockCampfire.a(tileentitytypes, TileEntityTypes.H, TileEntityCampfire::b) : null;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    public static boolean i(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bh, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(d) && blockbase_blockdata.b(b)) && iblockdata.c(d) == false && iblockdata.c(b) == false;
    }
}

