/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.block.Action;

public class SculkShriekerBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkShriekerBlock> a = SculkShriekerBlock.b(SculkShriekerBlock::new);
    public static final BlockStateBoolean b = BlockProperties.C;
    public static final BlockStateBoolean c = BlockProperties.I;
    public static final BlockStateBoolean d = BlockProperties.e;
    private static final VoxelShape f = Block.b(16.0, 0.0, 8.0);
    public static final double e = f.c(EnumDirection.EnumAxis.b);

    public MapCodec<SculkShriekerBlock> a() {
        return a;
    }

    public SculkShriekerBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, false)).b(c, false)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
        blockstatelist_a.a(new IBlockState[]{c});
        blockstatelist_a.a(new IBlockState[]{d});
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = SculkShriekerBlockEntity.a(entity);
            if (entityplayer != null) {
                if (CraftEventFactory.callPlayerInteractEvent(entityplayer, Action.PHYSICAL, blockposition, null, null, null).isCancelled()) {
                    return;
                }
                worldserver.a(blockposition, TileEntityTypes.M).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver, entityplayer));
            }
        }
        super.a(world, blockposition, iblockdata, entity);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue()) {
            worldserver.a(blockposition, (IBlockData)iblockdata.b(b, false), 3);
            worldserver.a(blockposition, TileEntityTypes.M).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver));
        }
    }

    @Override
    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return f;
    }

    @Override
    protected VoxelShape f_(IBlockData iblockdata) {
        return f;
    }

    @Override
    protected boolean g_(IBlockData iblockdata) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new SculkShriekerBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(c).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        return (IBlockData)this.m().b(c, blockactioncontext.q().b_(blockactioncontext.a()).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(c) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.a(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return !world.D_() ? BlockTileEntity.a(tileentitytypes, TileEntityTypes.M, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculkshriekerblockentity) -> VibrationSystem.c.a(world1, sculkshriekerblockentity.gJ(), sculkshriekerblockentity.gK())) : null;
    }
}

