/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.f e = (iblockdata, iblockaccess, blockposition) -> iblockdata.a(Blocks.cK);
    private static final float f = 4.0f;
    private static final double g = 1.0;
    private final EnumDirection.EnumAxis h;
    private final EnumDirection i;
    private final int j;
    private final BlockPosition k;
    private final int l;
    private final int m;
    private final BlockStateListPopulator blocks;

    private BlockPortalShape(EnumDirection.EnumAxis enumdirection_enumaxis, int i2, EnumDirection enumdirection, BlockPosition blockposition, int j2, int k2, BlockStateListPopulator blocks) {
        this.blocks = blocks;
        this.h = enumdirection_enumaxis;
        this.j = i2;
        this.i = enumdirection;
        this.k = blockposition;
        this.m = j2;
        this.l = k2;
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        return BlockPortalShape.a(generatoraccess, blockposition, (BlockPortalShape blockportalshape) -> blockportalshape.a() && blockportalshape.j == 0, enumdirection_enumaxis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess generatoraccess, BlockPosition blockposition, Predicate<BlockPortalShape> predicate, EnumDirection.EnumAxis enumdirection_enumaxis) {
        Optional<BlockPortalShape> optional = Optional.of(BlockPortalShape.a((IBlockAccess)generatoraccess, blockposition, enumdirection_enumaxis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(BlockPortalShape.a((IBlockAccess)generatoraccess, blockposition, enumdirection_enumaxis1)).filter(predicate);
    }

    public static BlockPortalShape a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        BlockStateListPopulator blocks;
        EnumDirection enumdirection = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        BlockPosition blockposition1 = BlockPortalShape.calculateBottomLeft(iblockaccess, enumdirection, blockposition, blocks = new BlockStateListPopulator(((GeneratorAccess)iblockaccess).getMinecraftWorld()));
        if (blockposition1 == null) {
            return new BlockPortalShape(enumdirection_enumaxis, 0, enumdirection, blockposition, 0, 0, blocks);
        }
        int i2 = BlockPortalShape.calculateWidth(iblockaccess, blockposition1, enumdirection, blocks);
        if (i2 == 0) {
            return new BlockPortalShape(enumdirection_enumaxis, 0, enumdirection, blockposition1, 0, 0, blocks);
        }
        MutableInt mutableint = new MutableInt();
        int j2 = BlockPortalShape.calculateHeight(iblockaccess, blockposition1, enumdirection, i2, mutableint, blocks);
        return new BlockPortalShape(enumdirection_enumaxis, mutableint.getValue(), enumdirection, blockposition1, i2, j2, blocks);
    }

    @Nullable
    private static BlockPosition calculateBottomLeft(IBlockAccess iblockaccess, EnumDirection enumdirection, BlockPosition blockposition, BlockStateListPopulator blocks) {
        int i2 = Math.max(iblockaccess.M_(), blockposition.v() - 21);
        while (blockposition.v() > i2 && BlockPortalShape.a(iblockaccess.a_(blockposition.e()))) {
            blockposition = blockposition.e();
        }
        EnumDirection enumdirection1 = enumdirection.g();
        int j2 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection1, blocks) - 1;
        return j2 < 0 ? null : blockposition.a(enumdirection1, j2);
    }

    private static int calculateWidth(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockStateListPopulator blocks) {
        int i2 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection, blocks);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private static int getDistanceUntilEdgeAboveFrame(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.g(blockposition).c(enumdirection, i2);
            IBlockData iblockdata = iblockaccess.a_(blockposition_mutableblockposition);
            if (!BlockPortalShape.a(iblockdata)) {
                if (!e.test(iblockdata, iblockaccess, blockposition_mutableblockposition)) break;
                blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = iblockaccess.a_(blockposition_mutableblockposition.c(EnumDirection.a));
            if (!e.test(iblockdata1, iblockaccess, blockposition_mutableblockposition)) break;
            blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private static int calculateHeight(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, int i2, MutableInt mutableint, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int j2 = BlockPortalShape.getDistanceUntilTop(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i2, mutableint, blocks);
        return j2 >= 3 && j2 <= 21 && BlockPortalShape.hasTopFrame(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i2, j2, blocks) ? j2 : 0;
    }

    private static boolean hasTopFrame(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2, int j2, BlockStateListPopulator blocks) {
        for (int k2 = 0; k2 < i2; ++k2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, k2);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition1), iblockaccess, blockposition_mutableblockposition1)) {
                return false;
            }
            blocks.a((BlockPosition)blockposition_mutableblockposition1, iblockaccess.a_(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private static int getDistanceUntilTop(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2, MutableInt mutableint, BlockStateListPopulator blocks) {
        for (int j2 = 0; j2 < 21; ++j2) {
            blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, -1);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j2;
            }
            blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, i2);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j2;
            }
            for (int k2 = 0; k2 < i2; ++k2) {
                blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, k2);
                IBlockData iblockdata = iblockaccess.a_(blockposition_mutableblockposition);
                if (!BlockPortalShape.a(iblockdata)) {
                    return j2;
                }
                if (!iblockdata.a(Blocks.eI)) continue;
                mutableint.increment();
            }
            blocks.a((BlockPosition)blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, -1), iblockaccess.a_(blockposition_mutableblockposition), 18);
            blocks.a((BlockPosition)blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, i2), iblockaccess.a_(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData iblockdata) {
        return iblockdata.l() || iblockdata.a(TagsBlock.aY) || iblockdata.a(Blocks.eI);
    }

    public boolean a() {
        return this.m >= 2 && this.m <= 21 && this.l >= 3 && this.l <= 21;
    }

    public boolean createPortalBlocks(GeneratorAccess generatoraccess, net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = generatoraccess.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.eI.m().b(BlockPortal.b, this.h);
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(blockposition -> this.blocks.a((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        generatoraccess.getMinecraftWorld().q().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(blockposition -> generatoraccess.a((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean b() {
        return this.a() && this.j == this.m * this.l;
    }

    public static Vec3D a(BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, EntitySize entitysize) {
        double d4;
        double d2;
        double d0 = (double)blockutil_rectangle.b - (double)entitysize.a();
        double d1 = (double)blockutil_rectangle.c - (double)entitysize.b();
        BlockPosition blockposition = blockutil_rectangle.a;
        if (d0 > 0.0) {
            double d3 = (double)blockposition.a(enumdirection_enumaxis) + (double)entitysize.a() / 2.0;
            d2 = MathHelper.a(MathHelper.c(vec3d.a(enumdirection_enumaxis) - d3, 0.0, d0), 0.0, 1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            EnumDirection.EnumAxis enumdirection_enumaxis1 = EnumDirection.EnumAxis.b;
            d4 = MathHelper.a(MathHelper.c(vec3d.a(enumdirection_enumaxis1) - (double)blockposition.a(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d4 = 0.0;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis2 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d5 = vec3d.a(enumdirection_enumaxis2) - ((double)blockposition.a(enumdirection_enumaxis2) + 0.5);
        return new Vec3D(d2, d4, d5);
    }

    public static Vec3D a(Vec3D vec3d, WorldServer worldserver, net.minecraft.world.entity.Entity entity, EntitySize entitysize) {
        if (entitysize.a() <= 4.0f && entitysize.b() <= 4.0f) {
            double d0 = (double)entitysize.b() / 2.0;
            Vec3D vec3d1 = vec3d.b(0.0, d0, 0.0);
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, entitysize.a(), 0.0, entitysize.a()).b(0.0, 1.0, 0.0).g(1.0E-6));
            Optional<Vec3D> optional = worldserver.a(entity, voxelshape, vec3d1, (double)entitysize.a(), (double)entitysize.b(), (double)entitysize.a());
            Optional<Vec3D> optional1 = optional.map(vec3d2 -> vec3d2.a(0.0, d0, 0.0));
            return optional1.orElse(vec3d);
        }
        return vec3d;
    }
}

