/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftLootable<TileEntityChest>
implements Chest {
    public CraftChest(World world, TileEntityChest tileEntity) {
        super(world, tileEntity);
    }

    protected CraftChest(CraftChest state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((IInventory)this.getSnapshot());
    }

    public Inventory getBlockInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((IInventory)this.getTileEntity());
    }

    public Inventory getInventory() {
        CraftInventory inventory = (CraftInventory)this.getBlockInventory();
        if (!this.isPlaced() || this.isWorldGeneration()) {
            return inventory;
        }
        CraftWorld world = (CraftWorld)this.getWorld();
        BlockChest blockChest = (BlockChest)(this.getType() == Material.CHEST ? Blocks.cS : Blocks.hM);
        ITileInventory nms = blockChest.getMenuProvider(this.data, world.getHandle(), this.getPosition(), true);
        if (nms instanceof BlockChest.DoubleInventory) {
            inventory = new CraftInventoryDoubleChest((BlockChest.DoubleInventory)nms);
        }
        return inventory;
    }

    public void open() {
        this.requirePlaced();
        if (!((TileEntityChest)this.getTileEntity()).g.opened && this.getWorldHandle() instanceof net.minecraft.world.level.World) {
            IBlockData block = ((TileEntityChest)this.getTileEntity()).o();
            int openCount = ((TileEntityChest)this.getTileEntity()).g.a();
            ((TileEntityChest)this.getTileEntity()).g.onAPIOpen((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block);
            ((TileEntityChest)this.getTileEntity()).g.openerAPICountChanged((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block, openCount, openCount + 1);
        }
        ((TileEntityChest)this.getTileEntity()).g.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((TileEntityChest)this.getTileEntity()).g.opened && this.getWorldHandle() instanceof net.minecraft.world.level.World) {
            IBlockData block = ((TileEntityChest)this.getTileEntity()).o();
            int openCount = ((TileEntityChest)this.getTileEntity()).g.a();
            ((TileEntityChest)this.getTileEntity()).g.onAPIClose((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block);
            ((TileEntityChest)this.getTileEntity()).g.openerAPICountChanged((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block, openCount, 0);
        }
        ((TileEntityChest)this.getTileEntity()).g.opened = false;
    }

    @Override
    public CraftChest copy() {
        return new CraftChest(this, null);
    }

    @Override
    public CraftChest copy(Location location) {
        return new CraftChest(this, location);
    }
}

