/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftOldEnumRegistryItem;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, EntityVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityVillager getHandle() {
        return (EntityVillager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().hl();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit(this.getHandle().gR().b());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().a(this.getHandle().gR().b(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gR().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().a(this.getHandle().gR().a(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().gR().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().a(this.getHandle().gR().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().s();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().t(experience);
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPosition position = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().an().a_(position);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().gh();
    }

    public void shakeHead() {
        this.getHandle().he();
    }

    public ZombieVillager zombify() {
        EntityZombieVillager entityzombievillager = EntityZombie.convertVillagerToZombieVillager(this.getHandle().an().getMinecraftWorld(), this.getHandle(), this.getHandle().dF(), this.isSilent(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public int getReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().hd().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), false);
    }

    public int getWeightedReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().hd().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), true);
    }

    public int getReputation(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getHandle().hd().a(uuid, reputationType -> true);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.addReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hd().add(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.removeReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hd().remove(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.setReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hd().set(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setGossipDecayTime(long ticks) {
        this.getHandle().gossipDecayInterval = ticks;
    }

    public long getGossipDecayTime() {
        return this.getHandle().gossipDecayInterval;
    }

    public static class CraftProfession
    extends CraftOldEnumRegistryItem<Villager.Profession, VillagerProfession>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftToBukkit(VillagerProfession minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, Registries.aI, Registry.VILLAGER_PROFESSION);
        }

        public static Villager.Profession minecraftHolderToBukkit(Holder<VillagerProfession> minecraft) {
            return CraftProfession.minecraftToBukkit(minecraft.a());
        }

        public static VillagerProfession bukkitToMinecraft(Villager.Profession bukkit) {
            return (VillagerProfession)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<VillagerProfession> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aI);
            Holder<VillagerProfession> holder = registry.e(CraftProfession.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager profession without properly registering it.");
        }

        public CraftProfession(NamespacedKey key, Holder<VillagerProfession> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftType
    extends CraftOldEnumRegistryItem<Villager.Type, VillagerType>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(VillagerType minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.aJ, Registry.VILLAGER_TYPE);
        }

        public static Villager.Type minecraftHolderToBukkit(Holder<VillagerType> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static VillagerType bukkitToMinecraft(Villager.Type bukkit) {
            return (VillagerType)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<VillagerType> bukkitToMinecraftHolder(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aJ);
            Holder<VillagerType> holder = registry.e(CraftType.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager type without properly registering it.");
        }

        public CraftType(NamespacedKey key, Holder<VillagerType> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftReputationType
    implements Villager.ReputationType,
    Handleable<ReputationType> {
        public static final Map<String, CraftReputationType> BY_ID = Stream.of(ReputationType.values()).collect(Collectors.toMap(reputationType -> reputationType.i, CraftReputationType::new));
        private final ReputationType handle;

        public CraftReputationType(ReputationType handle) {
            this.handle = handle;
        }

        @Override
        public ReputationType getHandle() {
            return this.handle;
        }

        public int getMaxValue() {
            return this.handle.k;
        }

        public int getWeight() {
            return this.handle.j;
        }

        public static ReputationType bukkitToMinecraft(Villager.ReputationType bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationType)bukkit).getHandle();
        }

        public static Villager.ReputationType minecraftToBukkit(ReputationType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            return switch (minecraft) {
                default -> throw new MatchException(null, null);
                case ReputationType.a -> Villager.ReputationType.MAJOR_NEGATIVE;
                case ReputationType.b -> Villager.ReputationType.MINOR_NEGATIVE;
                case ReputationType.c -> Villager.ReputationType.MINOR_POSITIVE;
                case ReputationType.d -> Villager.ReputationType.MAJOR_POSITIVE;
                case ReputationType.e -> Villager.ReputationType.TRADING;
            };
        }
    }

    public static class CraftReputationEvent
    implements Villager.ReputationEvent,
    Handleable<ReputationEvent> {
        private static final Map<String, Villager.ReputationEvent> ALL = Maps.newHashMap();
        private final ReputationEvent handle;

        public CraftReputationEvent(ReputationEvent handle) {
            this.handle = handle;
            ALL.put(handle.toString(), this);
        }

        @Override
        public ReputationEvent getHandle() {
            return this.handle;
        }

        public static ReputationEvent bukkitToMinecraft(Villager.ReputationEvent bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationEvent)bukkit).getHandle();
        }

        public static Villager.ReputationEvent minecraftToBukkit(ReputationEvent minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            Villager.ReputationEvent bukkit = ALL.get(minecraft.toString());
            return bukkit == null ? new CraftReputationEvent(minecraft) : bukkit;
        }
    }
}

