/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.util.Util;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3i;

public enum SymmetricGroup3 {
    P123(0, 1, 2),
    P213(1, 0, 2),
    P132(0, 2, 1),
    P312(2, 0, 1),
    P231(1, 2, 0),
    P321(2, 1, 0);

    private final int p0;
    private final int p1;
    private final int p2;
    private final Matrix3fc transformation;
    private static final SymmetricGroup3[][] CAYLEY_TABLE;
    private static final SymmetricGroup3[] INVERSE_TABLE;

    private SymmetricGroup3(int var2, int var3, int var4) {
        this.p0 = var2;
        this.p1 = var3;
        this.p2 = var4;
        this.transformation = new Matrix3f().zero().set(this.permute(0), 0, 1.0f).set(this.permute(1), 1, 1.0f).set(this.permute(2), 2, 1.0f);
    }

    public SymmetricGroup3 compose(SymmetricGroup3 var0) {
        return CAYLEY_TABLE[this.ordinal()][var0.ordinal()];
    }

    public SymmetricGroup3 inverse() {
        return INVERSE_TABLE[this.ordinal()];
    }

    public int permute(int var0) {
        return switch (var0) {
            case 0 -> this.p0;
            case 1 -> this.p1;
            case 2 -> this.p2;
            default -> throw new IllegalArgumentException("Must be 0, 1 or 2, but got " + var0);
        };
    }

    public Direction.Axis permuteAxis(Direction.Axis var0) {
        return Direction.Axis.VALUES[this.permute(var0.ordinal())];
    }

    public Vector3f permuteVector(Vector3f var0) {
        float var1 = var0.get(this.p0);
        float var2 = var0.get(this.p1);
        float var3 = var0.get(this.p2);
        return var0.set(var1, var2, var3);
    }

    public Vector3i permuteVector(Vector3i var0) {
        int var1 = var0.get(this.p0);
        int var2 = var0.get(this.p1);
        int var3 = var0.get(this.p2);
        return var0.set(var1, var2, var3);
    }

    public Matrix3fc transformation() {
        return this.transformation;
    }

    static {
        CAYLEY_TABLE = Util.make(() -> {
            SymmetricGroup3[] var0 = SymmetricGroup3.values();
            SymmetricGroup3[][] var1 = new SymmetricGroup3[var0.length][var0.length];
            for (SymmetricGroup3 var5 : var0) {
                for (SymmetricGroup3 var9 : var0) {
                    SymmetricGroup3 var13;
                    int var10 = var5.permute(var9.p0);
                    int var11 = var5.permute(var9.p1);
                    int var12 = var5.permute(var9.p2);
                    var1[var5.ordinal()][var9.ordinal()] = var13 = Arrays.stream(var0).filter(var3 -> var3.p0 == var10 && var3.p1 == var11 && var3.p2 == var12).findFirst().get();
                }
            }
            return var1;
        });
        INVERSE_TABLE = Util.make(() -> {
            SymmetricGroup3[] var02 = SymmetricGroup3.values();
            return (SymmetricGroup3[])Arrays.stream(var02).map(var0 -> Arrays.stream(SymmetricGroup3.values()).filter(var1 -> var0.compose((SymmetricGroup3)((Object)((Object)((Object)var1)))) == P123).findAny().get()).toArray(SymmetricGroup3[]::new);
        });
    }
}

