/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Util;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ContextAwarePredicate {
    public static final Codec<ContextAwarePredicate> CODEC = LootItemCondition.DIRECT_CODEC.listOf().xmap(ContextAwarePredicate::new, var0 -> var0.conditions);
    private final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositePredicates;

    ContextAwarePredicate(List<LootItemCondition> var0) {
        this.conditions = var0;
        this.compositePredicates = Util.allOf(var0);
    }

    public static ContextAwarePredicate create(LootItemCondition ... var0) {
        return new ContextAwarePredicate(List.of(var0));
    }

    public boolean matches(LootContext var0) {
        return this.compositePredicates.test(var0);
    }

    public void validate(ValidationContext var0) {
        for (int var1 = 0; var1 < this.conditions.size(); ++var1) {
            LootItemCondition var2 = this.conditions.get(var1);
            var2.validate(var0.forChild(new ProblemReporter.IndexedPathElement(var1)));
        }
    }
}

