/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public record StatePropertiesPredicate(List<PropertyMatcher> properties) {
    private static final Codec<List<PropertyMatcher>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ValueMatcher.CODEC).xmap(var02 -> var02.entrySet().stream().map(var0 -> new PropertyMatcher((String)var0.getKey(), (ValueMatcher)var0.getValue())).toList(), var0 -> var0.stream().collect(Collectors.toMap(PropertyMatcher::name, PropertyMatcher::valueMatcher)));
    public static final Codec<StatePropertiesPredicate> CODEC = PROPERTIES_CODEC.xmap(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);
    public static final StreamCodec<ByteBuf, StatePropertiesPredicate> STREAM_CODEC = PropertyMatcher.STREAM_CODEC.apply(ByteBufCodecs.list()).map(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> var0, S var1) {
        for (PropertyMatcher var3 : this.properties) {
            if (var3.match(var0, var1)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState var0) {
        return this.matches(var0.getBlock().getStateDefinition(), var0);
    }

    public boolean matches(FluidState var0) {
        return this.matches(var0.getType().getStateDefinition(), var0);
    }

    public Optional<String> checkState(StateDefinition<?, ?> var0) {
        for (PropertyMatcher var2 : this.properties) {
            Optional<String> var3 = var2.checkState(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    record PropertyMatcher(String name, ValueMatcher valueMatcher) {
        public static final StreamCodec<ByteBuf, PropertyMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, PropertyMatcher::name, ValueMatcher.STREAM_CODEC, PropertyMatcher::valueMatcher, PropertyMatcher::new);

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> var0, S var1) {
            Property<?> var2 = var0.getProperty(this.name);
            return var2 != null && this.valueMatcher.match(var1, var2);
        }

        public Optional<String> checkState(StateDefinition<?, ?> var0) {
            Property<?> var1 = var0.getProperty(this.name);
            return var1 != null ? Optional.empty() : Optional.of(this.name);
        }
    }

    static interface ValueMatcher {
        public static final Codec<ValueMatcher> CODEC = Codec.either(ExactMatcher.CODEC, RangedMatcher.CODEC).xmap(Either::unwrap, var0 -> {
            if (var0 instanceof ExactMatcher) {
                ExactMatcher var1 = (ExactMatcher)var0;
                return Either.left((Object)var1);
            }
            if (var0 instanceof RangedMatcher) {
                RangedMatcher var2 = (RangedMatcher)var0;
                return Either.right((Object)var2);
            }
            throw new UnsupportedOperationException();
        });
        public static final StreamCodec<ByteBuf, ValueMatcher> STREAM_CODEC = ByteBufCodecs.either(ExactMatcher.STREAM_CODEC, RangedMatcher.STREAM_CODEC).map(Either::unwrap, var0 -> {
            if (var0 instanceof ExactMatcher) {
                ExactMatcher var1 = (ExactMatcher)var0;
                return Either.left((Object)var1);
            }
            if (var0 instanceof RangedMatcher) {
                RangedMatcher var2 = (RangedMatcher)var0;
                return Either.right((Object)var2);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);
    }

    public static class Builder {
        private final ImmutableList.Builder<PropertyMatcher> matchers = ImmutableList.builder();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> var0, String var1) {
            this.matchers.add((Object)new PropertyMatcher(var0.getName(), new ExactMatcher(var1)));
            return this;
        }

        public Builder hasProperty(Property<Integer> var0, int var1) {
            return this.hasProperty((Property)var0, (Comparable<T> & StringRepresentable)Integer.toString(var1));
        }

        public Builder hasProperty(Property<Boolean> var0, boolean var1) {
            return this.hasProperty((Property)var0, (Comparable<T> & StringRepresentable)Boolean.toString(var1));
        }

        public <T extends Comparable<T> & StringRepresentable> Builder hasProperty(Property<T> var0, T var1) {
            return this.hasProperty(var0, (T)((StringRepresentable)var1).getSerializedName());
        }

        public Optional<StatePropertiesPredicate> build() {
            return Optional.of(new StatePropertiesPredicate((List<PropertyMatcher>)this.matchers.build()));
        }
    }

    record RangedMatcher(Optional<String> minValue, Optional<String> maxValue) implements ValueMatcher
    {
        public static final Codec<RangedMatcher> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.optionalFieldOf("min").forGetter(RangedMatcher::minValue), (App)Codec.STRING.optionalFieldOf("max").forGetter(RangedMatcher::maxValue)).apply((Applicative)var0, RangedMatcher::new));
        public static final StreamCodec<ByteBuf, RangedMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::minValue, ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::maxValue, RangedMatcher::new);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var0, Property<T> var1) {
            Optional<T> var3;
            Comparable var2 = var0.getValue(var1);
            if (this.minValue.isPresent() && ((var3 = var1.getValue(this.minValue.get())).isEmpty() || var2.compareTo((Comparable)((Comparable)var3.get())) < 0)) {
                return false;
            }
            return !this.maxValue.isPresent() || !(var3 = var1.getValue(this.maxValue.get())).isEmpty() && var2.compareTo((Comparable)((Comparable)var3.get())) <= 0;
        }
    }

    record ExactMatcher(String value) implements ValueMatcher
    {
        public static final Codec<ExactMatcher> CODEC = Codec.STRING.xmap(ExactMatcher::new, ExactMatcher::value);
        public static final StreamCodec<ByteBuf, ExactMatcher> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ExactMatcher::new, ExactMatcher::value);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var0, Property<T> var1) {
            Comparable var2 = var0.getValue(var1);
            Optional<T> var3 = var1.getValue(this.value);
            return var3.isPresent() && var2.compareTo((Comparable)((Comparable)var3.get())) == 0;
        }
    }
}

