/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.command.VanillaCommandWrapper;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class CommandSourceStack
implements ExecutionCommandSource<CommandSourceStack>,
SharedSuggestionProvider {
    public static final SimpleCommandExceptionType ERROR_NOT_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable("permissions.requires.player"));
    public static final SimpleCommandExceptionType ERROR_NOT_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable("permissions.requires.entity"));
    public final CommandSource source;
    private final Vec3 worldPosition;
    private final ServerLevel level;
    private final PermissionSet permissions;
    private final String textName;
    private final Component displayName;
    private final MinecraftServer server;
    private final boolean silent;
    private final @Nullable Entity entity;
    private final CommandResultCallback resultCallback;
    private final EntityAnchorArgument.Anchor anchor;
    private final Vec2 rotation;
    private final CommandSigningContext signingContext;
    private final TaskChainer chatMessageChainer;
    private final PermissionSet bukkitPermissions;
    public volatile CommandNode currentCommand;

    public CommandSourceStack(CommandSource icommandlistener, Vec3 vec3d, Vec2 vec2f, ServerLevel worldserver, PermissionSet permissionset, String s, Component ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity) {
        this(icommandlistener, vec3d, vec2f, worldserver, permissionset, s, ichatbasecomponent, minecraftserver, entity, false, CommandResultCallback.EMPTY, EntityAnchorArgument.Anchor.FEET, CommandSigningContext.ANONYMOUS, TaskChainer.immediate(minecraftserver));
    }

    private CommandSourceStack(CommandSource icommandlistener, Vec3 vec3d, Vec2 vec2f, ServerLevel worldserver, PermissionSet permissionset, String s, Component ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity, boolean flag, CommandResultCallback commandresultcallback, EntityAnchorArgument.Anchor argumentanchor_anchor, CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        this.source = icommandlistener;
        this.worldPosition = vec3d;
        this.level = worldserver;
        this.silent = flag;
        this.entity = entity;
        this.permissions = permissionset;
        this.textName = s;
        this.displayName = ichatbasecomponent;
        this.server = minecraftserver;
        this.resultCallback = commandresultcallback;
        this.anchor = argumentanchor_anchor;
        this.rotation = vec2f;
        this.signingContext = commandsigningcontext;
        this.chatMessageChainer = taskchainer;
        this.bukkitPermissions = new DelegatePermissionSet(this.permissions);
    }

    public CommandSourceStack withSource(CommandSource icommandlistener) {
        return this.source == icommandlistener ? this : new CommandSourceStack(icommandlistener, this.worldPosition, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withEntity(Entity entity) {
        return this.entity == entity ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissions, entity.getPlainTextName(), entity.getDisplayName(), this.server, entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withPosition(Vec3 vec3d) {
        return this.worldPosition.equals(vec3d) ? this : new CommandSourceStack(this.source, vec3d, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withRotation(Vec2 vec2f) {
        return this.rotation.equals(vec2f) ? this : new CommandSourceStack(this.source, this.worldPosition, vec2f, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    @Override
    public CommandSourceStack withCallback(CommandResultCallback commandresultcallback) {
        return Objects.equals(this.resultCallback, commandresultcallback) ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, commandresultcallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withCallback(CommandResultCallback commandresultcallback, BinaryOperator<CommandResultCallback> binaryoperator) {
        CommandResultCallback commandresultcallback1 = (CommandResultCallback)binaryoperator.apply(this.resultCallback, commandresultcallback);
        return this.withCallback(commandresultcallback1);
    }

    public CommandSourceStack withSuppressedOutput() {
        return !this.silent && !this.source.alwaysAccepts() ? new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, true, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer) : this;
    }

    public CommandSourceStack withPermission(PermissionSet permissionset) {
        return permissionset == this.permissions ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, permissionset, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withMaximumPermission(PermissionSet permissionset) {
        return this.withPermission(this.permissions.union(permissionset));
    }

    public CommandSourceStack withAnchor(EntityAnchorArgument.Anchor argumentanchor_anchor) {
        return argumentanchor_anchor == this.anchor ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, argumentanchor_anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withLevel(ServerLevel worldserver) {
        if (worldserver == this.level) {
            return this;
        }
        double d0 = DimensionType.getTeleportationScale(this.level.dimensionType(), worldserver.dimensionType());
        Vec3 vec3d = new Vec3(this.worldPosition.x * d0, this.worldPosition.y, this.worldPosition.z * d0);
        return new CommandSourceStack(this.source, vec3d, this.rotation, worldserver, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack facing(Entity entity, EntityAnchorArgument.Anchor argumentanchor_anchor) {
        return this.facing(argumentanchor_anchor.apply(entity));
    }

    public CommandSourceStack facing(Vec3 vec3d) {
        Vec3 vec3d1 = this.anchor.apply(this);
        double d0 = vec3d.x - vec3d1.x;
        double d1 = vec3d.y - vec3d1.y;
        double d2 = vec3d.z - vec3d1.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = Mth.wrapDegrees((float)(-(Mth.atan2(d1, d3) * 57.2957763671875)));
        float f1 = Mth.wrapDegrees((float)(Mth.atan2(d2, d0) * 57.2957763671875) - 90.0f);
        return this.withRotation(new Vec2(f, f1));
    }

    public CommandSourceStack withSigningContext(CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        return commandsigningcontext == this.signingContext && taskchainer == this.chatMessageChainer ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissions, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, commandsigningcontext, taskchainer);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public String getTextName() {
        return this.textName;
    }

    @Override
    public PermissionSet permissions() {
        return this.bukkitPermissions;
    }

    public Vec3 getPosition() {
        return this.worldPosition;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public @Nullable Entity getEntity() {
        return this.entity;
    }

    public Entity getEntityOrException() throws CommandSyntaxException {
        if (this.entity == null) {
            throw ERROR_NOT_ENTITY.create();
        }
        return this.entity;
    }

    public ServerPlayer getPlayerOrException() throws CommandSyntaxException {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            return entityplayer;
        }
        throw ERROR_NOT_PLAYER.create();
    }

    public @Nullable ServerPlayer getPlayer() {
        ServerPlayer entityplayer1;
        Entity entity = this.entity;
        ServerPlayer entityplayer = entity instanceof ServerPlayer ? (entityplayer1 = (ServerPlayer)entity) : null;
        return entityplayer;
    }

    public boolean isPlayer() {
        return this.entity instanceof ServerPlayer;
    }

    public Vec2 getRotation() {
        return this.rotation;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public EntityAnchorArgument.Anchor getAnchor() {
        return this.anchor;
    }

    public CommandSigningContext getSigningContext() {
        return this.signingContext;
    }

    public TaskChainer getChatMessageChainer() {
        return this.chatMessageChainer;
    }

    public boolean shouldFilterMessageTo(ServerPlayer entityplayer) {
        ServerPlayer entityplayer1 = this.getPlayer();
        return entityplayer == entityplayer1 ? false : entityplayer1 != null && entityplayer1.isTextFilteringEnabled() || entityplayer.isTextFilteringEnabled();
    }

    public void sendChatMessage(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatType.Bound chatmessagetype_a) {
        if (!this.silent) {
            ServerPlayer entityplayer = this.getPlayer();
            if (entityplayer != null) {
                entityplayer.sendChatMessage(outgoingchatmessage, flag, chatmessagetype_a);
            } else {
                this.source.sendSystemMessage(chatmessagetype_a.decorate(outgoingchatmessage.content()));
            }
        }
    }

    public void sendSystemMessage(Component ichatbasecomponent) {
        if (!this.silent) {
            ServerPlayer entityplayer = this.getPlayer();
            if (entityplayer != null) {
                entityplayer.sendSystemMessage(ichatbasecomponent);
            } else {
                this.source.sendSystemMessage(ichatbasecomponent);
            }
        }
    }

    public void sendSuccess(Supplier<Component> supplier, boolean flag) {
        boolean flag2;
        boolean flag1 = this.source.acceptsSuccess() && !this.silent;
        boolean bl = flag2 = flag && this.source.shouldInformAdmins() && !this.silent;
        if (flag1 || flag2) {
            Component ichatbasecomponent = supplier.get();
            if (flag1) {
                this.source.sendSystemMessage(ichatbasecomponent);
            }
            if (flag2) {
                this.broadcastToAdmins(ichatbasecomponent);
            }
        }
    }

    private void broadcastToAdmins(Component ichatbasecomponent) {
        MutableComponent ichatbasecomponent1 = Component.translatable("chat.type.admin", this.getDisplayName(), ichatbasecomponent).withStyle(ChatFormatting.GRAY, ChatFormatting.ITALIC);
        GameRules gamerules = this.level.getGameRules();
        if (gamerules.get(GameRules.SEND_COMMAND_FEEDBACK).booleanValue()) {
            for (ServerPlayer entityplayer : this.server.getPlayerList().getPlayers()) {
                if (entityplayer.commandSource() == this.source || !entityplayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                entityplayer.sendSystemMessage(ichatbasecomponent1);
            }
        }
        if (this.source != this.server && gamerules.get(GameRules.LOG_ADMIN_COMMANDS).booleanValue() && !SpigotConfig.silentCommandBlocks) {
            this.server.sendSystemMessage(ichatbasecomponent1);
        }
    }

    public void sendFailure(Component ichatbasecomponent) {
        if (this.source.acceptsFailure() && !this.silent) {
            this.source.sendSystemMessage(Component.empty().append(ichatbasecomponent).withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public CommandResultCallback callback() {
        return this.resultCallback;
    }

    @Override
    public Collection<String> getOnlinePlayerNames() {
        return Lists.newArrayList((Object[])this.server.getPlayerNames());
    }

    @Override
    public Collection<String> getAllTeams() {
        return this.server.getScoreboard().getTeamNames();
    }

    @Override
    public Stream<Identifier> getAvailableSounds() {
        return BuiltInRegistries.SOUND_EVENT.stream().map(SoundEvent::location);
    }

    @Override
    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> commandcontext) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> resourcekey, SharedSuggestionProvider.ElementSuggestionType icompletionprovider_a, SuggestionsBuilder suggestionsbuilder, CommandContext<?> commandcontext) {
        if (resourcekey == Registries.RECIPE) {
            return SharedSuggestionProvider.suggestResource(this.server.getRecipeManager().getRecipes().stream().map(recipeholder -> recipeholder.id().identifier()), suggestionsbuilder);
        }
        if (resourcekey == Registries.ADVANCEMENT) {
            Collection<AdvancementHolder> collection = this.server.getAdvancements().getAllAdvancements();
            return SharedSuggestionProvider.suggestResource(collection.stream().map(AdvancementHolder::id), suggestionsbuilder);
        }
        return this.getLookup(resourcekey).map(holderlookup -> {
            this.suggestRegistryElements((HolderLookup<?>)holderlookup, icompletionprovider_a, suggestionsbuilder);
            return suggestionsbuilder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    private Optional<? extends HolderLookup<?>> getLookup(ResourceKey<? extends Registry<?>> resourcekey) {
        Optional optional = this.registryAccess().lookup(resourcekey);
        return optional.isPresent() ? optional : this.server.reloadableRegistries().lookup().lookup(resourcekey);
    }

    @Override
    public Set<ResourceKey<Level>> levels() {
        return this.server.levelKeys();
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.server.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    @Override
    public CommandDispatcher<CommandSourceStack> dispatcher() {
        return this.getServer().getFunctions().getDispatcher();
    }

    @Override
    public void handleError(CommandExceptionType commandexceptiontype, Message message, boolean flag, @Nullable TraceCallbacks tracecallbacks) {
        if (tracecallbacks != null) {
            tracecallbacks.onError(message.getString());
        }
        if (!flag) {
            this.sendFailure(ComponentUtils.fromMessage(message));
        }
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    public CommandSender getBukkitSender() {
        return this.source.getBukkitSender(this);
    }

    private class DelegatePermissionSet
    implements PermissionSet {
        private final PermissionSet handle;

        public DelegatePermissionSet(PermissionSet handle) {
            this.handle = handle;
        }

        @Override
        public boolean hasPermission(Permission permission) {
            boolean hasPermission = this.handle.hasPermission(permission);
            CommandNode currentCommand = CommandSourceStack.this.currentCommand;
            if (currentCommand != null) {
                return this.hasPermission(hasPermission, VanillaCommandWrapper.getPermission(currentCommand));
            }
            if (permission.equals(Permissions.COMMANDS_ENTITY_SELECTORS)) {
                return this.hasPermission(hasPermission, "minecraft.command.selector");
            }
            return hasPermission;
        }

        public boolean hasPermission(boolean hasPermission, String bukkitPermission) {
            return (CommandSourceStack.this.getLevel() == null || !CommandSourceStack.this.getLevel().getCraftServer().ignoreVanillaPermissions) && hasPermission || CommandSourceStack.this.getBukkitSender().hasPermission(bukkitPermission);
        }
    }
}

