/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignableCommand;
import org.jspecify.annotations.Nullable;

public record ArgumentSignatures(List<Entry> entries) {
    public static final ArgumentSignatures EMPTY = new ArgumentSignatures(List.of());
    private static final int MAX_ARGUMENT_COUNT = 8;
    private static final int MAX_ARGUMENT_NAME_LENGTH = 16;

    public ArgumentSignatures(FriendlyByteBuf var0) {
        this(var0.readCollection(FriendlyByteBuf.limitValue(ArrayList::new, 8), Entry::new));
    }

    public void write(FriendlyByteBuf var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((FriendlyByteBuf)((Object)var0)));
    }

    public static ArgumentSignatures signCommand(SignableCommand<?> var0, Signer var12) {
        List<Entry> var2 = var0.arguments().stream().map(var1 -> {
            MessageSignature var2 = var12.sign(var1.value());
            if (var2 != null) {
                return new Entry(var1.name(), var2);
            }
            return null;
        }).filter(Objects::nonNull).toList();
        return new ArgumentSignatures(var2);
    }

    @FunctionalInterface
    public static interface Signer {
        public @Nullable MessageSignature sign(String var1);
    }

    public record Entry(String name, MessageSignature signature) {
        public Entry(FriendlyByteBuf var0) {
            this(var0.readUtf(16), MessageSignature.read(var0));
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeUtf(this.name, 16);
            MessageSignature.write(var0, this.signature);
        }
    }
}

