/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ObjectiveCriteriaArgument
implements ArgumentType<ObjectiveCriteria> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar.baz", "minecraft:foo");
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.criteria.invalid", var0));

    private ObjectiveCriteriaArgument() {
    }

    public static ObjectiveCriteriaArgument criteria() {
        return new ObjectiveCriteriaArgument();
    }

    public static ObjectiveCriteria getCriteria(CommandContext<CommandSourceStack> var0, String var1) {
        return (ObjectiveCriteria)var0.getArgument(var1, ObjectiveCriteria.class);
    }

    public ObjectiveCriteria parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        while (var0.canRead() && var0.peek() != ' ') {
            var0.skip();
        }
        String var2 = var0.getString().substring(var1, var0.getCursor());
        return ObjectiveCriteria.byName(var2).orElseThrow(() -> {
            var0.setCursor(var1);
            return ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)var0, (Object)var2);
        });
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        ArrayList var2 = Lists.newArrayList(ObjectiveCriteria.getCustomCriteriaNames());
        for (StatType statType : BuiltInRegistries.STAT_TYPE) {
            for (Object var6 : statType.getRegistry()) {
                String var7 = this.getName(statType, var6);
                var2.add(var7);
            }
        }
        return SharedSuggestionProvider.suggest(var2, var1);
    }

    public <T> String getName(StatType<T> var0, Object var1) {
        return Stat.buildName(var0, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

