/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.place.feature.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_STRUCTURE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.place.structure.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE_POOL = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.place.jigsaw.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_RECIPE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("recipe.notFound", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_ADVANCEMENT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("advancement.advancementNotFound", var0));
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceKeyArgument(ResourceKey<? extends Registry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceKeyArgument<T> key(ResourceKey<? extends Registry<T>> var0) {
        return new ResourceKeyArgument<T>(var0);
    }

    public static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandSourceStack> var0, String var1, ResourceKey<Registry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = (ResourceKey)var0.getArgument(var1, ResourceKey.class);
        Optional<ResourceKey<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4.identifier()));
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> var0, ResourceKey<? extends Registry<T>> var1) {
        return ((CommandSourceStack)var0.getSource()).getServer().registryAccess().lookupOrThrow(var1);
    }

    private static <T> Holder.Reference<T> resolveKey(CommandContext<CommandSourceStack> var0, String var1, ResourceKey<Registry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = ResourceKeyArgument.getRegistryKey(var0, var1, var2, var3);
        return (Holder.Reference)ResourceKeyArgument.getRegistry(var0, var2).get(var4).orElseThrow(() -> var3.create((Object)var4.identifier()));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.CONFIGURED_FEATURE, ERROR_INVALID_FEATURE);
    }

    public static Holder.Reference<Structure> getStructure(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.STRUCTURE, ERROR_INVALID_STRUCTURE);
    }

    public static Holder.Reference<StructureTemplatePool> getStructureTemplatePool(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.TEMPLATE_POOL, ERROR_INVALID_TEMPLATE_POOL);
    }

    public static RecipeHolder<?> getRecipe(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        RecipeManager var2 = ((CommandSourceStack)var0.getSource()).getServer().getRecipeManager();
        ResourceKey<Recipe<?>> var3 = ResourceKeyArgument.getRegistryKey(var0, var1, Registries.RECIPE, ERROR_INVALID_RECIPE);
        return var2.byKey(var3).orElseThrow(() -> ERROR_INVALID_RECIPE.create((Object)var3.identifier()));
    }

    public static AdvancementHolder getAdvancement(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        ResourceKey var2 = ResourceKeyArgument.getRegistryKey(var0, var1, Registries.ADVANCEMENT, ERROR_INVALID_ADVANCEMENT);
        AdvancementHolder var3 = ((CommandSourceStack)var0.getSource()).getServer().getAdvancements().get(var2.identifier());
        if (var3 == null) {
            throw ERROR_INVALID_ADVANCEMENT.create((Object)var2.identifier());
        }
        return var3;
    }

    public ResourceKey<T> parse(StringReader var0) throws CommandSyntaxException {
        Identifier var1 = Identifier.read(var0);
        return ResourceKey.create(this.registryKey, var1);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            return new Template(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.identifier().toString());
        }

        @Override
        public Template unpack(ResourceKeyArgument<T> var0) {
            return new Template(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceKeyArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceKeyArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceKeyArgument(this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

