/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType ERROR_UNKNOWN_TAG = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("argument.resource_tag.not_found", var0, var1));
    private static final Dynamic3CommandExceptionType ERROR_INVALID_TAG_TYPE = new Dynamic3CommandExceptionType((var0, var1, var2) -> Component.translatableEscape("argument.resource_tag.invalid_type", var0, var1, var2));
    private final HolderLookup<T> registryLookup;
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceOrTagArgument(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.lookupOrThrow(var1);
    }

    public static <T> ResourceOrTagArgument<T> resourceOrTag(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        return new ResourceOrTagArgument<T>(var0, var1);
    }

    public static <T> Result<T> getResourceOrTag(CommandContext<CommandSourceStack> var0, String var1, ResourceKey<Registry<T>> var2) throws CommandSyntaxException {
        Result var3 = (Result)var0.getArgument(var1, Result.class);
        Optional<Result<T>> var4 = var3.cast(var2);
        return var4.orElseThrow(() -> (CommandSyntaxException)((Object)((Object)var3.unwrap().map(var1 -> {
            ResourceKey var2 = var1.key();
            return ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)var2.identifier(), (Object)var2.registry(), (Object)var2.identifier());
        }, var1 -> {
            TagKey var2 = var1.key();
            return ERROR_INVALID_TAG_TYPE.create((Object)var2.location(), var2.registry(), (Object)var2.identifier());
        }))));
    }

    public Result<T> parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            int var1 = var0.getCursor();
            try {
                var0.skip();
                Identifier var2 = Identifier.read(var0);
                TagKey var3 = TagKey.create(this.registryKey, var2);
                HolderSet.Named var4 = this.registryLookup.get(var3).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)var0, (Object)var2, (Object)this.registryKey.identifier()));
                return new TagResult(var4);
            }
            catch (CommandSyntaxException var2) {
                var0.setCursor(var1);
                throw var2;
            }
        }
        Identifier var1 = Identifier.read(var0);
        ResourceKey var2 = ResourceKey.create(this.registryKey, var1);
        Holder.Reference var3 = this.registryLookup.get(var2).orElseThrow(() -> ResourceArgument.ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)var0, (Object)var1, (Object)this.registryKey.identifier()));
        return new ResourceResult(var3);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ALL);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap();

        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var1);

        public String asPrintable();
    }

    record TagResult<T>(HolderSet.Named<T> tag) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.right(this.tag);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var0) {
            return this.tag.key().isFor(var0) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> var0) {
            return this.tag.contains(var0);
        }

        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.tag.key().location());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record ResourceResult<T>(Holder.Reference<T> value) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.left(this.value);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var0) {
            return this.value.key().isFor(var0) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.equals(this.value);
        }

        @Override
        public String asPrintable() {
            return this.value.key().identifier().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            return new Template(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.identifier().toString());
        }

        @Override
        public Template unpack(ResourceOrTagArgument<T> var0) {
            return new Template(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceOrTagArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceOrTagArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

