/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagKeyArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceOrTagKeyArgument(ResourceKey<? extends Registry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceOrTagKeyArgument<T> resourceOrTagKey(ResourceKey<? extends Registry<T>> var0) {
        return new ResourceOrTagKeyArgument<T>(var0);
    }

    public static <T> Result<T> getResourceOrTagKey(CommandContext<CommandSourceStack> var0, String var1, ResourceKey<Registry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        Result var4 = (Result)var0.getArgument(var1, Result.class);
        Optional<Result<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4));
    }

    public Result<T> parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            int var1 = var0.getCursor();
            try {
                var0.skip();
                Identifier var2 = Identifier.read(var0);
                return new TagResult(TagKey.create(this.registryKey, var2));
            }
            catch (CommandSyntaxException var2) {
                var0.setCursor(var1);
                throw var2;
            }
        }
        Identifier var1 = Identifier.read(var0);
        return new ResourceResult(ResourceKey.create(this.registryKey, var1));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ALL);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<ResourceKey<T>, TagKey<T>> unwrap();

        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var1);

        public String asPrintable();
    }

    record TagResult<T>(TagKey<T> key) implements Result<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.right(this.key);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var0) {
            return this.key.cast(var0).map(TagResult::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.key.location());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record ResourceResult<T>(ResourceKey<T> key) implements Result<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var0) {
            return this.key.cast(var0).map(ResourceResult::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return this.key.identifier().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            return new Template(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.identifier().toString());
        }

        @Override
        public Template unpack(ResourceOrTagKeyArgument<T> var0) {
            return new Template(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagKeyArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceOrTagKeyArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceOrTagKeyArgument(this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

