/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInput {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("arguments.item.overstacked", var0, var1));
    private final Holder<Item> item;
    private final DataComponentPatch components;

    public ItemInput(Holder<Item> var0, DataComponentPatch var1) {
        this.item = var0;
        this.components = var1;
    }

    public Item getItem() {
        return this.item.value();
    }

    public ItemStack createItemStack(int var0, boolean var1) throws CommandSyntaxException {
        ItemStack var2 = new ItemStack(this.item, var0);
        var2.applyComponents(this.components);
        if (var1 && var0 > var2.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)this.getItemName(), (Object)var2.getMaxStackSize());
        }
        return var2;
    }

    public String serialize(HolderLookup.Provider var0) {
        StringBuilder var1 = new StringBuilder(this.getItemName());
        String var2 = this.serializeComponents(var0);
        if (!var2.isEmpty()) {
            var1.append('[');
            var1.append(var2);
            var1.append(']');
        }
        return var1.toString();
    }

    private String serializeComponents(HolderLookup.Provider var0) {
        RegistryOps<Tag> var1 = var0.createSerializationContext(NbtOps.INSTANCE);
        return this.components.entrySet().stream().flatMap(var12 -> {
            DataComponentType var2 = (DataComponentType)var12.getKey();
            Identifier var3 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(var2);
            if (var3 == null) {
                return Stream.empty();
            }
            Optional var4 = (Optional)var12.getValue();
            if (var4.isPresent()) {
                TypedDataComponent var5 = TypedDataComponent.createUnchecked(var2, var4.get());
                return var5.encodeValue(var1).result().stream().map(var1 -> var3.toString() + "=" + String.valueOf(var1));
            }
            return Stream.of("!" + var3.toString());
        }).collect(Collectors.joining(String.valueOf(',')));
    }

    private String getItemName() {
        return this.item.unwrapKey().map(ResourceKey::identifier).orElseGet(() -> "unknown[" + String.valueOf(this.item) + "]").toString();
    }
}

