/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.MacroFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

class FunctionBuilder<T extends ExecutionCommandSource<T>> {
    private @Nullable List<UnboundEntryAction<T>> plainEntries = new ArrayList<UnboundEntryAction<T>>();
    private @Nullable List<MacroFunction.Entry<T>> macroEntries;
    private final List<String> macroArguments = new ArrayList<String>();

    FunctionBuilder() {
    }

    public void addCommand(UnboundEntryAction<T> var0) {
        if (this.macroEntries != null) {
            this.macroEntries.add(new MacroFunction.PlainTextEntry<T>(var0));
        } else {
            this.plainEntries.add(var0);
        }
    }

    private int getArgumentIndex(String var0) {
        int var1 = this.macroArguments.indexOf(var0);
        if (var1 == -1) {
            var1 = this.macroArguments.size();
            this.macroArguments.add(var0);
        }
        return var1;
    }

    private IntList convertToIndices(List<String> var0) {
        IntArrayList var1 = new IntArrayList(var0.size());
        for (String var3 : var0) {
            var1.add(this.getArgumentIndex(var3));
        }
        return var1;
    }

    public void addMacro(String var0, int var1, T var2) {
        StringTemplate var3;
        try {
            var3 = StringTemplate.fromString(var0);
        }
        catch (Exception var4) {
            throw new IllegalArgumentException("Can't parse function line " + var1 + ": '" + var0 + "'", var4);
        }
        if (this.plainEntries != null) {
            this.macroEntries = new ArrayList<MacroFunction.Entry<T>>(this.plainEntries.size() + 1);
            for (UnboundEntryAction<T> var5 : this.plainEntries) {
                this.macroEntries.add(new MacroFunction.PlainTextEntry<T>(var5));
            }
            this.plainEntries = null;
        }
        this.macroEntries.add(new MacroFunction.MacroEntry<T>(var3, this.convertToIndices(var3.variables()), var2));
    }

    public CommandFunction<T> build(Identifier var0) {
        if (this.macroEntries != null) {
            return new MacroFunction<T>(var0, this.macroEntries, this.macroArguments);
        }
        return new PlainTextFunction<T>(var0, this.plainEntries);
    }
}

