/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.server.permissions.PermissionProviderCheck;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final byte NUMBER_FLAG_MIN = 1;
    private static final byte NUMBER_FLAG_MAX = 2;

    public static int createNumberFlags(boolean var0, boolean var1) {
        int var2 = 0;
        if (var0) {
            var2 |= 1;
        }
        if (var1) {
            var2 |= 2;
        }
        return var2;
    }

    public static boolean numberHasMin(byte var0) {
        return (var0 & 1) != 0;
    }

    public static boolean numberHasMax(byte var0) {
        return (var0 & 2) != 0;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeArgumentCap(JsonObject var0, ArgumentTypeInfo<A, T> var1, ArgumentTypeInfo.Template<A> var2) {
        var1.serializeToJson(var2, var0);
    }

    private static <T extends ArgumentType<?>> void serializeArgumentToJson(JsonObject var0, T var1) {
        ArgumentTypeInfo.Template<T> var2 = ArgumentTypeInfos.unpack(var1);
        var0.addProperty("type", "argument");
        var0.addProperty("parser", String.valueOf(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getKey(var2.type())));
        JsonObject var3 = new JsonObject();
        ArgumentUtils.serializeArgumentCap(var3, var2.type(), var2);
        if (!var3.isEmpty()) {
            var0.add("properties", (JsonElement)var3);
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> var02, CommandNode<S> var1) {
        Collection<String> var4;
        Object var6;
        Object var5;
        JsonObject var2 = new JsonObject();
        CommandNode<S> commandNode = var1;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, LiteralCommandNode.class, ArgumentCommandNode.class}, commandNode2, n)) {
            case 0: {
                var5 = (RootCommandNode)commandNode2;
                var2.addProperty("type", "root");
                break;
            }
            case 1: {
                var6 = (LiteralCommandNode)commandNode2;
                var2.addProperty("type", "literal");
                break;
            }
            case 2: {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode2;
                ArgumentUtils.serializeArgumentToJson(var2, argumentCommandNode.getType());
                break;
            }
            default: {
                LOGGER.error("Could not serialize node {} ({})!", var1, var1.getClass());
                var2.addProperty("type", "unknown");
            }
        }
        Collection<CommandNode<S>> var3 = var1.getChildren();
        if (!var3.isEmpty()) {
            JsonObject var42 = new JsonObject();
            var5 = var3.iterator();
            while (var5.hasNext()) {
                var6 = (CommandNode)var5.next();
                var42.add(((CommandNode)var6).getName(), (JsonElement)ArgumentUtils.serializeNodeToJson(var02, var6));
            }
            var2.add("children", (JsonElement)var42);
        }
        if (var1.getCommand() != null) {
            var2.addProperty("executable", Boolean.valueOf(true));
        }
        if ((var5 = var1.getRequirement()) instanceof PermissionProviderCheck) {
            PermissionProviderCheck var43 = (PermissionProviderCheck)var5;
            var5 = (JsonElement)PermissionCheck.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)var43.test()).getOrThrow(var0 -> new IllegalStateException("Failed to serialize requirement: " + var0));
            var2.add("permissions", (JsonElement)var5);
        }
        if (var1.getRedirect() != null && !(var4 = var02.getPath(var1.getRedirect())).isEmpty()) {
            var5 = new JsonArray();
            for (String string : var4) {
                var5.add(string);
            }
            var2.add("redirect", (JsonElement)var5);
        }
        return var2;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> var0) {
        ReferenceOpenHashSet var1 = new ReferenceOpenHashSet();
        HashSet var2 = new HashSet();
        ArgumentUtils.findUsedArgumentTypes(var0, var2, var1);
        return var2;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> var0, Set<ArgumentType<?>> var1, Set<CommandNode<T>> var22) {
        Object var3;
        if (!var22.add(var0)) {
            return;
        }
        if (var0 instanceof ArgumentCommandNode) {
            var3 = (ArgumentCommandNode)var0;
            var1.add(var3.getType());
        }
        var0.getChildren().forEach(var2 -> ArgumentUtils.findUsedArgumentTypes(var2, var1, var22));
        var3 = var0.getRedirect();
        if (var3 != null) {
            ArgumentUtils.findUsedArgumentTypes(var3, var1, var22);
        }
    }
}

