/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public interface HolderGetter<T> {
    public Optional<Holder.Reference<T>> get(ResourceKey<T> var1);

    default public Holder.Reference<T> getOrThrow(ResourceKey<T> var0) {
        return this.get(var0).orElseThrow(() -> new IllegalStateException("Missing element " + String.valueOf(var0)));
    }

    public Optional<HolderSet.Named<T>> get(TagKey<T> var1);

    default public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
        return this.get(var0).orElseThrow(() -> new IllegalStateException("Missing tag " + String.valueOf(var0)));
    }

    default public Optional<Holder<T>> getRandomElementOf(TagKey<T> var0, RandomSource var12) {
        return this.get(var0).flatMap(var1 -> var1.getRandomElement(var12));
    }

    public static interface Provider {
        public <T> Optional<? extends HolderGetter<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> HolderGetter<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> var0) {
            return this.lookup(var0).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(var0.identifier()) + " not found"));
        }

        default public <T> Optional<Holder.Reference<T>> get(ResourceKey<T> var0) {
            return this.lookup(var0.registryKey()).flatMap(var1 -> var1.get(var0));
        }

        default public <T> Holder.Reference<T> getOrThrow(ResourceKey<T> var0) {
            return (Holder.Reference)this.lookup(var0.registryKey()).flatMap(var1 -> var1.get(var0)).orElseThrow(() -> new IllegalStateException("Missing element " + String.valueOf(var0)));
        }
    }
}

