/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.cauldron;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public interface CauldronInteraction {
    public static final Map<String, InteractionMap> INTERACTIONS = new Object2ObjectArrayMap();
    public static final Codec<InteractionMap> CODEC = Codec.stringResolver(InteractionMap::name, INTERACTIONS::get);
    public static final InteractionMap EMPTY = CauldronInteraction.newInteractionMap("empty");
    public static final InteractionMap WATER = CauldronInteraction.newInteractionMap("water");
    public static final InteractionMap LAVA = CauldronInteraction.newInteractionMap("lava");
    public static final InteractionMap POWDER_SNOW = CauldronInteraction.newInteractionMap("powder_snow");

    public static InteractionMap newInteractionMap(String s) {
        Object2ObjectOpenHashMap object2objectopenhashmap = new Object2ObjectOpenHashMap();
        object2objectopenhashmap.defaultReturnValue((iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> InteractionResult.TRY_WITH_EMPTY_HAND);
        InteractionMap cauldroninteraction_a = new InteractionMap(s, (Map<Item, CauldronInteraction>)object2objectopenhashmap);
        INTERACTIONS.put(s, cauldroninteraction_a);
        return cauldroninteraction_a;
    }

    public InteractionResult interact(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, ItemStack var6);

    public static void bootStrap() {
        Map<Item, CauldronInteraction> map = EMPTY.map();
        CauldronInteraction.addDefaultInteractions(map);
        map.put(Items.POTION, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> {
            PotionContents potioncontents = itemstack.get(DataComponents.POTION_CONTENTS);
            if (potioncontents != null && potioncontents.is(Potions.WATER)) {
                if (!world.isClientSide()) {
                    if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, Blocks.WATER_CAULDRON.defaultBlockState(), entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY)) {
                        return InteractionResult.SUCCESS;
                    }
                    Item item = itemstack.getItem();
                    entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, new ItemStack(Items.GLASS_BOTTLE)));
                    entityhuman.awardStat(Stats.USE_CAULDRON);
                    entityhuman.awardStat(Stats.ITEM_USED.get(item));
                    world.playSound((Entity)null, blockposition, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        });
        Map<Item, CauldronInteraction> map1 = WATER.map();
        CauldronInteraction.addDefaultInteractions(map1);
        map1.put(Items.BUCKET, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.WATER_BUCKET), iblockdata1 -> iblockdata1.getValue(LayeredCauldronBlock.LEVEL) == 3, SoundEvents.BUCKET_FILL));
        map1.put(Items.GLASS_BOTTLE, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> {
            if (!world.isClientSide()) {
                if (!LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL)) {
                    return InteractionResult.SUCCESS;
                }
                Item item = itemstack.getItem();
                entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, PotionContents.createItemStack(Items.POTION, Potions.WATER)));
                entityhuman.awardStat(Stats.USE_CAULDRON);
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
                world.playSound((Entity)null, blockposition, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent((Entity)null, GameEvent.FLUID_PICKUP, blockposition);
            }
            return InteractionResult.SUCCESS;
        });
        map1.put(Items.POTION, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> {
            if (iblockdata.getValue(LayeredCauldronBlock.LEVEL) == 3) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            PotionContents potioncontents = itemstack.get(DataComponents.POTION_CONTENTS);
            if (potioncontents != null && potioncontents.is(Potions.WATER)) {
                if (!world.isClientSide()) {
                    if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, (BlockState)iblockdata.cycle(LayeredCauldronBlock.LEVEL), entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY)) {
                        return InteractionResult.SUCCESS;
                    }
                    entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, new ItemStack(Items.GLASS_BOTTLE)));
                    entityhuman.awardStat(Stats.USE_CAULDRON);
                    entityhuman.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
                    world.playSound((Entity)null, blockposition, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        });
        map1.put(Items.LEATHER_BOOTS, CauldronInteraction::dyedItemIteration);
        map1.put(Items.LEATHER_LEGGINGS, CauldronInteraction::dyedItemIteration);
        map1.put(Items.LEATHER_CHESTPLATE, CauldronInteraction::dyedItemIteration);
        map1.put(Items.LEATHER_HELMET, CauldronInteraction::dyedItemIteration);
        map1.put(Items.LEATHER_HORSE_ARMOR, CauldronInteraction::dyedItemIteration);
        map1.put(Items.WOLF_ARMOR, CauldronInteraction::dyedItemIteration);
        map1.put(Items.WHITE_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.GRAY_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.BLACK_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.BLUE_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.BROWN_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.CYAN_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.GREEN_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.LIGHT_BLUE_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.LIGHT_GRAY_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.LIME_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.MAGENTA_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.ORANGE_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.PINK_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.PURPLE_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.RED_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.YELLOW_BANNER, CauldronInteraction::bannerInteraction);
        map1.put(Items.WHITE_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.GRAY_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.BLACK_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.BLUE_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.BROWN_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.CYAN_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.GREEN_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.LIGHT_BLUE_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.LIGHT_GRAY_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.LIME_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.MAGENTA_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.ORANGE_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.PINK_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.PURPLE_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.RED_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.YELLOW_SHULKER_BOX, CauldronInteraction::shulkerBoxInteraction);
        Map<Item, CauldronInteraction> map2 = LAVA.map();
        map2.put(Items.BUCKET, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.LAVA_BUCKET), iblockdata1 -> true, SoundEvents.BUCKET_FILL_LAVA));
        CauldronInteraction.addDefaultInteractions(map2);
        Map<Item, CauldronInteraction> map3 = POWDER_SNOW.map();
        map3.put(Items.BUCKET, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.POWDER_SNOW_BUCKET), iblockdata1 -> iblockdata1.getValue(LayeredCauldronBlock.LEVEL) == 3, SoundEvents.BUCKET_FILL_POWDER_SNOW));
        CauldronInteraction.addDefaultInteractions(map3);
    }

    public static void addDefaultInteractions(Map<Item, CauldronInteraction> map) {
        map.put(Items.LAVA_BUCKET, CauldronInteraction::fillLavaInteraction);
        map.put(Items.WATER_BUCKET, CauldronInteraction::fillWaterInteraction);
        map.put(Items.POWDER_SNOW_BUCKET, CauldronInteraction::fillPowderSnowInteraction);
    }

    public static InteractionResult fillBucket(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack, ItemStack itemstack1, Predicate<BlockState> predicate, SoundEvent soundeffect) {
        if (!predicate.test(iblockdata)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!world.isClientSide()) {
            if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, Blocks.CAULDRON.defaultBlockState(), entityhuman, CauldronLevelChangeEvent.ChangeReason.BUCKET_FILL)) {
                return InteractionResult.SUCCESS;
            }
            Item item = itemstack.getItem();
            entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, itemstack1));
            entityhuman.awardStat(Stats.USE_CAULDRON);
            entityhuman.awardStat(Stats.ITEM_USED.get(item));
            world.playSound((Entity)null, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)null, GameEvent.FLUID_PICKUP, blockposition);
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult emptyBucket(Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack, BlockState iblockdata, SoundEvent soundeffect) {
        if (!world.isClientSide()) {
            if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata, entityhuman, CauldronLevelChangeEvent.ChangeReason.BUCKET_EMPTY)) {
                return InteractionResult.SUCCESS;
            }
            Item item = itemstack.getItem();
            entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, new ItemStack(Items.BUCKET)));
            entityhuman.awardStat(Stats.FILL_CAULDRON);
            entityhuman.awardStat(Stats.ITEM_USED.get(item));
            world.playSound((Entity)null, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
        }
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult fillWaterInteraction(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        return CauldronInteraction.emptyBucket(world, blockposition, entityhuman, enumhand, itemstack, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue(LayeredCauldronBlock.LEVEL, 3), SoundEvents.BUCKET_EMPTY);
    }

    private static InteractionResult fillLavaInteraction(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        return CauldronInteraction.isUnderWater(world, blockposition) ? InteractionResult.CONSUME : CauldronInteraction.emptyBucket(world, blockposition, entityhuman, enumhand, itemstack, Blocks.LAVA_CAULDRON.defaultBlockState(), SoundEvents.BUCKET_EMPTY_LAVA);
    }

    private static InteractionResult fillPowderSnowInteraction(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        return CauldronInteraction.isUnderWater(world, blockposition) ? InteractionResult.CONSUME : CauldronInteraction.emptyBucket(world, blockposition, entityhuman, enumhand, itemstack, (BlockState)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue(LayeredCauldronBlock.LEVEL, 3), SoundEvents.BUCKET_EMPTY_POWDER_SNOW);
    }

    private static InteractionResult shulkerBoxInteraction(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        Block block = Block.byItem(itemstack.getItem());
        if (!(block instanceof ShulkerBoxBlock)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!world.isClientSide()) {
            if (!LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entityhuman, CauldronLevelChangeEvent.ChangeReason.SHULKER_WASH)) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = itemstack.transmuteCopy(Blocks.SHULKER_BOX, 1);
            entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, itemstack1, false));
            entityhuman.awardStat(Stats.CLEAN_SHULKER_BOX);
        }
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult bannerInteraction(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        BannerPatternLayers bannerpatternlayers = itemstack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY);
        if (bannerpatternlayers.layers().isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!world.isClientSide()) {
            if (!LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entityhuman, CauldronLevelChangeEvent.ChangeReason.BANNER_WASH)) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = itemstack.copyWithCount(1);
            itemstack1.set(DataComponents.BANNER_PATTERNS, bannerpatternlayers.removeLast());
            entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, itemstack1, false));
            entityhuman.awardStat(Stats.CLEAN_BANNER);
        }
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult dyedItemIteration(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        if (!itemstack.is(ItemTags.DYEABLE)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!itemstack.has(DataComponents.DYED_COLOR)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!world.isClientSide()) {
            if (!LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entityhuman, CauldronLevelChangeEvent.ChangeReason.ARMOR_WASH)) {
                return InteractionResult.SUCCESS;
            }
            itemstack.remove(DataComponents.DYED_COLOR);
            entityhuman.awardStat(Stats.CLEAN_ARMOR);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean isUnderWater(Level world, BlockPos blockposition) {
        FluidState fluid = world.getFluidState(blockposition.above());
        return fluid.is(FluidTags.WATER);
    }

    public record InteractionMap(String name, Map<Item, CauldronInteraction> map) {
    }
}

