/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Unit;
import org.jspecify.annotations.Nullable;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(PatchKey.CODEC, PatchKey::valueCodec).xmap(map -> {
        if (map.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry map_entry : map.entrySet()) {
            PatchKey datacomponentpatch_c = (PatchKey)map_entry.getKey();
            if (datacomponentpatch_c.removed()) {
                reference2objectmap.put(datacomponentpatch_c.type(), Optional.empty());
                continue;
            }
            reference2objectmap.put(datacomponentpatch_c.type(), Optional.of(map_entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }, datacomponentpatch -> {
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(datacomponentpatch.map.size());
        for (Map.Entry map_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
            DataComponentType datacomponenttype = (DataComponentType)map_entry.getKey();
            if (datacomponenttype.isTransient()) continue;
            Optional optional = (Optional)map_entry.getValue();
            if (optional.isPresent()) {
                reference2objectmap.put((Object)new PatchKey(datacomponenttype, false), optional.get());
                continue;
            }
            reference2objectmap.put((Object)new PatchKey(datacomponenttype, true), (Object)Unit.INSTANCE);
        }
        return reference2objectmap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> datacomponenttype) {
            return datacomponenttype.streamCodec().cast();
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> DELIMITED_STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> datacomponenttype) {
            StreamCodec streamcodec = datacomponenttype.streamCodec().cast();
            return streamcodec.apply(ByteBufCodecs.registryFriendlyLengthPrefixed(Integer.MAX_VALUE));
        }
    });
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    private static StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> createStreamCodec(final CodecGetter datacomponentpatch_b) {
        return new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

            @Override
            public DataComponentPatch decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                int i = registryfriendlybytebuf.readVarInt();
                int j = registryfriendlybytebuf.readVarInt();
                if (i == 0 && j == 0) {
                    return EMPTY;
                }
                int k = i + j;
                Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(k, 65536));
                for (int l = 0; l < i; ++l) {
                    DataComponentType datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                    Object object = datacomponentpatch_b.apply(datacomponenttype).decode(registryfriendlybytebuf);
                    reference2objectmap.put((Object)datacomponenttype, Optional.of(object));
                }
                for (int i1 = 0; i1 < j; ++i1) {
                    DataComponentType datacomponenttype1 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                    reference2objectmap.put((Object)datacomponenttype1, Optional.empty());
                }
                return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentPatch datacomponentpatch) {
                if (datacomponentpatch.isEmpty()) {
                    registryfriendlybytebuf.writeVarInt(0);
                    registryfriendlybytebuf.writeVarInt(0);
                } else {
                    int i = 0;
                    int j = 0;
                    for (Reference2ObjectMap.Entry reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                        if (((Optional)reference2objectmap_entry.getValue()).isPresent()) {
                            ++i;
                            continue;
                        }
                        ++j;
                    }
                    registryfriendlybytebuf.writeVarInt(i);
                    registryfriendlybytebuf.writeVarInt(j);
                    for (Reference2ObjectMap.Entry reference2objectmap_entry1 : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                        Optional optional = (Optional)reference2objectmap_entry1.getValue();
                        if (!optional.isPresent()) continue;
                        DataComponentType datacomponenttype = (DataComponentType)reference2objectmap_entry1.getKey();
                        DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype);
                        this.encodeComponent(registryfriendlybytebuf, datacomponenttype, optional.get());
                    }
                    for (Reference2ObjectMap.Entry reference2objectmap_entry2 : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                        if (!((Optional)reference2objectmap_entry2.getValue()).isEmpty()) continue;
                        DataComponentType datacomponenttype1 = (DataComponentType)reference2objectmap_entry2.getKey();
                        DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype1);
                    }
                }
            }

            private <T> void encodeComponent(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentType<T> datacomponenttype, Object object) {
                datacomponentpatch_b.apply(datacomponenttype).encode(registryfriendlybytebuf, object);
            }
        };
    }

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> reference2objectmap) {
        this.map = reference2objectmap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> @Nullable Optional<? extends T> get(DataComponentType<? extends T> datacomponenttype) {
        return (Optional)this.map.get(datacomponenttype);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> predicate) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(this.map);
        reference2objectmap.keySet().removeIf(predicate);
        return reference2objectmap.isEmpty() ? EMPTY : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public SplitResult split() {
        if (this.isEmpty()) {
            return SplitResult.EMPTY;
        }
        DataComponentMap.Builder datacomponentmap_a = DataComponentMap.builder();
        Set set = Sets.newIdentityHashSet();
        this.map.forEach((datacomponenttype, optional) -> {
            if (optional.isPresent()) {
                datacomponentmap_a.setUnchecked(datacomponenttype, optional.get());
            } else {
                set.add(datacomponenttype);
            }
        });
        return new SplitResult(datacomponentmap_a.build(), set);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DataComponentPatch) {
            DataComponentPatch datacomponentpatch = (DataComponentPatch)object;
            if (this.map.equals(datacomponentpatch.map)) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> reference2objectmap) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append('{');
        boolean flag = true;
        for (Map.Entry map_entry : Reference2ObjectMaps.fastIterable(reference2objectmap)) {
            if (flag) {
                flag = false;
            } else {
                stringbuilder.append(", ");
            }
            Optional optional = (Optional)map_entry.getValue();
            if (optional.isPresent()) {
                stringbuilder.append(map_entry.getKey());
                stringbuilder.append("=>");
                stringbuilder.append(optional.get());
                continue;
            }
            stringbuilder.append(REMOVED_PREFIX);
            stringbuilder.append(map_entry.getKey());
        }
        stringbuilder.append('}');
        return stringbuilder.toString();
    }

    @FunctionalInterface
    private static interface CodecGetter {
        public <T> StreamCodec<? super RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var1);
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public void copy(DataComponentPatch orig) {
            this.map.putAll(orig.map);
        }

        public void clear(DataComponentType<?> type) {
            this.map.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.map.containsKey(type);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Builder) {
                Builder patch = (Builder)object;
                return this.map.equals(patch.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public <T> Builder set(DataComponentType<T> datacomponenttype, T t0) {
            this.map.put(datacomponenttype, Optional.of(t0));
            return this;
        }

        public <T> Builder remove(DataComponentType<T> datacomponenttype) {
            this.map.put(datacomponenttype, Optional.empty());
            return this;
        }

        public <T> Builder set(TypedDataComponent<T> typeddatacomponent) {
            return this.set(typeddatacomponent.type(), typeddatacomponent.value());
        }

        public DataComponentPatch build() {
            return this.map.isEmpty() ? EMPTY : new DataComponentPatch(this.map);
        }
    }

    public record SplitResult(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final SplitResult EMPTY = new SplitResult(DataComponentMap.EMPTY, Set.of());
    }

    private record PatchKey(DataComponentType<?> type, boolean removed) {
        public static final Codec<PatchKey> CODEC = Codec.STRING.flatXmap(s -> {
            Identifier minecraftkey;
            DataComponentType<?> datacomponenttype;
            boolean flag = s.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (flag) {
                s = s.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            return (datacomponenttype = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(minecraftkey = Identifier.tryParse(s))) == null ? DataResult.error(() -> "No component with type: '" + String.valueOf(minecraftkey) + "'") : (datacomponenttype.isTransient() ? DataResult.error(() -> "'" + String.valueOf(minecraftkey) + "' is not a persistent component") : DataResult.success((Object)new PatchKey(datacomponenttype, flag)));
        }, datacomponentpatch_c -> {
            DataComponentType<?> datacomponenttype = datacomponentpatch_c.type();
            Identifier minecraftkey = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(datacomponenttype);
            return minecraftkey == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(datacomponenttype)) : DataResult.success((Object)(datacomponentpatch_c.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(minecraftkey) : minecraftkey.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

