/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;

public class DefaultDispenseItemBehavior
implements DispenseItemBehavior {
    private static final int DEFAULT_ACCURACY = 6;
    private boolean dropper;

    public DefaultDispenseItemBehavior(boolean dropper) {
        this.dropper = dropper;
    }

    public DefaultDispenseItemBehavior() {
    }

    @Override
    public final net.minecraft.world.item.ItemStack dispense(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.execute(sourceblock, itemstack);
        this.playSound(sourceblock);
        this.playAnimation(sourceblock, sourceblock.state().getValue(DispenserBlock.FACING));
        return itemstack1;
    }

    protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
        Position iposition = DispenserBlock.getDispensePosition(sourceblock);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        if (!DefaultDispenseItemBehavior.spawnItem(sourceblock.level(), itemstack1, 6, enumdirection, sourceblock, this.dropper)) {
            itemstack.grow(1);
        }
        return itemstack;
    }

    public static void spawnItem(Level world, net.minecraft.world.item.ItemStack itemstack, int i, Direction enumdirection, Position iposition) {
        ItemEntity entityitem = DefaultDispenseItemBehavior.prepareItem(world, itemstack, i, enumdirection, iposition);
        world.addFreshEntity(entityitem);
    }

    private static ItemEntity prepareItem(Level world, net.minecraft.world.item.ItemStack itemstack, int i, Direction enumdirection, Position iposition) {
        double d0 = iposition.x();
        double d1 = iposition.y();
        double d2 = iposition.z();
        d1 = enumdirection.getAxis() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity entityitem = new ItemEntity(world, d0, d1, d2, itemstack);
        double d3 = world.random.nextDouble() * 0.1 + 0.2;
        entityitem.setDeltaMovement(world.random.triangle((double)enumdirection.getStepX() * d3, 0.0172275 * (double)i), world.random.triangle(0.2, 0.0172275 * (double)i), world.random.triangle((double)enumdirection.getStepZ() * d3, 0.0172275 * (double)i));
        return entityitem;
    }

    public static boolean spawnItem(Level world, net.minecraft.world.item.ItemStack itemstack, int i, Direction enumdirection, BlockSource sourceblock, boolean dropper) {
        if (itemstack.isEmpty()) {
            return true;
        }
        Position iposition = DispenserBlock.getDispensePosition(sourceblock);
        ItemEntity entityitem = DefaultDispenseItemBehavior.prepareItem(world, itemstack, i, enumdirection, iposition);
        CraftBlock block = CraftBlock.at(world, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit(entityitem.getDeltaMovement()));
        if (!DispenserBlock.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        entityitem.setItem(CraftItemStack.asNMSCopy(event.getItem()));
        entityitem.setDeltaMovement(CraftVector.toNMS(event.getVelocity()));
        if (!dropper && !event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior.getClass() != DefaultDispenseItemBehavior.class) {
                idispensebehavior.dispense(sourceblock, eventStack);
            } else {
                world.addFreshEntity(entityitem);
            }
            return false;
        }
        world.addFreshEntity(entityitem);
        return true;
    }

    protected void playSound(BlockSource sourceblock) {
        DefaultDispenseItemBehavior.playDefaultSound(sourceblock);
    }

    protected void playAnimation(BlockSource sourceblock, Direction enumdirection) {
        DefaultDispenseItemBehavior.playDefaultAnimation(sourceblock, enumdirection);
    }

    private static void playDefaultSound(BlockSource sourceblock) {
        sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
    }

    private static void playDefaultAnimation(BlockSource sourceblock, Direction enumdirection) {
        sourceblock.level().levelEvent(2000, sourceblock.pos(), enumdirection.get3DDataValue());
    }

    protected net.minecraft.world.item.ItemStack consumeWithRemainder(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        itemstack.shrink(1);
        if (itemstack.isEmpty()) {
            return itemstack1;
        }
        this.addToInventoryOrDispense(sourceblock, itemstack1);
        return itemstack;
    }

    private void addToInventoryOrDispense(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = sourceblock.blockEntity().insertItem(itemstack);
        if (!itemstack1.isEmpty()) {
            Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
            DefaultDispenseItemBehavior.spawnItem(sourceblock.level(), itemstack1, 6, enumdirection, DispenserBlock.getDispensePosition(sourceblock));
            DefaultDispenseItemBehavior.playDefaultSound(sourceblock);
            DefaultDispenseItemBehavior.playDefaultAnimation(sourceblock, enumdirection);
        }
    }
}

