/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    public static final EquipmentDispenseItemBehavior INSTANCE = new EquipmentDispenseItemBehavior();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(sourceblock, itemstack) ? itemstack : super.execute(sourceblock, itemstack);
    }

    public static boolean dispenseEquipment(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
        List<LivingEntity> list = sourceblock.level().getEntitiesOfClass(LivingEntity.class, new AABB(blockposition), entityliving -> entityliving.canEquipWithDispenser(itemstack));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity entityliving2 = list.getFirst();
        EquipmentSlot enumitemslot = entityliving2.getEquipmentSlotForItem(itemstack);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        ServerLevel world = sourceblock.level();
        CraftBlock block = CraftBlock.at(world, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (ItemStack)craftItem.clone(), (org.bukkit.entity.LivingEntity)((CraftLivingEntity)entityliving2.getBukkitEntity()));
        if (!DispenserBlock.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return false;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != INSTANCE) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return true;
            }
        }
        entityliving2.setItemSlot(enumitemslot, itemstack1);
        if (entityliving2 instanceof Mob) {
            Mob entityinsentient = (Mob)entityliving2;
            entityinsentient.setGuaranteedDrop(enumitemslot);
            entityinsentient.setPersistenceRequired();
        }
        return true;
    }
}

