/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemParticleOption
implements ParticleOptions {
    private static final Codec<ItemStack> ITEM_CODEC = Codec.withAlternative(ItemStack.SINGLE_ITEM_CODEC, Item.CODEC, ItemStack::new);
    private final ParticleType<ItemParticleOption> type;
    private final ItemStack itemStack;

    public static MapCodec<ItemParticleOption> codec(ParticleType<ItemParticleOption> var02) {
        return ITEM_CODEC.xmap(var1 -> new ItemParticleOption(var02, (ItemStack)var1), var0 -> var0.itemStack).fieldOf("item");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ItemParticleOption> streamCodec(ParticleType<ItemParticleOption> var02) {
        return ItemStack.STREAM_CODEC.map(var1 -> new ItemParticleOption(var02, (ItemStack)var1), var0 -> var0.itemStack);
    }

    public ItemParticleOption(ParticleType<ItemParticleOption> var0, ItemStack var1) {
        if (var1.isEmpty()) {
            throw new IllegalArgumentException("Empty stacks are not allowed");
        }
        this.type = var0;
        this.itemStack = var1;
    }

    public ParticleType<ItemParticleOption> getType() {
        return this.type;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }
}

