/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float DEEP_OCEAN_CONTINENTALNESS = -0.51f;
    private static final float OCEAN_CONTINENTALNESS = -0.4f;
    private static final float PLAINS_CONTINENTALNESS = 0.1f;
    private static final float BEACH_CONTINENTALNESS = -0.15f;
    private static final BoundedFloatFunction<Float> NO_TRANSFORM = BoundedFloatFunction.IDENTITY;
    private static final BoundedFloatFunction<Float> AMPLIFIED_OFFSET = BoundedFloatFunction.createUnlimited(var0 -> var0 < 0.0f ? var0 : var0 * 2.0f);
    private static final BoundedFloatFunction<Float> AMPLIFIED_FACTOR = BoundedFloatFunction.createUnlimited(var0 -> 1.25f - 6.25f / (var0 + 5.0f));
    private static final BoundedFloatFunction<Float> AMPLIFIED_JAGGEDNESS = BoundedFloatFunction.createUnlimited(var0 -> var0 * 2.0f);

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldOffset(I var0, I var1, I var2, boolean var3) {
        BoundedFloatFunction<Float> var4 = var3 ? AMPLIFIED_OFFSET : NO_TRANSFORM;
        CubicSpline<C, I> var5 = TerrainProvider.buildErosionOffsetSpline(var1, var2, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, var4);
        CubicSpline<C, I> var6 = TerrainProvider.buildErosionOffsetSpline(var1, var2, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, var4);
        CubicSpline<C, I> var7 = TerrainProvider.buildErosionOffsetSpline(var1, var2, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, var4);
        CubicSpline<C, I> var8 = TerrainProvider.buildErosionOffsetSpline(var1, var2, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, var4);
        return CubicSpline.builder(var0, var4).addPoint(-1.1f, 0.044f).addPoint(-1.02f, -0.2222f).addPoint(-0.51f, -0.2222f).addPoint(-0.44f, -0.12f).addPoint(-0.18f, -0.12f).addPoint(-0.16f, var5).addPoint(-0.15f, var5).addPoint(-0.1f, var6).addPoint(0.25f, var7).addPoint(1.0f, var8).build();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldFactor(I var0, I var1, I var2, I var3, boolean var4) {
        BoundedFloatFunction<Float> var5 = var4 ? AMPLIFIED_FACTOR : NO_TRANSFORM;
        return CubicSpline.builder(var0, NO_TRANSFORM).addPoint(-0.19f, 3.95f).addPoint(-0.15f, TerrainProvider.getErosionFactor(var1, var2, var3, 6.25f, true, NO_TRANSFORM)).addPoint(-0.1f, TerrainProvider.getErosionFactor(var1, var2, var3, 5.47f, true, var5)).addPoint(0.03f, TerrainProvider.getErosionFactor(var1, var2, var3, 5.08f, true, var5)).addPoint(0.06f, TerrainProvider.getErosionFactor(var1, var2, var3, 4.69f, false, var5)).build();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldJaggedness(I var0, I var1, I var2, I var3, boolean var4) {
        BoundedFloatFunction<Float> var5 = var4 ? AMPLIFIED_JAGGEDNESS : NO_TRANSFORM;
        float var6 = 0.65f;
        return CubicSpline.builder(var0, var5).addPoint(-0.11f, 0.0f).addPoint(0.03f, TerrainProvider.buildErosionJaggednessSpline(var1, var2, var3, 1.0f, 0.5f, 0.0f, 0.0f, var5)).addPoint(0.65f, TerrainProvider.buildErosionJaggednessSpline(var1, var2, var3, 1.0f, 1.0f, 1.0f, 0.0f, var5)).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I var0, I var1, I var2, float var3, float var4, float var5, float var6, BoundedFloatFunction<Float> var7) {
        float var8 = -0.5775f;
        CubicSpline<C, I> var9 = TerrainProvider.buildRidgeJaggednessSpline(var1, var2, var3, var5, var7);
        CubicSpline<C, I> var10 = TerrainProvider.buildRidgeJaggednessSpline(var1, var2, var4, var6, var7);
        return CubicSpline.builder(var0, var7).addPoint(-1.0f, var9).addPoint(-0.78f, var10).addPoint(-0.5775f, var10).addPoint(-0.375f, 0.0f).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I var0, I var1, float var2, float var3, BoundedFloatFunction<Float> var4) {
        float var5 = NoiseRouterData.peaksAndValleys(0.4f);
        float var6 = NoiseRouterData.peaksAndValleys(0.56666666f);
        float var7 = (var5 + var6) / 2.0f;
        CubicSpline.Builder<C, I> var8 = CubicSpline.builder(var1, var4);
        var8.addPoint(var5, 0.0f);
        if (var3 > 0.0f) {
            var8.addPoint(var7, TerrainProvider.buildWeirdnessJaggednessSpline(var0, var3, var4));
        } else {
            var8.addPoint(var7, 0.0f);
        }
        if (var2 > 0.0f) {
            var8.addPoint(1.0f, TerrainProvider.buildWeirdnessJaggednessSpline(var0, var2, var4));
        } else {
            var8.addPoint(1.0f, 0.0f);
        }
        return var8.build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I var0, float var1, BoundedFloatFunction<Float> var2) {
        float var3 = 0.63f * var1;
        float var4 = 0.3f * var1;
        return CubicSpline.builder(var0, var2).addPoint(-0.01f, var3).addPoint(0.01f, var4).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I var0, I var1, I var2, float var3, boolean var4, BoundedFloatFunction<Float> var5) {
        CubicSpline var6 = CubicSpline.builder(var1, var5).addPoint(-0.2f, 6.3f).addPoint(0.2f, var3).build();
        CubicSpline.Builder var7 = CubicSpline.builder(var0, var5).addPoint(-0.6f, var6).addPoint(-0.5f, CubicSpline.builder(var1, var5).addPoint(-0.05f, 6.3f).addPoint(0.05f, 2.67f).build()).addPoint(-0.35f, var6).addPoint(-0.25f, var6).addPoint(-0.1f, CubicSpline.builder(var1, var5).addPoint(-0.05f, 2.67f).addPoint(0.05f, 6.3f).build()).addPoint(0.03f, var6);
        if (var4) {
            CubicSpline var8 = CubicSpline.builder(var1, var5).addPoint(0.0f, var3).addPoint(0.1f, 0.625f).build();
            CubicSpline var9 = CubicSpline.builder(var2, var5).addPoint(-0.9f, var3).addPoint(-0.69f, var8).build();
            var7.addPoint(0.35f, var3).addPoint(0.45f, var9).addPoint(0.55f, var9).addPoint(0.62f, var3);
        } else {
            CubicSpline var8 = CubicSpline.builder(var2, var5).addPoint(-0.7f, var6).addPoint(-0.15f, 1.37f).build();
            CubicSpline var9 = CubicSpline.builder(var2, var5).addPoint(0.45f, var6).addPoint(0.7f, 1.56f).build();
            var7.addPoint(0.05f, var9).addPoint(0.4f, var9).addPoint(0.45f, var8).addPoint(0.55f, var8).addPoint(0.58f, var3);
        }
        return var7.build();
    }

    private static float calculateSlope(float var0, float var1, float var2, float var3) {
        return (var1 - var0) / (var3 - var2);
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I var0, float var1, boolean var2, BoundedFloatFunction<Float> var3) {
        CubicSpline.Builder var4 = CubicSpline.builder(var0, var3);
        float var5 = -0.7f;
        float var6 = -1.0f;
        float var7 = TerrainProvider.mountainContinentalness(-1.0f, var1, -0.7f);
        float var8 = 1.0f;
        float var9 = TerrainProvider.mountainContinentalness(1.0f, var1, -0.7f);
        float var10 = TerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(var1);
        float var11 = -0.65f;
        if (-0.65f < var10 && var10 < 1.0f) {
            float var12 = TerrainProvider.mountainContinentalness(-0.65f, var1, -0.7f);
            float var13 = -0.75f;
            float var14 = TerrainProvider.mountainContinentalness(-0.75f, var1, -0.7f);
            float var15 = TerrainProvider.calculateSlope(var7, var14, -1.0f, -0.75f);
            var4.addPoint(-1.0f, var7, var15);
            var4.addPoint(-0.75f, var14);
            var4.addPoint(-0.65f, var12);
            float var16 = TerrainProvider.mountainContinentalness(var10, var1, -0.7f);
            float var17 = TerrainProvider.calculateSlope(var16, var9, var10, 1.0f);
            float var18 = 0.01f;
            var4.addPoint(var10 - 0.01f, var16);
            var4.addPoint(var10, var16, var17);
            var4.addPoint(1.0f, var9, var17);
        } else {
            float var12 = TerrainProvider.calculateSlope(var7, var9, -1.0f, 1.0f);
            if (var2) {
                var4.addPoint(-1.0f, Math.max(0.2f, var7));
                var4.addPoint(0.0f, Mth.lerp(0.5f, var7, var9), var12);
            } else {
                var4.addPoint(-1.0f, var7, var12);
            }
            var4.addPoint(1.0f, var9, var12);
        }
        return var4.build();
    }

    private static float mountainContinentalness(float var0, float var1, float var2) {
        float var3 = 1.17f;
        float var4 = 0.46082947f;
        float var5 = 1.0f - (1.0f - var1) * 0.5f;
        float var6 = 0.5f * (1.0f - var1);
        float var7 = (var0 + 1.17f) * 0.46082947f;
        float var8 = var7 * var5 - var6;
        if (var0 < var2) {
            return Math.max(var8, -0.2222f);
        }
        return Math.max(var8, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float var0) {
        float var1 = 1.17f;
        float var2 = 0.46082947f;
        float var3 = 1.0f - (1.0f - var0) * 0.5f;
        float var4 = 0.5f * (1.0f - var0);
        return var4 / (0.46082947f * var3) - 1.17f;
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I var0, I var1, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, boolean var9, BoundedFloatFunction<Float> var10) {
        float var11 = 0.6f;
        float var12 = 0.5f;
        float var13 = 0.5f;
        CubicSpline<C, I> var14 = TerrainProvider.buildMountainRidgeSplineWithPoints(var1, Mth.lerp(var5, 0.6f, 1.5f), var9, var10);
        CubicSpline<C, I> var15 = TerrainProvider.buildMountainRidgeSplineWithPoints(var1, Mth.lerp(var5, 0.6f, 1.0f), var9, var10);
        CubicSpline<C, I> var16 = TerrainProvider.buildMountainRidgeSplineWithPoints(var1, var5, var9, var10);
        CubicSpline<C, I> var17 = TerrainProvider.ridgeSpline(var1, var2 - 0.15f, 0.5f * var5, Mth.lerp(0.5f, 0.5f, 0.5f) * var5, 0.5f * var5, 0.6f * var5, 0.5f, var10);
        CubicSpline<C, I> var18 = TerrainProvider.ridgeSpline(var1, var2, var6 * var5, var3 * var5, 0.5f * var5, 0.6f * var5, 0.5f, var10);
        CubicSpline<C, I> var19 = TerrainProvider.ridgeSpline(var1, var2, var6, var6, var3, var4, 0.5f, var10);
        CubicSpline<C, I> var20 = TerrainProvider.ridgeSpline(var1, var2, var6, var6, var3, var4, 0.5f, var10);
        CubicSpline var21 = CubicSpline.builder(var1, var10).addPoint(-1.0f, var2).addPoint(-0.4f, var19).addPoint(0.0f, var4 + 0.07f).build();
        CubicSpline<C, I> var22 = TerrainProvider.ridgeSpline(var1, -0.02f, var7, var7, var3, var4, 0.0f, var10);
        CubicSpline.Builder<C, I> var23 = CubicSpline.builder(var0, var10).addPoint(-0.85f, var14).addPoint(-0.7f, var15).addPoint(-0.4f, var16).addPoint(-0.35f, var17).addPoint(-0.1f, var18).addPoint(0.2f, var19);
        if (var8) {
            var23.addPoint(0.4f, var20).addPoint(0.45f, var21).addPoint(0.55f, var21).addPoint(0.58f, var20);
        }
        var23.addPoint(0.7f, var22);
        return var23.build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I var0, float var1, float var2, float var3, float var4, float var5, float var6, BoundedFloatFunction<Float> var7) {
        float var8 = Math.max(0.5f * (var2 - var1), var6);
        float var9 = 5.0f * (var3 - var2);
        return CubicSpline.builder(var0, var7).addPoint(-1.0f, var1, var8).addPoint(-0.4f, var2, Math.min(var8, var9)).addPoint(0.0f, var3, var9).addPoint(0.4f, var4, 2.0f * (var4 - var3)).addPoint(1.0f, var5, 0.7f * (var5 - var4)).build();
    }
}

