/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.TestBlockMode;

public class BlockBasedTestInstance
extends GameTestInstance {
    public static final MapCodec<BlockBasedTestInstance> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)TestData.CODEC.forGetter(GameTestInstance::info)).apply((Applicative)var0, BlockBasedTestInstance::new));

    public BlockBasedTestInstance(TestData<Holder<TestEnvironmentDefinition>> var0) {
        super(var0);
    }

    @Override
    public void run(GameTestHelper var0) {
        BlockPos var1 = this.findStartBlock(var0);
        TestBlockEntity var2 = var0.getBlockEntity(var1, TestBlockEntity.class);
        var2.trigger();
        var0.onEachTick(() -> {
            boolean var2;
            List<BlockPos> var12 = this.findTestBlocks(var0, TestBlockMode.ACCEPT);
            if (var12.isEmpty()) {
                var0.fail(Component.translatable("test_block.error.missing", TestBlockMode.ACCEPT.getDisplayName()));
            }
            if (var2 = var12.stream().map(var1 -> var0.getBlockEntity((BlockPos)var1, TestBlockEntity.class)).anyMatch(TestBlockEntity::hasTriggered)) {
                var0.succeed();
            } else {
                this.forAllTriggeredTestBlocks(var0, TestBlockMode.FAIL, var1 -> var0.fail(Component.literal(var1.getMessage())));
                this.forAllTriggeredTestBlocks(var0, TestBlockMode.LOG, TestBlockEntity::trigger);
            }
        });
    }

    private void forAllTriggeredTestBlocks(GameTestHelper var0, TestBlockMode var1, Consumer<TestBlockEntity> var2) {
        List<BlockPos> var3 = this.findTestBlocks(var0, var1);
        for (BlockPos var5 : var3) {
            TestBlockEntity var6 = var0.getBlockEntity(var5, TestBlockEntity.class);
            if (!var6.hasTriggered()) continue;
            var2.accept(var6);
            var6.reset();
        }
    }

    private BlockPos findStartBlock(GameTestHelper var0) {
        List<BlockPos> var1 = this.findTestBlocks(var0, TestBlockMode.START);
        if (var1.isEmpty()) {
            var0.fail(Component.translatable("test_block.error.missing", TestBlockMode.START.getDisplayName()));
        }
        if (var1.size() != 1) {
            var0.fail(Component.translatable("test_block.error.too_many", TestBlockMode.START.getDisplayName()));
        }
        return var1.getFirst();
    }

    private List<BlockPos> findTestBlocks(GameTestHelper var0, TestBlockMode var1) {
        ArrayList<BlockPos> var2 = new ArrayList<BlockPos>();
        var0.forEveryBlockInStructure(var3 -> {
            BlockState var4 = var0.getBlockState((BlockPos)var3);
            if (var4.is(Blocks.TEST_BLOCK) && var4.getValue(TestBlock.MODE) == var1) {
                var2.add(var3.immutable());
            }
        });
        return var2;
    }

    public MapCodec<BlockBasedTestInstance> codec() {
        return CODEC;
    }

    @Override
    protected MutableComponent typeDescription() {
        return Component.translatable("test_instance.type.block_based");
    }
}

