/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class StructureGridSpawner
implements GameTestRunner.StructureSpawner {
    private static final int SPACE_BETWEEN_COLUMNS = 5;
    private static final int SPACE_BETWEEN_ROWS = 6;
    private final int testsPerRow;
    private int currentRowCount;
    private AABB rowBounds;
    private final BlockPos.MutableBlockPos nextTestNorthWestCorner;
    private final BlockPos firstTestNorthWestCorner;
    private final boolean clearOnBatch;
    private float maxX = -1.0f;
    private final Collection<GameTestInfo> testInLastBatch = new ArrayList<GameTestInfo>();

    public StructureGridSpawner(BlockPos var0, int var1, boolean var2) {
        this.testsPerRow = var1;
        this.nextTestNorthWestCorner = var0.mutable();
        this.rowBounds = new AABB(this.nextTestNorthWestCorner);
        this.firstTestNorthWestCorner = var0;
        this.clearOnBatch = var2;
    }

    @Override
    public void onBatchStart(ServerLevel var0) {
        if (this.clearOnBatch) {
            this.testInLastBatch.forEach(var1 -> {
                BoundingBox var2 = var1.getTestInstanceBlockEntity().getStructureBoundingBox();
                StructureUtils.clearSpaceForStructure(var2, var0);
            });
            this.testInLastBatch.clear();
            this.rowBounds = new AABB(this.firstTestNorthWestCorner);
            this.nextTestNorthWestCorner.set(this.firstTestNorthWestCorner);
        }
    }

    @Override
    public Optional<GameTestInfo> spawnStructure(GameTestInfo var0) {
        BlockPos var1 = new BlockPos(this.nextTestNorthWestCorner);
        var0.setTestBlockPos(var1);
        GameTestInfo var2 = var0.prepareTestStructure();
        if (var2 == null) {
            return Optional.empty();
        }
        var2.startExecution(1);
        AABB var3 = var0.getTestInstanceBlockEntity().getStructureBounds();
        this.rowBounds = this.rowBounds.minmax(var3);
        this.nextTestNorthWestCorner.move((int)var3.getXsize() + 5, 0, 0);
        if ((float)this.nextTestNorthWestCorner.getX() > this.maxX) {
            this.maxX = this.nextTestNorthWestCorner.getX();
        }
        if (++this.currentRowCount >= this.testsPerRow) {
            this.currentRowCount = 0;
            this.nextTestNorthWestCorner.move(0, 0, (int)this.rowBounds.getZsize() + 6);
            this.nextTestNorthWestCorner.setX(this.firstTestNorthWestCorner.getX());
            this.rowBounds = new AABB(this.nextTestNorthWestCorner);
        }
        this.testInLastBatch.add(var0);
        return Optional.of(var0);
    }
}

