/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleMap;
import net.minecraft.world.level.gamerules.GameRules;
import org.slf4j.Logger;

public interface TestEnvironmentDefinition {
    public static final Codec<TestEnvironmentDefinition> DIRECT_CODEC = BuiltInRegistries.TEST_ENVIRONMENT_DEFINITION_TYPE.byNameCodec().dispatch(TestEnvironmentDefinition::codec, var0 -> var0);
    public static final Codec<Holder<TestEnvironmentDefinition>> CODEC = RegistryFileCodec.create(Registries.TEST_ENVIRONMENT, DIRECT_CODEC);

    public static MapCodec<? extends TestEnvironmentDefinition> bootstrap(Registry<MapCodec<? extends TestEnvironmentDefinition>> var0) {
        Registry.register(var0, "all_of", AllOf.CODEC);
        Registry.register(var0, "game_rules", SetGameRules.CODEC);
        Registry.register(var0, "time_of_day", TimeOfDay.CODEC);
        Registry.register(var0, "weather", Weather.CODEC);
        return Registry.register(var0, "function", Functions.CODEC);
    }

    public void setup(ServerLevel var1);

    default public void teardown(ServerLevel var0) {
    }

    public MapCodec<? extends TestEnvironmentDefinition> codec();

    public record AllOf(List<Holder<TestEnvironmentDefinition>> definitions) implements TestEnvironmentDefinition
    {
        public static final MapCodec<AllOf> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.listOf().fieldOf("definitions").forGetter(AllOf::definitions)).apply((Applicative)var0, AllOf::new));

        public AllOf(TestEnvironmentDefinition ... var0) {
            this(Arrays.stream(var0).map(Holder::direct).toList());
        }

        @Override
        public void setup(ServerLevel var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).setup(var0));
        }

        @Override
        public void teardown(ServerLevel var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).teardown(var0));
        }

        public MapCodec<AllOf> codec() {
            return CODEC;
        }
    }

    public record SetGameRules(GameRuleMap gameRulesMap) implements TestEnvironmentDefinition
    {
        public static final MapCodec<SetGameRules> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)GameRuleMap.CODEC.fieldOf("rules").forGetter(SetGameRules::gameRulesMap)).apply((Applicative)var0, SetGameRules::new));

        @Override
        public void setup(ServerLevel var0) {
            GameRules var1 = var0.getGameRules();
            MinecraftServer var2 = var0.getServer();
            var1.setAll(this.gameRulesMap, var2);
        }

        @Override
        public void teardown(ServerLevel var0) {
            this.gameRulesMap.keySet().forEach(var1 -> this.resetRule(var0, (GameRule)var1));
        }

        private <T> void resetRule(ServerLevel var0, GameRule<T> var1) {
            var0.getGameRules().set(var1, var1.defaultValue(), var0.getServer());
        }

        public MapCodec<SetGameRules> codec() {
            return CODEC;
        }
    }

    public record TimeOfDay(int time) implements TestEnvironmentDefinition
    {
        public static final MapCodec<TimeOfDay> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("time").forGetter(TimeOfDay::time)).apply((Applicative)var0, TimeOfDay::new));

        @Override
        public void setup(ServerLevel var0) {
            var0.setDayTime(this.time);
        }

        public MapCodec<TimeOfDay> codec() {
            return CODEC;
        }
    }

    public record Weather(Type weather) implements TestEnvironmentDefinition
    {
        public static final MapCodec<Weather> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Type.CODEC.fieldOf("weather").forGetter(Weather::weather)).apply((Applicative)var0, Weather::new));

        @Override
        public void setup(ServerLevel var0) {
            this.weather.apply(var0);
        }

        @Override
        public void teardown(ServerLevel var0) {
            var0.resetWeatherCycle();
        }

        public MapCodec<Weather> codec() {
            return CODEC;
        }

        public static enum Type implements StringRepresentable
        {
            CLEAR("clear", 100000, 0, false, false),
            RAIN("rain", 0, 100000, true, false),
            THUNDER("thunder", 0, 100000, true, true);

            public static final Codec<Type> CODEC;
            private final String id;
            private final int clearTime;
            private final int rainTime;
            private final boolean raining;
            private final boolean thundering;

            private Type(String var2, int var3, int var4, boolean var5, boolean var6) {
                this.id = var2;
                this.clearTime = var3;
                this.rainTime = var4;
                this.raining = var5;
                this.thundering = var6;
            }

            void apply(ServerLevel var0) {
                var0.setWeatherParameters(this.clearTime, this.rainTime, this.raining, this.thundering);
            }

            @Override
            public String getSerializedName() {
                return this.id;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
            }
        }
    }

    public record Functions(Optional<Identifier> setupFunction, Optional<Identifier> teardownFunction) implements TestEnvironmentDefinition
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Functions> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Identifier.CODEC.optionalFieldOf("setup").forGetter(Functions::setupFunction), (App)Identifier.CODEC.optionalFieldOf("teardown").forGetter(Functions::teardownFunction)).apply((Applicative)var0, Functions::new));

        @Override
        public void setup(ServerLevel var0) {
            this.setupFunction.ifPresent(var1 -> Functions.run(var0, var1));
        }

        @Override
        public void teardown(ServerLevel var0) {
            this.teardownFunction.ifPresent(var1 -> Functions.run(var0, var1));
        }

        private static void run(ServerLevel var0, Identifier var1) {
            MinecraftServer var2 = var0.getServer();
            ServerFunctionManager var3 = var2.getFunctions();
            Optional<CommandFunction<CommandSourceStack>> var4 = var3.get(var1);
            if (var4.isPresent()) {
                CommandSourceStack var5 = var2.createCommandSourceStack().withPermission(LevelBasedPermissionSet.GAMEMASTER).withSuppressedOutput().withLevel(var0);
                var3.execute(var4.get(), var5);
            } else {
                LOGGER.error("Test Batch failed for non-existent function {}", (Object)var1);
            }
        }

        public MapCodec<Functions> codec() {
            return CODEC;
        }
    }
}

