/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.minecraft.nbt.SnbtOperations;
import net.minecraft.network.chat.Component;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.GreedyPatternParseRule;
import net.minecraft.util.parsing.packrat.commands.GreedyPredicateParseRule;
import net.minecraft.util.parsing.packrat.commands.NumberRunParseRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.UnquotedStringParseRule;
import org.jspecify.annotations.Nullable;

public class SnbtGrammar {
    private static final DynamicCommandExceptionType ERROR_NUMBER_PARSE_FAILURE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("snbt.parser.number_parse_failure", var0));
    static final DynamicCommandExceptionType ERROR_EXPECTED_HEX_ESCAPE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("snbt.parser.expected_hex_escape", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_CODEPOINT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("snbt.parser.invalid_codepoint", var0));
    private static final DynamicCommandExceptionType ERROR_NO_SUCH_OPERATION = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("snbt.parser.no_such_operation", var0));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_INTEGER_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_integer_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_FLOAT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_float_type")));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_NON_NEGATIVE_NUMBER = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_non_negative_number")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_CHARACTER_NAME = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_character_name")));
    static final DelayedException<CommandSyntaxException> ERROR_INVALID_ARRAY_ELEMENT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_array_element_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_UNQUOTED_START = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_unquoted_start")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_UNQUOTED_STRING = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_unquoted_string")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_STRING_CONTENTS = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_string_contents")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_BINARY_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_binary_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_UNDESCORE_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.underscore_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_DECIMAL_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_decimal_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_HEX_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_hex_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EMPTY_KEY = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.empty_key")));
    private static final DelayedException<CommandSyntaxException> ERROR_LEADING_ZERO_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.leading_zero_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_INFINITY_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.infinity_not_allowed")));
    private static final HexFormat HEX_ESCAPE = HexFormat.of().withUpperCase();
    private static final NumberRunParseRule BINARY_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_BINARY_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char var0) {
            return switch (var0) {
                case '0', '1', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule DECIMAL_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_DECIMAL_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule HEX_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_HEX_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    };
    private static final GreedyPredicateParseRule PLAIN_STRING_CHUNK = new GreedyPredicateParseRule(1, (DelayedException)ERROR_INVALID_STRING_CONTENTS){

        @Override
        protected boolean isAccepted(char var0) {
            return switch (var0) {
                case '\"', '\'', '\\' -> false;
                default -> true;
            };
        }
    };
    private static final StringReaderTerms.TerminalCharacters NUMBER_LOOKEAHEAD = new StringReaderTerms.TerminalCharacters(CharList.of()){

        @Override
        protected boolean isAccepted(char var0) {
            return SnbtGrammar.canStartNumber(var0);
        }
    };
    private static final Pattern UNICODE_NAME = Pattern.compile("[-a-zA-Z0-9 ]+");

    static DelayedException<CommandSyntaxException> createNumberParseError(NumberFormatException var0) {
        return DelayedException.create(ERROR_NUMBER_PARSE_FAILURE, var0.getMessage());
    }

    public static @Nullable String escapeControlCharacters(char var0) {
        return switch (var0) {
            case '\b' -> "b";
            case '\t' -> "t";
            case '\n' -> "n";
            case '\f' -> "f";
            case '\r' -> "r";
            default -> var0 < ' ' ? "x" + HEX_ESCAPE.toHexDigits((byte)var0) : null;
        };
    }

    private static boolean isAllowedToStartUnquotedString(char var0) {
        return !SnbtGrammar.canStartNumber(var0);
    }

    static boolean canStartNumber(char var0) {
        return switch (var0) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    static boolean needsUnderscoreRemoval(String var0) {
        return var0.indexOf(95) != -1;
    }

    private static void cleanAndAppend(StringBuilder var0, String var1) {
        SnbtGrammar.cleanAndAppend(var0, var1, SnbtGrammar.needsUnderscoreRemoval(var1));
    }

    static void cleanAndAppend(StringBuilder var0, String var1, boolean var2) {
        if (var2) {
            for (char var6 : var1.toCharArray()) {
                if (var6 == '_') continue;
                var0.append(var6);
            }
        } else {
            var0.append(var1);
        }
    }

    static short parseUnsignedShort(String var0, int var1) {
        int var2 = Integer.parseInt(var0, var1);
        if (var2 >> 16 == 0) {
            return (short)var2;
        }
        throw new NumberFormatException("out of range: " + var2);
    }

    private static <T> @Nullable T createFloat(DynamicOps<T> var0, Sign var1, @Nullable String var2, @Nullable String var3, @Nullable Signed<String> var4, @Nullable TypeSuffix var5, ParseState<?> var6) {
        StringBuilder var7 = new StringBuilder();
        var1.append(var7);
        if (var2 != null) {
            SnbtGrammar.cleanAndAppend(var7, var2);
        }
        if (var3 != null) {
            var7.append('.');
            SnbtGrammar.cleanAndAppend(var7, var3);
        }
        if (var4 != null) {
            var7.append('e');
            var4.sign().append(var7);
            SnbtGrammar.cleanAndAppend(var7, (String)var4.value);
        }
        try {
            String var8 = var7.toString();
            TypeSuffix typeSuffix = var5;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FLOAT", "DOUBLE"}, (TypeSuffix)typeSuffix, n)) {
                case 0 -> SnbtGrammar.convertFloat(var0, var6, var8);
                case 1 -> SnbtGrammar.convertDouble(var0, var6, var8);
                case -1 -> SnbtGrammar.convertDouble(var0, var6, var8);
                default -> {
                    var6.errorCollector().store(var6.mark(), ERROR_EXPECTED_FLOAT_TYPE);
                    yield null;
                }
            };
        }
        catch (NumberFormatException var8) {
            var6.errorCollector().store(var6.mark(), SnbtGrammar.createNumberParseError(var8));
            return null;
        }
    }

    private static <T> @Nullable T convertFloat(DynamicOps<T> var0, ParseState<?> var1, String var2) {
        float var3 = Float.parseFloat(var2);
        if (!Float.isFinite(var3)) {
            var1.errorCollector().store(var1.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)var0.createFloat(var3);
    }

    private static <T> @Nullable T convertDouble(DynamicOps<T> var0, ParseState<?> var1, String var2) {
        double var3 = Double.parseDouble(var2);
        if (!Double.isFinite(var3)) {
            var1.errorCollector().store(var1.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)var0.createDouble(var3);
    }

    private static String joinList(List<String> var0) {
        return switch (var0.size()) {
            case 0 -> "";
            case 1 -> var0.getFirst();
            default -> String.join((CharSequence)"", var0);
        };
    }

    public static <T> Grammar<T> createParser(DynamicOps<T> var0) {
        Object var12 = var0.createBoolean(true);
        Object var22 = var0.createBoolean(false);
        Object var32 = var0.emptyMap();
        Object var42 = var0.emptyList();
        Dictionary<StringReader> var52 = new Dictionary<StringReader>();
        Atom var62 = Atom.of("sign");
        var52.put(var62, Term.alternative(Term.sequence(StringReaderTerms.character('+'), Term.marker(var62, Sign.PLUS)), Term.sequence(StringReaderTerms.character('-'), Term.marker(var62, Sign.MINUS))), var1 -> (Sign)((Object)((Object)var1.getOrThrow(var62))));
        Atom var7 = Atom.of("integer_suffix");
        var52.put(var7, Term.alternative(Term.sequence(StringReaderTerms.characters('u', 'U'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(var7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(var7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(var7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(var7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(var7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(var7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(var7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(var7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(var7, new IntegerSuffix(null, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(var7, new IntegerSuffix(null, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(var7, new IntegerSuffix(null, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(var7, new IntegerSuffix(null, TypeSuffix.LONG)))), var1 -> (IntegerSuffix)var1.getOrThrow(var7));
        Atom var8 = Atom.of("binary_numeral");
        var52.put(var8, BINARY_NUMERAL);
        Atom var9 = Atom.of("decimal_numeral");
        var52.put(var9, DECIMAL_NUMERAL);
        Atom var10 = Atom.of("hex_numeral");
        var52.put(var10, HEX_NUMERAL);
        Atom var11 = Atom.of("integer_literal");
        NamedRule var122 = var52.put(var11, Term.sequence(Term.optional(var52.named(var62)), Term.alternative(Term.sequence(StringReaderTerms.character('0'), Term.cut(), Term.alternative(Term.sequence(StringReaderTerms.characters('x', 'X'), Term.cut(), var52.named(var10)), Term.sequence(StringReaderTerms.characters('b', 'B'), var52.named(var8)), Term.sequence(var52.named(var9), Term.cut(), Term.fail(ERROR_LEADING_ZERO_NOT_ALLOWED)), Term.marker(var9, "0"))), var52.named(var9)), Term.optional(var52.named(var7))), var5 -> {
            IntegerSuffix var6 = var5.getOrDefault(var7, IntegerSuffix.EMPTY);
            Sign var7 = var5.getOrDefault(var62, Sign.PLUS);
            String var8 = (String)var5.get(var9);
            if (var8 != null) {
                return new IntegerLiteral(var7, Base.DECIMAL, var8, var6);
            }
            String var9 = (String)var5.get(var10);
            if (var9 != null) {
                return new IntegerLiteral(var7, Base.HEX, var9, var6);
            }
            String var10 = (String)var5.getOrThrow(var8);
            return new IntegerLiteral(var7, Base.BINARY, var10, var6);
        });
        Atom var13 = Atom.of("float_type_suffix");
        var52.put(var13, Term.alternative(Term.sequence(StringReaderTerms.characters('f', 'F'), Term.marker(var13, TypeSuffix.FLOAT)), Term.sequence(StringReaderTerms.characters('d', 'D'), Term.marker(var13, TypeSuffix.DOUBLE))), var1 -> (TypeSuffix)((Object)((Object)var1.getOrThrow(var13))));
        Atom var14 = Atom.of("float_exponent_part");
        var52.put(var14, Term.sequence(StringReaderTerms.characters('e', 'E'), Term.optional(var52.named(var62)), var52.named(var9)), var2 -> new Signed<String>(var2.getOrDefault(var62, Sign.PLUS), (String)var2.getOrThrow(var9)));
        Atom var15 = Atom.of("float_whole_part");
        Atom var16 = Atom.of("float_fraction_part");
        Atom var17 = Atom.of("float_literal");
        var52.putComplex(var17, Term.sequence(Term.optional(var52.named(var62)), Term.alternative(Term.sequence(var52.namedWithAlias(var9, var15), StringReaderTerms.character('.'), Term.cut(), Term.optional(var52.namedWithAlias(var9, var16)), Term.optional(var52.named(var14)), Term.optional(var52.named(var13))), Term.sequence(StringReaderTerms.character('.'), Term.cut(), var52.namedWithAlias(var9, var16), Term.optional(var52.named(var14)), Term.optional(var52.named(var13))), Term.sequence(var52.namedWithAlias(var9, var15), var52.named(var14), Term.cut(), Term.optional(var52.named(var13))), Term.sequence(var52.namedWithAlias(var9, var15), Term.optional(var52.named(var14)), var52.named(var13)))), var6 -> {
            Scope var7 = var6.scope();
            Sign var8 = var7.getOrDefault(var62, Sign.PLUS);
            String var9 = (String)var7.get(var15);
            String var10 = (String)var7.get(var16);
            Signed var11 = (Signed)var7.get(var14);
            TypeSuffix var12 = (TypeSuffix)((Object)((Object)var7.get(var13)));
            return SnbtGrammar.createFloat(var0, var8, var9, var10, var11, var12, var6);
        });
        Atom var18 = Atom.of("string_hex_2");
        var52.put(var18, new SimpleHexLiteralParseRule(2));
        Atom var19 = Atom.of("string_hex_4");
        var52.put(var19, new SimpleHexLiteralParseRule(4));
        Atom var20 = Atom.of("string_hex_8");
        var52.put(var20, new SimpleHexLiteralParseRule(8));
        Atom var21 = Atom.of("string_unicode_name");
        var52.put(var21, new GreedyPatternParseRule(UNICODE_NAME, ERROR_INVALID_CHARACTER_NAME));
        Atom var222 = Atom.of("string_escape_sequence");
        var52.putComplex(var222, Term.alternative(Term.sequence(StringReaderTerms.character('b'), Term.marker(var222, "\b")), Term.sequence(StringReaderTerms.character('s'), Term.marker(var222, " ")), Term.sequence(StringReaderTerms.character('t'), Term.marker(var222, "\t")), Term.sequence(StringReaderTerms.character('n'), Term.marker(var222, "\n")), Term.sequence(StringReaderTerms.character('f'), Term.marker(var222, "\f")), Term.sequence(StringReaderTerms.character('r'), Term.marker(var222, "\r")), Term.sequence(StringReaderTerms.character('\\'), Term.marker(var222, "\\")), Term.sequence(StringReaderTerms.character('\''), Term.marker(var222, "'")), Term.sequence(StringReaderTerms.character('\"'), Term.marker(var222, "\"")), Term.sequence(StringReaderTerms.character('x'), var52.named(var18)), Term.sequence(StringReaderTerms.character('u'), var52.named(var19)), Term.sequence(StringReaderTerms.character('U'), var52.named(var20)), Term.sequence(StringReaderTerms.character('N'), StringReaderTerms.character('{'), var52.named(var21), StringReaderTerms.character('}'))), var5 -> {
            int var10;
            Scope var6 = var5.scope();
            String var7 = (String)var6.getAny(var222);
            if (var7 != null) {
                return var7;
            }
            String var8 = (String)var6.getAny(var18, var19, var20);
            if (var8 != null) {
                int var9 = HexFormat.fromHexDigits(var8);
                if (!Character.isValidCodePoint(var9)) {
                    var5.errorCollector().store(var5.mark(), DelayedException.create(ERROR_INVALID_CODEPOINT, String.format(Locale.ROOT, "U+%08X", var9)));
                    return null;
                }
                return Character.toString(var9);
            }
            String var9 = (String)var6.getOrThrow(var21);
            try {
                var10 = Character.codePointOf(var9);
            }
            catch (IllegalArgumentException var11) {
                var5.errorCollector().store(var5.mark(), ERROR_INVALID_CHARACTER_NAME);
                return null;
            }
            return Character.toString(var10);
        });
        Atom var23 = Atom.of("string_plain_contents");
        var52.put(var23, PLAIN_STRING_CHUNK);
        Atom var24 = Atom.of("string_chunks");
        Atom var25 = Atom.of("string_contents");
        Atom var26 = Atom.of("single_quoted_string_chunk");
        NamedRule var27 = var52.put(var26, Term.alternative(var52.namedWithAlias(var23, var25), Term.sequence(StringReaderTerms.character('\\'), var52.namedWithAlias(var222, var25)), Term.sequence(StringReaderTerms.character('\"'), Term.marker(var25, "\""))), var1 -> (String)var1.getOrThrow(var25));
        Atom var28 = Atom.of("single_quoted_string_contents");
        var52.put(var28, Term.repeated(var27, var24), var1 -> SnbtGrammar.joinList((List)var1.getOrThrow(var24)));
        Atom var29 = Atom.of("double_quoted_string_chunk");
        NamedRule var30 = var52.put(var29, Term.alternative(var52.namedWithAlias(var23, var25), Term.sequence(StringReaderTerms.character('\\'), var52.namedWithAlias(var222, var25)), Term.sequence(StringReaderTerms.character('\''), Term.marker(var25, "'"))), var1 -> (String)var1.getOrThrow(var25));
        Atom var31 = Atom.of("double_quoted_string_contents");
        var52.put(var31, Term.repeated(var30, var24), var1 -> SnbtGrammar.joinList((List)var1.getOrThrow(var24)));
        Atom var322 = Atom.of("quoted_string_literal");
        var52.put(var322, Term.alternative(Term.sequence(StringReaderTerms.character('\"'), Term.cut(), Term.optional(var52.namedWithAlias(var31, var25)), StringReaderTerms.character('\"')), Term.sequence(StringReaderTerms.character('\''), Term.optional(var52.namedWithAlias(var28, var25)), StringReaderTerms.character('\''))), var1 -> (String)var1.getOrThrow(var25));
        Atom var33 = Atom.of("unquoted_string");
        var52.put(var33, new UnquotedStringParseRule(1, ERROR_EXPECTED_UNQUOTED_STRING));
        Atom var34 = Atom.of("literal");
        Atom var35 = Atom.of("arguments");
        var52.put(var35, Term.repeatedWithTrailingSeparator(var52.forward(var34), var35, StringReaderTerms.character(',')), var1 -> (List)var1.getOrThrow(var35));
        Atom var36 = Atom.of("unquoted_string_or_builtin");
        var52.putComplex(var36, Term.sequence(var52.named(var33), Term.optional(Term.sequence(StringReaderTerms.character('('), var52.named(var35), StringReaderTerms.character(')')))), var5 -> {
            Scope var6 = var5.scope();
            String var7 = (String)var6.getOrThrow(var33);
            if (var7.isEmpty() || !SnbtGrammar.isAllowedToStartUnquotedString(var7.charAt(0))) {
                var5.errorCollector().store(var5.mark(), SnbtOperations.BUILTIN_IDS, ERROR_INVALID_UNQUOTED_START);
                return null;
            }
            List var8 = (List)var6.get(var35);
            if (var8 != null) {
                SnbtOperations.BuiltinKey var9 = new SnbtOperations.BuiltinKey(var7, var8.size());
                SnbtOperations.BuiltinOperation var10 = SnbtOperations.BUILTIN_OPERATIONS.get(var9);
                if (var10 != null) {
                    return var10.run(var0, var8, var5);
                }
                var5.errorCollector().store(var5.mark(), DelayedException.create(ERROR_NO_SUCH_OPERATION, var9.toString()));
                return null;
            }
            if (var7.equalsIgnoreCase("true")) {
                return var12;
            }
            if (var7.equalsIgnoreCase("false")) {
                return var22;
            }
            return var0.createString(var7);
        });
        Atom var37 = Atom.of("map_key");
        var52.put(var37, Term.alternative(var52.named(var322), var52.named(var33)), var2 -> (String)var2.getAnyOrThrow(var322, var33));
        Atom var38 = Atom.of("map_entry");
        NamedRule var39 = var52.putComplex(var38, Term.sequence(var52.named(var37), StringReaderTerms.character(':'), var52.named(var34)), var2 -> {
            Scope var3 = var2.scope();
            String var4 = (String)var3.getOrThrow(var37);
            if (var4.isEmpty()) {
                var2.errorCollector().store(var2.mark(), ERROR_EMPTY_KEY);
                return null;
            }
            Object var5 = var3.getOrThrow(var34);
            return Map.entry(var4, var5);
        });
        Atom var40 = Atom.of("map_entries");
        var52.put(var40, Term.repeatedWithTrailingSeparator(var39, var40, StringReaderTerms.character(',')), var1 -> (List)var1.getOrThrow(var40));
        Atom var41 = Atom.of("map_literal");
        var52.put(var41, Term.sequence(StringReaderTerms.character('{'), var52.named(var40), StringReaderTerms.character('}')), var3 -> {
            List var4 = (List)var3.getOrThrow(var40);
            if (var4.isEmpty()) {
                return var32;
            }
            ImmutableMap.Builder var5 = ImmutableMap.builderWithExpectedSize((int)var4.size());
            for (Map.Entry var7 : var4) {
                var5.put(var0.createString((String)var7.getKey()), var7.getValue());
            }
            return var0.createMap((Map)var5.buildKeepingLast());
        });
        Atom var422 = Atom.of("list_entries");
        var52.put(var422, Term.repeatedWithTrailingSeparator(var52.forward(var34), var422, StringReaderTerms.character(',')), var1 -> (List)var1.getOrThrow(var422));
        Atom var43 = Atom.of("array_prefix");
        var52.put(var43, Term.alternative(Term.sequence(StringReaderTerms.character('B'), Term.marker(var43, ArrayPrefix.BYTE)), Term.sequence(StringReaderTerms.character('L'), Term.marker(var43, ArrayPrefix.LONG)), Term.sequence(StringReaderTerms.character('I'), Term.marker(var43, ArrayPrefix.INT))), var1 -> (ArrayPrefix)((Object)((Object)var1.getOrThrow(var43))));
        Atom var44 = Atom.of("int_array_entries");
        var52.put(var44, Term.repeatedWithTrailingSeparator(var122, var44, StringReaderTerms.character(',')), var1 -> (List)var1.getOrThrow(var44));
        Atom var45 = Atom.of("list_literal");
        var52.putComplex(var45, Term.sequence(StringReaderTerms.character('['), Term.alternative(Term.sequence(var52.named(var43), StringReaderTerms.character(';'), var52.named(var44)), var52.named(var422)), StringReaderTerms.character(']')), var5 -> {
            Scope var6 = var5.scope();
            ArrayPrefix var7 = (ArrayPrefix)((Object)((Object)var6.get(var43)));
            if (var7 != null) {
                List var8 = (List)var6.getOrThrow(var44);
                return var8.isEmpty() ? var7.create(var0) : var7.create(var0, var8, var5);
            }
            List var8 = (List)var6.getOrThrow(var422);
            return var8.isEmpty() ? var42 : var0.createList(var8.stream());
        });
        NamedRule var46 = var52.putComplex(var34, Term.alternative(Term.sequence(Term.positiveLookahead(NUMBER_LOOKEAHEAD), Term.alternative(var52.namedWithAlias(var17, var34), var52.named(var11))), Term.sequence(Term.positiveLookahead(StringReaderTerms.characters('\"', '\'')), Term.cut(), var52.named(var322)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('{')), Term.cut(), var52.namedWithAlias(var41, var34)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('[')), Term.cut(), var52.namedWithAlias(var45, var34)), var52.namedWithAlias(var36, var34)), var4 -> {
            Scope var5 = var4.scope();
            String var6 = (String)var5.get(var322);
            if (var6 != null) {
                return var0.createString(var6);
            }
            IntegerLiteral var7 = (IntegerLiteral)var5.get(var11);
            if (var7 != null) {
                return var7.create(var0, var4);
            }
            return var5.getOrThrow(var34);
        });
        return new Grammar<Object>(var52, var46);
    }

    static enum Sign {
        PLUS,
        MINUS;


        public void append(StringBuilder var0) {
            if (this == MINUS) {
                var0.append("-");
            }
        }
    }

    static final class Signed<T>
    extends Record {
        private final Sign sign;
        final T value;

        Signed(Sign var0, T var1) {
            this.sign = var0;
            this.value = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Signed.class, "sign;value", "sign", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Signed.class, "sign;value", "sign", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Signed.class, "sign;value", "sign", "value"}, this, var0);
        }

        public Sign sign() {
            return this.sign;
        }

        public T value() {
            return this.value;
        }
    }

    static enum TypeSuffix {
        FLOAT,
        DOUBLE,
        BYTE,
        SHORT,
        INT,
        LONG;

    }

    static final class IntegerSuffix
    extends Record {
        final @Nullable SignedPrefix signed;
        final @Nullable TypeSuffix type;
        public static final IntegerSuffix EMPTY = new IntegerSuffix(null, null);

        IntegerSuffix(@Nullable SignedPrefix var0, @Nullable TypeSuffix var1) {
            this.signed = var0;
            this.type = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerSuffix.class, "signed;type", "signed", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerSuffix.class, "signed;type", "signed", "type"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerSuffix.class, "signed;type", "signed", "type"}, this, var0);
        }

        public @Nullable SignedPrefix signed() {
            return this.signed;
        }

        public @Nullable TypeSuffix type() {
            return this.type;
        }
    }

    static enum SignedPrefix {
        SIGNED,
        UNSIGNED;

    }

    static class SimpleHexLiteralParseRule
    extends GreedyPredicateParseRule {
        public SimpleHexLiteralParseRule(int var0) {
            super(var0, var0, DelayedException.create(ERROR_EXPECTED_HEX_ESCAPE, String.valueOf(var0)));
        }

        @Override
        protected boolean isAccepted(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    }

    static enum ArrayPrefix {
        BYTE(TypeSuffix.BYTE, new TypeSuffix[0]){
            private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);

            @Override
            public <T> T create(DynamicOps<T> var0) {
                return (T)var0.createByteList(EMPTY_BUFFER);
            }

            @Override
            public <T> @Nullable T create(DynamicOps<T> var0, List<IntegerLiteral> var1, ParseState<?> var2) {
                ByteArrayList var3 = new ByteArrayList();
                for (IntegerLiteral var5 : var1) {
                    Number var6 = this.buildNumber(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.byteValue());
                }
                return (T)var0.createByteList(ByteBuffer.wrap(var3.toByteArray()));
            }
        }
        ,
        INT(TypeSuffix.INT, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT}){

            @Override
            public <T> T create(DynamicOps<T> var0) {
                return (T)var0.createIntList(IntStream.empty());
            }

            @Override
            public <T> @Nullable T create(DynamicOps<T> var0, List<IntegerLiteral> var1, ParseState<?> var2) {
                IntStream.Builder var3 = IntStream.builder();
                for (IntegerLiteral var5 : var1) {
                    Number var6 = this.buildNumber(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.intValue());
                }
                return (T)var0.createIntList(var3.build());
            }
        }
        ,
        LONG(TypeSuffix.LONG, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT, TypeSuffix.INT}){

            @Override
            public <T> T create(DynamicOps<T> var0) {
                return (T)var0.createLongList(LongStream.empty());
            }

            @Override
            public <T> @Nullable T create(DynamicOps<T> var0, List<IntegerLiteral> var1, ParseState<?> var2) {
                LongStream.Builder var3 = LongStream.builder();
                for (IntegerLiteral var5 : var1) {
                    Number var6 = this.buildNumber(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.longValue());
                }
                return (T)var0.createLongList(var3.build());
            }
        };

        private final TypeSuffix defaultType;
        private final Set<TypeSuffix> additionalTypes;

        ArrayPrefix(TypeSuffix var2, TypeSuffix ... var3) {
            this.additionalTypes = Set.of(var3);
            this.defaultType = var2;
        }

        public boolean isAllowed(TypeSuffix var0) {
            return var0 == this.defaultType || this.additionalTypes.contains((Object)var0);
        }

        public abstract <T> T create(DynamicOps<T> var1);

        public abstract <T> @Nullable T create(DynamicOps<T> var1, List<IntegerLiteral> var2, ParseState<?> var3);

        protected @Nullable Number buildNumber(IntegerLiteral var0, ParseState<?> var1) {
            TypeSuffix var2 = this.computeType(var0.suffix);
            if (var2 == null) {
                var1.errorCollector().store(var1.mark(), ERROR_INVALID_ARRAY_ELEMENT_TYPE);
                return null;
            }
            return (Number)var0.create(JavaOps.INSTANCE, var2, var1);
        }

        private @Nullable TypeSuffix computeType(IntegerSuffix var0) {
            TypeSuffix var1 = var0.type();
            if (var1 == null) {
                return this.defaultType;
            }
            if (!this.isAllowed(var1)) {
                return null;
            }
            return var1;
        }
    }

    static final class IntegerLiteral
    extends Record {
        private final Sign sign;
        private final Base base;
        private final String digits;
        final IntegerSuffix suffix;

        IntegerLiteral(Sign var0, Base var1, String var2, IntegerSuffix var3) {
            this.sign = var0;
            this.base = var1;
            this.digits = var2;
            this.suffix = var3;
        }

        private SignedPrefix signedOrDefault() {
            if (this.suffix.signed != null) {
                return this.suffix.signed;
            }
            return switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> SignedPrefix.UNSIGNED;
                case 1 -> SignedPrefix.SIGNED;
            };
        }

        private String cleanupDigits(Sign var0) {
            boolean var1 = SnbtGrammar.needsUnderscoreRemoval(this.digits);
            if (var0 == Sign.MINUS || var1) {
                StringBuilder var2 = new StringBuilder();
                var0.append(var2);
                SnbtGrammar.cleanAndAppend(var2, this.digits, var1);
                return var2.toString();
            }
            return this.digits;
        }

        public <T> @Nullable T create(DynamicOps<T> var0, ParseState<?> var1) {
            return this.create(var0, Objects.requireNonNullElse(this.suffix.type, TypeSuffix.INT), var1);
        }

        public <T> @Nullable T create(DynamicOps<T> var0, TypeSuffix var1, ParseState<?> var2) {
            boolean var3;
            boolean bl = var3 = this.signedOrDefault() == SignedPrefix.SIGNED;
            if (!var3 && this.sign == Sign.MINUS) {
                var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_NON_NEGATIVE_NUMBER);
                return null;
            }
            String var4 = this.cleanupDigits(this.sign);
            int var5 = switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 2;
                case 1 -> 10;
                case 2 -> 16;
            };
            try {
                if (var3) {
                    return (T)(switch (var1.ordinal()) {
                        case 2 -> var0.createByte(Byte.parseByte(var4, var5));
                        case 3 -> var0.createShort(Short.parseShort(var4, var5));
                        case 4 -> var0.createInt(Integer.parseInt(var4, var5));
                        case 5 -> var0.createLong(Long.parseLong(var4, var5));
                        default -> {
                            var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                            yield null;
                        }
                    });
                }
                return (T)(switch (var1.ordinal()) {
                    case 2 -> var0.createByte(UnsignedBytes.parseUnsignedByte((String)var4, (int)var5));
                    case 3 -> var0.createShort(SnbtGrammar.parseUnsignedShort(var4, var5));
                    case 4 -> var0.createInt(Integer.parseUnsignedInt(var4, var5));
                    case 5 -> var0.createLong(Long.parseUnsignedLong(var4, var5));
                    default -> {
                        var2.errorCollector().store(var2.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                        yield null;
                    }
                });
            }
            catch (NumberFormatException var6) {
                var2.errorCollector().store(var2.mark(), SnbtGrammar.createNumberParseError(var6));
                return null;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerLiteral.class, "sign;base;digits;suffix", "sign", "base", "digits", "suffix"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerLiteral.class, "sign;base;digits;suffix", "sign", "base", "digits", "suffix"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerLiteral.class, "sign;base;digits;suffix", "sign", "base", "digits", "suffix"}, this, var0);
        }

        public Sign sign() {
            return this.sign;
        }

        public Base base() {
            return this.base;
        }

        public String digits() {
            return this.digits;
        }

        public IntegerSuffix suffix() {
            return this.suffix;
        }
    }

    static enum Base {
        BINARY,
        DECIMAL,
        HEX;

    }
}

