/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final int MAX_DEPTH = 64;
    private static final int MAX_LENGTH = 128;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_KEY = ChatFormatting.AQUA;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_STRING = ChatFormatting.GREEN;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER = ChatFormatting.GOLD;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = ChatFormatting.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private static final String NAME_VALUE_SEPARATOR = ": ";
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String WRAPPED_ELEMENT_SEPARATOR = ELEMENT_SEPARATOR + "\n";
    private static final String SPACED_ELEMENT_SEPARATOR = ELEMENT_SEPARATOR + " ";
    private static final Component FOLDED = Component.literal("<...>").withStyle(ChatFormatting.GRAY);
    private static final Component BYTE_TYPE = Component.literal("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component SHORT_TYPE = Component.literal("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component INT_TYPE = Component.literal("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component LONG_TYPE = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component FLOAT_TYPE = Component.literal("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component DOUBLE_TYPE = Component.literal("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final Component BYTE_ARRAY_TYPE = Component.literal("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private final String indentation;
    private int indentDepth;
    private int depth;
    private final MutableComponent result = Component.empty();

    public TextComponentTagVisitor(String var0) {
        this.indentation = var0;
    }

    public Component visit(Tag var0) {
        var0.accept(this);
        return this.result;
    }

    @Override
    public void visitString(StringTag var0) {
        String var1 = StringTag.quoteAndEscape(var0.value());
        String var2 = var1.substring(0, 1);
        MutableComponent var3 = Component.literal(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result.append(var2).append(var3).append(var2);
    }

    @Override
    public void visitByte(ByteTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(BYTE_TYPE);
    }

    @Override
    public void visitShort(ShortTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(SHORT_TYPE);
    }

    @Override
    public void visitInt(IntTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
    }

    @Override
    public void visitLong(LongTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(LONG_TYPE);
    }

    @Override
    public void visitFloat(FloatTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(FLOAT_TYPE);
    }

    @Override
    public void visitDouble(DoubleTag var0) {
        this.result.append(Component.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(DOUBLE_TYPE);
    }

    @Override
    public void visitByteArray(ByteArrayTag var0) {
        this.result.append(LIST_OPEN).append(BYTE_ARRAY_TYPE).append(LIST_TYPE_SEPARATOR);
        byte[] var1 = var0.getAsByteArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            MutableComponent var3 = Component.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            this.result.append(ELEMENT_SPACING).append(var3).append(BYTE_ARRAY_TYPE);
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitIntArray(IntArrayTag var0) {
        this.result.append(LIST_OPEN).append(INT_TYPE).append(LIST_TYPE_SEPARATOR);
        int[] var1 = var0.getAsIntArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            this.result.append(ELEMENT_SPACING).append(Component.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitLongArray(LongArrayTag var0) {
        this.result.append(LIST_OPEN).append(LONG_TYPE).append(LIST_TYPE_SEPARATOR);
        long[] var1 = var0.getAsLongArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            MutableComponent var3 = Component.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            this.result.append(ELEMENT_SPACING).append(var3).append(LONG_TYPE);
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    private static boolean shouldWrapListElements(ListTag var0) {
        if (var0.size() >= 8) {
            return false;
        }
        for (Tag var2 : var0) {
            if (var2 instanceof NumericTag) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitList(ListTag var0) {
        if (var0.isEmpty()) {
            this.result.append("[]");
            return;
        }
        if (this.depth >= 64) {
            this.result.append(LIST_OPEN).append(FOLDED).append(LIST_CLOSE);
            return;
        }
        if (!TextComponentTagVisitor.shouldWrapListElements(var0)) {
            this.result.append(LIST_OPEN);
            for (int var1 = 0; var1 < var0.size(); ++var1) {
                if (var1 != 0) {
                    this.result.append(SPACED_ELEMENT_SEPARATOR);
                }
                this.appendSubTag(var0.get(var1), false);
            }
            this.result.append(LIST_CLOSE);
            return;
        }
        this.result.append(LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE);
        }
        String var1 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        for (int var2 = 0; var2 < var0.size() && var2 < 128; ++var2) {
            this.result.append(var1);
            this.appendSubTag(var0.get(var2), true);
            if (var2 == var0.size() - 1) continue;
            this.result.append(this.indentation.isEmpty() ? SPACED_ELEMENT_SEPARATOR : WRAPPED_ELEMENT_SEPARATOR);
        }
        if (var0.size() > 128) {
            this.result.append(var1).append(FOLDED);
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE + Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitCompound(CompoundTag var0) {
        Object var2;
        if (var0.isEmpty()) {
            this.result.append("{}");
            return;
        }
        if (this.depth >= 64) {
            this.result.append(STRUCT_OPEN).append(FOLDED).append(STRUCT_CLOSE);
            return;
        }
        this.result.append(STRUCT_OPEN);
        Collection<String> var1 = var0.keySet();
        if (LOGGER.isDebugEnabled()) {
            var2 = Lists.newArrayList(var0.keySet());
            Collections.sort(var2);
            var1 = var2;
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE);
        }
        var2 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        Iterator<String> var3 = var1.iterator();
        while (var3.hasNext()) {
            String var4 = var3.next();
            this.result.append((String)var2).append(TextComponentTagVisitor.handleEscapePretty(var4)).append(NAME_VALUE_SEPARATOR);
            this.appendSubTag(var0.get(var4), true);
            if (!var3.hasNext()) continue;
            this.result.append(this.indentation.isEmpty() ? SPACED_ELEMENT_SEPARATOR : WRAPPED_ELEMENT_SEPARATOR);
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE + Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        this.result.append(STRUCT_CLOSE);
    }

    private void appendSubTag(Tag var0, boolean var1) {
        if (var1) {
            ++this.indentDepth;
        }
        ++this.depth;
        try {
            var0.accept(this);
        }
        finally {
            if (var1) {
                --this.indentDepth;
            }
            --this.depth;
        }
    }

    protected static Component handleEscapePretty(String var0) {
        if (SIMPLE_VALUE.matcher(var0).matches()) {
            return Component.literal(var0).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String var1 = StringTag.quoteAndEscape(var0);
        String var2 = var1.substring(0, 1);
        MutableComponent var3 = Component.literal(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return Component.literal(var2).append(var3).append(var2);
    }

    @Override
    public void visitEnd(EndTag var0) {
    }
}

