/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import org.slf4j.Logger;

public class PacketProcessor
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<ListenerAndPacket<?>> packetsToBeHandled = Queues.newConcurrentLinkedQueue();
    private final Thread runningThread;
    private boolean closed;

    public PacketProcessor(Thread thread) {
        this.runningThread = thread;
    }

    public boolean isSameThread() {
        return Thread.currentThread() == this.runningThread;
    }

    public <T extends PacketListener> void scheduleIfPossible(T t0, Packet<T> packet) {
        if (this.closed) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        this.packetsToBeHandled.add(new ListenerAndPacket<T>(t0, packet));
    }

    public void processQueuedPackets() {
        if (!this.closed) {
            while (!this.packetsToBeHandled.isEmpty()) {
                this.packetsToBeHandled.poll().handle();
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private record ListenerAndPacket<T extends PacketListener>(T listener, Packet<T> packet) {
        public void handle() {
            T t = this.listener;
            if (t instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)t;
                if (serverCommonPacketListener.processedDisconnect) {
                    return;
                }
            }
            if (this.listener.shouldHandleMessage(this.packet)) {
                try {
                    this.packet.handle(this.listener);
                }
                catch (Exception exception) {
                    ReportedException reportedexception;
                    if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                        throw PacketUtils.makeReportedException(exception, this.packet, this.listener);
                    }
                    this.listener.onPacketError(this.packet, exception);
                }
            } else {
                LOGGER.debug("Ignoring packet due to disconnection: {}", this.packet);
            }
        }
    }
}

