/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public class ComponentUtils {
    public static final String DEFAULT_SEPARATOR_TEXT = ", ";
    public static final Component DEFAULT_SEPARATOR = Component.literal(", ").withStyle(ChatFormatting.GRAY);
    public static final Component DEFAULT_NO_STYLE_SEPARATOR = Component.literal(", ");

    @CheckReturnValue
    public static MutableComponent mergeStyles(MutableComponent var0, Style var1) {
        if (var1.isEmpty()) {
            return var0;
        }
        Style var2 = var0.getStyle();
        if (var2.isEmpty()) {
            return var0.setStyle(var1);
        }
        if (var2.equals(var1)) {
            return var0;
        }
        return var0.setStyle(var2.applyTo(var1));
    }

    @CheckReturnValue
    public static Component mergeStyles(Component var0, Style var1) {
        if (var1.isEmpty()) {
            return var0;
        }
        Style var2 = var0.getStyle();
        if (var2.isEmpty()) {
            return var0.copy().setStyle(var1);
        }
        if (var2.equals(var1)) {
            return var0;
        }
        return var0.copy().setStyle(var2.applyTo(var1));
    }

    public static Optional<MutableComponent> updateForEntity(@Nullable CommandSourceStack var0, Optional<Component> var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        return var1.isPresent() ? Optional.of(ComponentUtils.updateForEntity(var0, var1.get(), var2, var3)) : Optional.empty();
    }

    public static MutableComponent updateForEntity(@Nullable CommandSourceStack var0, Component var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        if (var3 > 100) {
            return var1.copy();
        }
        MutableComponent var4 = var1.getContents().resolve(var0, var2, var3 + 1);
        for (Component var6 : var1.getSiblings()) {
            var4.append(ComponentUtils.updateForEntity(var0, var6, var2, var3 + 1));
        }
        return var4.withStyle(ComponentUtils.resolveStyle(var0, var1.getStyle(), var2, var3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Style resolveStyle(@Nullable CommandSourceStack var0, Style var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        HoverEvent var4 = var1.getHoverEvent();
        if (!(var4 instanceof HoverEvent.ShowText)) return var1;
        HoverEvent.ShowText showText = (HoverEvent.ShowText)var4;
        try {
            Component component;
            Component var6 = component = showText.value();
            HoverEvent.ShowText var7 = new HoverEvent.ShowText(ComponentUtils.updateForEntity(var0, var6, var2, var3 + 1));
            return var1.withHoverEvent(var7);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static Component formatList(Collection<String> var02) {
        return ComponentUtils.formatAndSortList(var02, var0 -> Component.literal(var0).withStyle(ChatFormatting.GREEN));
    }

    public static <T extends Comparable<T>> Component formatAndSortList(Collection<T> var0, Function<T, Component> var1) {
        if (var0.isEmpty()) {
            return CommonComponents.EMPTY;
        }
        if (var0.size() == 1) {
            return var1.apply((Comparable)var0.iterator().next());
        }
        ArrayList var2 = Lists.newArrayList(var0);
        var2.sort(Comparable::compareTo);
        return ComponentUtils.formatList(var2, var1);
    }

    public static <T> Component formatList(Collection<? extends T> var0, Function<T, Component> var1) {
        return ComponentUtils.formatList(var0, DEFAULT_SEPARATOR, var1);
    }

    public static <T> MutableComponent formatList(Collection<? extends T> var0, Optional<? extends Component> var1, Function<T, Component> var2) {
        return ComponentUtils.formatList(var0, (Component)DataFixUtils.orElse(var1, (Object)DEFAULT_SEPARATOR), var2);
    }

    public static Component formatList(Collection<? extends Component> var0, Component var1) {
        return ComponentUtils.formatList(var0, var1, Function.identity());
    }

    public static <T> MutableComponent formatList(Collection<? extends T> var0, Component var1, Function<T, Component> var2) {
        if (var0.isEmpty()) {
            return Component.empty();
        }
        if (var0.size() == 1) {
            return var2.apply(var0.iterator().next()).copy();
        }
        MutableComponent var3 = Component.empty();
        boolean var4 = true;
        for (T var6 : var0) {
            if (!var4) {
                var3.append(var1);
            }
            var3.append(var2.apply(var6));
            var4 = false;
        }
        return var3;
    }

    public static MutableComponent wrapInSquareBrackets(Component var0) {
        return Component.translatable("chat.square_brackets", var0);
    }

    public static Component fromMessage(Message var0) {
        if (var0 instanceof Component) {
            Component var1 = (Component)var0;
            return var1;
        }
        return Component.literal(var0.getString());
    }

    public static boolean isTranslationResolvable(@Nullable Component var0) {
        ComponentContents componentContents;
        if (var0 != null && (componentContents = var0.getContents()) instanceof TranslatableContents) {
            TranslatableContents var1 = (TranslatableContents)componentContents;
            String var2 = var1.getKey();
            String var3 = var1.getFallback();
            return var3 != null || Language.getInstance().has(var2);
        }
        return true;
    }

    public static MutableComponent copyOnClickText(String var0) {
        return ComponentUtils.wrapInSquareBrackets(Component.literal(var0).withStyle(var1 -> var1.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent.CopyToClipboard(var0)).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.copy.click"))).withInsertion(var0)));
    }
}

