/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class FilterMask {
    public static final Codec<FilterMask> CODEC = StringRepresentable.fromEnum(Type::values).dispatch(FilterMask::type, Type::codec);
    public static final FilterMask FULLY_FILTERED = new FilterMask(new BitSet(0), Type.FULLY_FILTERED);
    public static final FilterMask PASS_THROUGH = new FilterMask(new BitSet(0), Type.PASS_THROUGH);
    public static final Style FILTERED_STYLE = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.filtered")));
    static final MapCodec<FilterMask> PASS_THROUGH_CODEC = MapCodec.unit((Object)PASS_THROUGH);
    static final MapCodec<FilterMask> FULLY_FILTERED_CODEC = MapCodec.unit((Object)FULLY_FILTERED);
    static final MapCodec<FilterMask> PARTIALLY_FILTERED_CODEC = ExtraCodecs.BIT_SET.xmap(FilterMask::new, FilterMask::mask).fieldOf("value");
    private static final char HASH = '#';
    private final BitSet mask;
    private final Type type;

    private FilterMask(BitSet var0, Type var1) {
        this.mask = var0;
        this.type = var1;
    }

    private FilterMask(BitSet var0) {
        this.mask = var0;
        this.type = Type.PARTIALLY_FILTERED;
    }

    public FilterMask(int var0) {
        this(new BitSet(var0), Type.PARTIALLY_FILTERED);
    }

    private Type type() {
        return this.type;
    }

    private BitSet mask() {
        return this.mask;
    }

    public static FilterMask read(FriendlyByteBuf var0) {
        Type var1 = var0.readEnum(Type.class);
        return switch (var1.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PASS_THROUGH;
            case 1 -> FULLY_FILTERED;
            case 2 -> new FilterMask(var0.readBitSet(), Type.PARTIALLY_FILTERED);
        };
    }

    public static void write(FriendlyByteBuf var0, FilterMask var1) {
        var0.writeEnum(var1.type);
        if (var1.type == Type.PARTIALLY_FILTERED) {
            var0.writeBitSet(var1.mask);
        }
    }

    public void setFiltered(int var0) {
        this.mask.set(var0);
    }

    public @Nullable String apply(String var0) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> null;
            case 0 -> var0;
            case 2 -> {
                char[] var1 = var0.toCharArray();
                for (int var2 = 0; var2 < var1.length && var2 < this.mask.length(); ++var2) {
                    if (!this.mask.get(var2)) continue;
                    var1[var2] = 35;
                }
                yield new String(var1);
            }
        };
    }

    public @Nullable Component applyWithFormatting(String var0) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> null;
            case 0 -> Component.literal(var0);
            case 2 -> {
                MutableComponent var1 = Component.empty();
                int var2 = 0;
                boolean var3 = this.mask.get(0);
                while (true) {
                    int var4 = var3 ? this.mask.nextClearBit(var2) : this.mask.nextSetBit(var2);
                    int v1 = var4 = var4 < 0 ? var0.length() : var4;
                    if (var4 == var2) break;
                    if (var3) {
                        var1.append(Component.literal(StringUtils.repeat((char)'#', (int)(var4 - var2))).withStyle(FILTERED_STYLE));
                    } else {
                        var1.append(var0.substring(var2, var4));
                    }
                    var3 = !var3;
                    var2 = var4;
                }
                yield var1;
            }
        };
    }

    public boolean isEmpty() {
        return this.type == Type.PASS_THROUGH;
    }

    public boolean isFullyFiltered() {
        return this.type == Type.FULLY_FILTERED;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        FilterMask var1 = (FilterMask)var0;
        return this.mask.equals(var1.mask) && this.type == var1.type;
    }

    public int hashCode() {
        int var0 = this.mask.hashCode();
        var0 = 31 * var0 + this.type.hashCode();
        return var0;
    }

    static enum Type implements StringRepresentable
    {
        PASS_THROUGH("pass_through", () -> PASS_THROUGH_CODEC),
        FULLY_FILTERED("fully_filtered", () -> FULLY_FILTERED_CODEC),
        PARTIALLY_FILTERED("partially_filtered", () -> PARTIALLY_FILTERED_CODEC);

        private final String serializedName;
        private final Supplier<MapCodec<FilterMask>> codec;

        private Type(String var2, Supplier var3) {
            this.serializedName = var2;
            this.codec = var3;
        }

        @Override
        public String getSerializedName() {
            return this.serializedName;
        }

        private MapCodec<FilterMask> codec() {
            return this.codec.get();
        }
    }
}

