/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Unit;

public interface FormattedText {
    public static final Optional<Unit> STOP_ITERATION = Optional.of(Unit.INSTANCE);
    public static final FormattedText EMPTY = new FormattedText(){

        @Override
        public <T> Optional<T> visit(ContentConsumer<T> ichatformatted_a) {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> visit(StyledContentConsumer<T> ichatformatted_b, Style chatmodifier) {
            return Optional.empty();
        }
    };

    public <T> Optional<T> visit(ContentConsumer<T> var1);

    public <T> Optional<T> visit(StyledContentConsumer<T> var1, Style var2);

    public static FormattedText of(final String s) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> ichatformatted_a) {
                return ichatformatted_a.accept(s);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> ichatformatted_b, Style chatmodifier) {
                return ichatformatted_b.accept(chatmodifier, s);
            }
        };
    }

    public static FormattedText of(final String s, final Style chatmodifier) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> ichatformatted_a) {
                return ichatformatted_a.accept(s);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> ichatformatted_b, Style chatmodifier1) {
                return ichatformatted_b.accept(chatmodifier.applyTo(chatmodifier1), s);
            }
        };
    }

    public static FormattedText composite(FormattedText ... aichatformatted) {
        return FormattedText.composite((List<? extends FormattedText>)ImmutableList.copyOf((Object[])aichatformatted));
    }

    public static FormattedText composite(final List<? extends FormattedText> list) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> ichatformatted_a) {
                for (FormattedText ichatformatted : list) {
                    Optional<T> optional = ichatformatted.visit(ichatformatted_a);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> ichatformatted_b, Style chatmodifier) {
                for (FormattedText ichatformatted : list) {
                    Optional<T> optional = ichatformatted.visit(ichatformatted_b, chatmodifier);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }
        };
    }

    default public String getString() {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(s -> {
            if (stringbuilder.length() >= Short.MAX_VALUE) {
                throw new IllegalArgumentException("Component string exceeded maximum length");
            }
            stringbuilder.append(s);
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public static interface ContentConsumer<T> {
        public Optional<T> accept(String var1);
    }

    public static interface StyledContentConsumer<T> {
        public Optional<T> accept(Style var1, String var2);
    }
}

