/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;

public record SignedMessageBody(String content, Instant timeStamp, long salt, LastSeenMessages lastSeen) {
    public static final MapCodec<SignedMessageBody> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("content").forGetter(SignedMessageBody::content), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("time_stamp").forGetter(SignedMessageBody::timeStamp), (App)Codec.LONG.fieldOf("salt").forGetter(SignedMessageBody::salt), (App)LastSeenMessages.CODEC.optionalFieldOf("last_seen", (Object)LastSeenMessages.EMPTY).forGetter(SignedMessageBody::lastSeen)).apply((Applicative)var0, SignedMessageBody::new));

    public static SignedMessageBody unsigned(String var0) {
        return new SignedMessageBody(var0, Instant.now(), 0L, LastSeenMessages.EMPTY);
    }

    public void updateSignature(SignatureUpdater.Output var0) throws SignatureException {
        var0.update(Longs.toByteArray((long)this.salt));
        var0.update(Longs.toByteArray((long)this.timeStamp.getEpochSecond()));
        byte[] var1 = this.content.getBytes(StandardCharsets.UTF_8);
        var0.update(Ints.toByteArray((int)var1.length));
        var0.update(var1);
        this.lastSeen.updateSignature(var0);
    }

    public Packed pack(MessageSignatureCache var0) {
        return new Packed(this.content, this.timeStamp, this.salt, this.lastSeen.pack(var0));
    }

    public record Packed(String content, Instant timeStamp, long salt, LastSeenMessages.Packed lastSeen) {
        public Packed(FriendlyByteBuf var0) {
            this(var0.readUtf(256), var0.readInstant(), var0.readLong(), new LastSeenMessages.Packed(var0));
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeUtf(this.content, 256);
            var0.writeInstant(this.timeStamp);
            var0.writeLong(this.salt);
            this.lastSeen.write(var0);
        }

        public Optional<SignedMessageBody> unpack(MessageSignatureCache var02) {
            return this.lastSeen.unpack(var02).map(var0 -> new SignedMessageBody(this.content, this.timeStamp, this.salt, (LastSeenMessages)var0));
        }
    }
}

