/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.util.function.BooleanSupplier;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.SignatureValidator;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@FunctionalInterface
public interface SignedMessageValidator {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final SignedMessageValidator ACCEPT_UNSIGNED = PlayerChatMessage::removeSignature;
    public static final SignedMessageValidator REJECT_ALL = var0 -> {
        LOGGER.error("Received chat message from {}, but they have no chat session initialized and secure chat is enforced", (Object)var0.sender());
        return null;
    };

    public @Nullable PlayerChatMessage updateAndValidate(PlayerChatMessage var1);

    public static class KeyBased
    implements SignedMessageValidator {
        private final SignatureValidator validator;
        private final BooleanSupplier expired;
        private @Nullable PlayerChatMessage lastMessage;
        private boolean isChainValid = true;

        public KeyBased(SignatureValidator var0, BooleanSupplier var1) {
            this.validator = var0;
            this.expired = var1;
        }

        private boolean validateChain(PlayerChatMessage var0) {
            if (var0.equals(this.lastMessage)) {
                return true;
            }
            if (this.lastMessage != null && !var0.link().isDescendantOf(this.lastMessage.link())) {
                LOGGER.error("Received out-of-order chat message from {}: expected index > {} for session {}, but was {} for session {}", new Object[]{var0.sender(), this.lastMessage.link().index(), this.lastMessage.link().sessionId(), var0.link().index(), var0.link().sessionId()});
                return false;
            }
            return true;
        }

        private boolean validate(PlayerChatMessage var0) {
            if (this.expired.getAsBoolean()) {
                LOGGER.error("Received message with expired profile public key from {} with session {}", (Object)var0.sender(), (Object)var0.link().sessionId());
                return false;
            }
            if (!var0.verify(this.validator)) {
                LOGGER.error("Received message with invalid signature (is the session wrong, or signature cache out of sync?): {}", (Object)PlayerChatMessage.describeSigned(var0));
                return false;
            }
            return this.validateChain(var0);
        }

        @Override
        public @Nullable PlayerChatMessage updateAndValidate(PlayerChatMessage var0) {
            boolean bl = this.isChainValid = this.isChainValid && this.validate(var0);
            if (!this.isChainValid) {
                return null;
            }
            this.lastMessage = var0;
            return var0;
        }
    }
}

