/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import org.jspecify.annotations.Nullable;

public final class TextColor {
    private static final String CUSTOM_COLOR_PREFIX = "#";
    public static final Codec<TextColor> CODEC = Codec.STRING.comapFlatMap(TextColor::parseColor, TextColor::serialize);
    private static final Map<ChatFormatting, TextColor> LEGACY_FORMAT_TO_COLOR = (Map)Stream.of(ChatFormatting.values()).filter(ChatFormatting::isColor).collect(ImmutableMap.toImmutableMap(Function.identity(), enumchatformat -> new TextColor(enumchatformat.getColor(), enumchatformat.getName(), (ChatFormatting)enumchatformat)));
    private static final Map<String, TextColor> NAMED_COLORS = (Map)LEGACY_FORMAT_TO_COLOR.values().stream().collect(ImmutableMap.toImmutableMap(chathexcolor -> chathexcolor.name, Function.identity()));
    private final int value;
    public final @Nullable String name;
    public final @Nullable ChatFormatting format;

    private TextColor(int i, String s, ChatFormatting format) {
        this.value = i & 0xFFFFFF;
        this.name = s;
        this.format = format;
    }

    private TextColor(int i) {
        this.value = i & 0xFFFFFF;
        this.name = null;
        this.format = null;
    }

    public int getValue() {
        return this.value;
    }

    public String serialize() {
        return this.name != null ? this.name : this.formatValue();
    }

    private String formatValue() {
        return String.format(Locale.ROOT, "#%06X", this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            TextColor chathexcolor = (TextColor)object;
            return this.value == chathexcolor.value;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public String toString() {
        return this.serialize();
    }

    public static @Nullable TextColor fromLegacyFormat(ChatFormatting enumchatformat) {
        return LEGACY_FORMAT_TO_COLOR.get(enumchatformat);
    }

    public static TextColor fromRgb(int i) {
        return new TextColor(i);
    }

    public static DataResult<TextColor> parseColor(String s) {
        if (s.startsWith(CUSTOM_COLOR_PREFIX)) {
            try {
                int i = Integer.parseInt(s.substring(1), 16);
                return i >= 0 && i <= 0xFFFFFF ? DataResult.success((Object)TextColor.fromRgb(i), (Lifecycle)Lifecycle.stable()) : DataResult.error(() -> "Color value out of range: " + s);
            }
            catch (NumberFormatException numberformatexception) {
                return DataResult.error(() -> "Invalid color value: " + s);
            }
        }
        TextColor chathexcolor = NAMED_COLORS.get(s);
        return chathexcolor == null ? DataResult.error(() -> "Invalid color name: " + s) : DataResult.success((Object)chathexcolor, (Lifecycle)Lifecycle.stable());
    }
}

