/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import org.jspecify.annotations.Nullable;

public record ScoreContents(Either<SelectorPattern, String> name, String objective) implements ComponentContents
{
    public static final MapCodec<ScoreContents> INNER_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.either(SelectorPattern.CODEC, (Codec)Codec.STRING).fieldOf("name").forGetter(ScoreContents::name), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::objective)).apply((Applicative)var0, ScoreContents::new));
    public static final MapCodec<ScoreContents> MAP_CODEC = INNER_CODEC.fieldOf("score");

    public MapCodec<ScoreContents> codec() {
        return MAP_CODEC;
    }

    private ScoreHolder findTargetName(CommandSourceStack var0) throws CommandSyntaxException {
        Optional var1 = this.name.left();
        if (var1.isPresent()) {
            List<? extends Entity> var2 = ((SelectorPattern)var1.get()).resolved().findEntities(var0);
            if (!var2.isEmpty()) {
                if (var2.size() != 1) {
                    throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.create();
                }
                return var2.getFirst();
            }
            return ScoreHolder.forNameOnly(((SelectorPattern)var1.get()).pattern());
        }
        return ScoreHolder.forNameOnly((String)this.name.right().orElseThrow());
    }

    private MutableComponent getScore(ScoreHolder var0, CommandSourceStack var1) {
        ReadOnlyScoreInfo var5;
        ServerScoreboard var3;
        Objective var4;
        MinecraftServer var2 = var1.getServer();
        if (var2 != null && (var4 = (var3 = var2.getScoreboard()).getObjective(this.objective)) != null && (var5 = var3.getPlayerScoreInfo(var0, var4)) != null) {
            return var5.formatValue(var4.numberFormatOrDefault(StyledFormat.NO_STYLE));
        }
        return Component.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null) {
            return Component.empty();
        }
        ScoreHolder var3 = this.findTargetName(var0);
        ScoreHolder var4 = var1 != null && var3.equals(ScoreHolder.WILDCARD) ? var1 : var3;
        return this.getScore(var4, var0);
    }

    @Override
    public String toString() {
        return "score{name='" + String.valueOf(this.name) + "', objective='" + this.objective + "'}";
    }
}

