/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.Mth;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean decode(ByteBuf var0) {
            return var0.readBoolean();
        }

        @Override
        public void encode(ByteBuf var0, Boolean var1) {
            var0.writeBoolean(var1.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Boolean)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte decode(ByteBuf var0) {
            return var0.readByte();
        }

        @Override
        public void encode(ByteBuf var0, Byte var1) {
            var0.writeByte((int)var1.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Byte)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> ROTATION_BYTE = BYTE.map(Mth::unpackDegrees, Mth::packDegrees);
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short decode(ByteBuf var0) {
            return var0.readShort();
        }

        @Override
        public void encode(ByteBuf var0, Short var1) {
            var0.writeShort((int)var1.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Short)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return var0.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeShort(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return var0.readInt();
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeInt(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return VarInt.read(var0);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            VarInt.write(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_VAR_INT = VAR_INT.map(var0 -> var0 == 0 ? OptionalInt.empty() : OptionalInt.of(var0 - 1), var0 -> var0.isPresent() ? var0.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf var0) {
            return var0.readLong();
        }

        @Override
        public void encode(ByteBuf var0, Long var1) {
            var0.writeLong(var1.longValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf var0) {
            return VarLong.read(var0);
        }

        @Override
        public void encode(ByteBuf var0, Long var1) {
            VarLong.write(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float decode(ByteBuf var0) {
            return Float.valueOf(var0.readFloat());
        }

        @Override
        public void encode(ByteBuf var0, Float var1) {
            var0.writeFloat(var1.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Float)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double decode(ByteBuf var0) {
            return var0.readDouble();
        }

        @Override
        public void encode(ByteBuf var0, Double var1) {
            var0.writeDouble(var1.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Double)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        public byte[] decode(ByteBuf var0) {
            return FriendlyByteBuf.readByteArray(var0);
        }

        @Override
        public void encode(ByteBuf var0, byte[] var1) {
            FriendlyByteBuf.writeByteArray(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (byte[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> LONG_ARRAY = new StreamCodec<ByteBuf, long[]>(){

        @Override
        public long[] decode(ByteBuf var0) {
            return FriendlyByteBuf.readLongArray(var0);
        }

        @Override
        public void encode(ByteBuf var0, long[] var1) {
            FriendlyByteBuf.writeLongArray(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (long[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(NbtAccounter::defaultQuota);
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::defaultQuota);
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        @Override
        public Optional<CompoundTag> decode(ByteBuf var0) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt(var0));
        }

        @Override
        public void encode(ByteBuf var0, Optional<CompoundTag> var1) {
            FriendlyByteBuf.writeNbt(var0, var1.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3fc> VECTOR3F = new StreamCodec<ByteBuf, Vector3fc>(){

        @Override
        public Vector3fc decode(ByteBuf var0) {
            return FriendlyByteBuf.readVector3f(var0);
        }

        @Override
        public void encode(ByteBuf var0, Vector3fc var1) {
            FriendlyByteBuf.writeVector3f(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3fc)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionfc> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionfc>(){

        @Override
        public Quaternionfc decode(ByteBuf var0) {
            return FriendlyByteBuf.readQuaternion(var0);
        }

        @Override
        public void encode(ByteBuf var0, Quaternionfc var1) {
            FriendlyByteBuf.writeQuaternion(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Quaternionfc)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> CONTAINER_ID = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return FriendlyByteBuf.readContainerId(var0);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            FriendlyByteBuf.writeContainerId(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){

        @Override
        public PropertyMap decode(ByteBuf var02) {
            int var1 = ByteBufCodecs.readCount(var02, 16);
            ImmutableMultimap.Builder var2 = ImmutableMultimap.builder();
            for (int var3 = 0; var3 < var1; ++var3) {
                String var4 = Utf8String.read(var02, 64);
                String var5 = Utf8String.read(var02, Short.MAX_VALUE);
                String var6 = FriendlyByteBuf.readNullable(var02, var0 -> Utf8String.read(var0, 1024));
                Property var7 = new Property(var4, var5, var6);
                var2.put((Object)var7.name(), (Object)var7);
            }
            return new PropertyMap((Multimap)var2.build());
        }

        @Override
        public void encode(ByteBuf var02, PropertyMap var12) {
            ByteBufCodecs.writeCount(var02, var12.size(), 16);
            for (Property var3 : var12.values()) {
                Utf8String.write(var02, var3.name(), 64);
                Utf8String.write(var02, var3.value(), Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable(var02, var3.signature(), (var0, var1) -> Utf8String.write(var0, var1, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (PropertyMap)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> PLAYER_NAME = ByteBufCodecs.stringUtf8(16);
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = StreamCodec.composite(UUIDUtil.STREAM_CODEC, GameProfile::id, PLAYER_NAME, GameProfile::name, GAME_PROFILE_PROPERTIES, GameProfile::properties, GameProfile::new);
    public static final StreamCodec<ByteBuf, Integer> RGB_COLOR = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return ARGB.color(var0.readByte() & 0xFF, var0.readByte() & 0xFF, var0.readByte() & 0xFF);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeByte(ARGB.red(var1));
            var0.writeByte(ARGB.green(var1));
            var0.writeByte(ARGB.blue(var1));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int var0) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] decode(ByteBuf var02) {
                return FriendlyByteBuf.readByteArray(var02, var0);
            }

            @Override
            public void encode(ByteBuf var02, byte[] var1) {
                if (var1.length > var0) {
                    throw new EncoderException("ByteArray with size " + var1.length + " is bigger than allowed " + var0);
                }
                FriendlyByteBuf.writeByteArray(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (byte[])object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int var0) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String decode(ByteBuf var02) {
                return Utf8String.read(var02, var0);
            }

            @Override
            public void encode(ByteBuf var02, String var1) {
                Utf8String.write(var02, var1, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (String)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Optional<Tag>> optionalTagCodec(final Supplier<NbtAccounter> var0) {
        return new StreamCodec<ByteBuf, Optional<Tag>>(){

            @Override
            public Optional<Tag> decode(ByteBuf var02) {
                return Optional.ofNullable(FriendlyByteBuf.readNbt(var02, (NbtAccounter)var0.get()));
            }

            @Override
            public void encode(ByteBuf var02, Optional<Tag> var1) {
                FriendlyByteBuf.writeNbt(var02, var1.orElse(null));
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> var0) {
        return new StreamCodec<ByteBuf, Tag>(){

            @Override
            public Tag decode(ByteBuf var02) {
                Tag var1 = FriendlyByteBuf.readNbt(var02, (NbtAccounter)var0.get());
                if (var1 == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return var1;
            }

            @Override
            public void encode(ByteBuf var02, Tag var1) {
                if (var1 == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Tag)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> var02) {
        return ByteBufCodecs.tagCodec(var02).map(var0 -> {
            if (var0 instanceof CompoundTag) {
                CompoundTag var1 = (CompoundTag)var0;
                return var1;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(var0));
        }, var0 -> var0);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> var0) {
        return ByteBufCodecs.fromCodec(var0, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> var0) {
        return ByteBufCodecs.fromCodec(var0, NbtAccounter::defaultQuota);
    }

    public static <T, B extends ByteBuf, V> StreamCodec.CodecOperation<B, T, V> fromCodec(final DynamicOps<T> var0, final Codec<V> var1) {
        return var2 -> new StreamCodec<B, V>(){

            @Override
            public V decode(B var02) {
                Object var12 = var2.decode(var02);
                return var1.parse(var0, var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            @Override
            public void encode(B var02, V var12) {
                Object var22 = var1.encodeStart(var0, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var22);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> var0, Supplier<NbtAccounter> var1) {
        return ByteBufCodecs.tagCodec(var1).apply(ByteBufCodecs.fromCodec(NbtOps.INSTANCE, var0));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> var0) {
        return ByteBufCodecs.fromCodecWithRegistries(var0, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> var0) {
        return ByteBufCodecs.fromCodecWithRegistries(var0, NbtAccounter::defaultQuota);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> var0, Supplier<NbtAccounter> var1) {
        final StreamCodec<ByteBuf, Tag> var2 = ByteBufCodecs.tagCodec(var1);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T decode(RegistryFriendlyByteBuf var02) {
                Tag var12 = (Tag)var2.decode(var02);
                RegistryOps<Tag> var22 = var02.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return var0.parse(var22, (Object)var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, T var12) {
                RegistryOps<Tag> var22 = var02.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag var3 = (Tag)var0.encodeStart(var22, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var3);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<? super B, V> var0) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B var02) {
                if (var02.readBoolean()) {
                    return Optional.of(var0.decode(var02));
                }
                return Optional.empty();
            }

            @Override
            public void encode(B var02, Optional<V> var1) {
                if (var1.isPresent()) {
                    var02.writeBoolean(true);
                    var0.encode(var02, var1.get());
                } else {
                    var02.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static int readCount(ByteBuf var0, int var1) {
        int var2 = VarInt.read(var0);
        if (var2 > var1) {
            throw new DecoderException(var2 + " elements exceeded max size of: " + var1);
        }
        return var2;
    }

    public static void writeCount(ByteBuf var0, int var1, int var2) {
        if (var1 > var2) {
            throw new EncoderException(var1 + " elements exceeded max size of: " + var2);
        }
        VarInt.write(var0, var1);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> var0, StreamCodec<? super B, V> var1) {
        return ByteBufCodecs.collection(var0, var1, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> var0, final StreamCodec<? super B, V> var1, final int var2) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B var02) {
                int var12 = ByteBufCodecs.readCount(var02, var2);
                Collection var22 = (Collection)var0.apply(Math.min(var12, 65536));
                for (int var3 = 0; var3 < var12; ++var3) {
                    var22.add(var1.decode(var02));
                }
                return var22;
            }

            @Override
            public void encode(B var02, C var12) {
                ByteBufCodecs.writeCount(var02, var12.size(), var2);
                for (Object var3 : var12) {
                    var1.encode(var02, var3);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (C)((Collection)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> var0) {
        return var1 -> ByteBufCodecs.collection(var0, var1);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return var0 -> ByteBufCodecs.collection(ArrayList::new, var0);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int var0) {
        return var1 -> ByteBufCodecs.collection(ArrayList::new, var1, var0);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> var0, StreamCodec<? super B, K> var1, StreamCodec<? super B, V> var2) {
        return ByteBufCodecs.map(var0, var1, var2, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> var0, final StreamCodec<? super B, K> var1, final StreamCodec<? super B, V> var2, final int var3) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B var02, M var12) {
                ByteBufCodecs.writeCount(var02, var12.size(), var3);
                var12.forEach((var3, var4) -> {
                    var1.encode(var02, var3);
                    var2.encode(var02, var4);
                });
            }

            @Override
            public M decode(B var02) {
                int var12 = ByteBufCodecs.readCount(var02, var3);
                Map var22 = (Map)var0.apply(Math.min(var12, 65536));
                for (int var32 = 0; var32 < var12; ++var32) {
                    Object var4 = var1.decode(var02);
                    Object var5 = var2.decode(var02);
                    var22.put(var4, var5);
                }
                return var22;
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (M)((Map)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> var0, final StreamCodec<? super B, R> var1) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B var02) {
                if (var02.readBoolean()) {
                    return Either.left(var0.decode(var02));
                }
                return Either.right(var1.decode(var02));
            }

            @Override
            public void encode(B var02, Either<L, R> var12) {
                var12.ifLeft(var2 -> {
                    var02.writeBoolean(true);
                    var0.encode(var02, var2);
                }).ifRight(var2 -> {
                    var02.writeBoolean(false);
                    var1.encode(var02, var2);
                });
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Either)((Either)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, V> lengthPrefixed(final int var0, final BiFunction<B, ByteBuf, B> var1) {
        return var2 -> new StreamCodec<B, V>(){

            @Override
            public V decode(B var02) {
                int var12 = VarInt.read(var02);
                if (var12 > var0) {
                    throw new DecoderException("Buffer size " + var12 + " is larger than allowed limit of " + var0);
                }
                int var22 = var02.readerIndex();
                ByteBuf var3 = (ByteBuf)var1.apply(var02, var02.slice(var22, var12));
                var02.readerIndex(var22 + var12);
                return var2.decode(var3);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encode(B var02, V var12) {
                ByteBuf var22 = (ByteBuf)var1.apply(var02, var02.alloc().buffer());
                try {
                    var2.encode(var22, var12);
                    int var3 = var22.readableBytes();
                    if (var3 > var0) {
                        throw new EncoderException("Buffer size " + var3 + " is  larger than allowed limit of " + var0);
                    }
                    VarInt.write(var02, var3);
                    var02.writeBytes(var22);
                }
                finally {
                    var22.release();
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <V> StreamCodec.CodecOperation<ByteBuf, V, V> lengthPrefixed(int var02) {
        return ByteBufCodecs.lengthPrefixed(var02, (var0, var1) -> var1);
    }

    public static <V> StreamCodec.CodecOperation<RegistryFriendlyByteBuf, V, V> registryFriendlyLengthPrefixed(int var02) {
        return ByteBufCodecs.lengthPrefixed(var02, (var0, var1) -> new RegistryFriendlyByteBuf((ByteBuf)var1, var0.registryAccess()));
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> var0, final ToIntFunction<T> var1) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf var02) {
                int var12 = VarInt.read(var02);
                return var0.apply(var12);
            }

            @Override
            public void encode(ByteBuf var02, T var12) {
                int var2 = var1.applyAsInt(var12);
                VarInt.write(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> var0) {
        return ByteBufCodecs.idMapper(var0::byIdOrThrow, var0::getIdOrThrow);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> var0, final Function<Registry<T>, IdMap<R>> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf var02) {
                return (IdMap)var1.apply(var02.registryAccess().lookupOrThrow(var0));
            }

            @Override
            public R decode(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.read(var02);
                return this.getRegistryOrThrow(var02).byIdOrThrow(var12);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, R var12) {
                int var2 = this.getRegistryOrThrow(var02).getIdOrThrow(var12);
                VarInt.write(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> var02) {
        return ByteBufCodecs.registry(var02, var0 -> var0);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> var0) {
        return ByteBufCodecs.registry(var0, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> var0, final StreamCodec<? super RegistryFriendlyByteBuf, T> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf var02) {
                return var02.registryAccess().lookupOrThrow(var0).asHolderIdMap();
            }

            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.read(var02);
                if (var12 == 0) {
                    return Holder.direct(var1.decode(var02));
                }
                return this.getRegistryOrThrow(var02).byIdOrThrow(var12 - 1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, Holder<T> var12) {
                switch (var12.kind()) {
                    case REFERENCE: {
                        int var2 = this.getRegistryOrThrow(var02).getIdOrThrow(var12);
                        VarInt.write(var02, var2 + 1);
                        break;
                    }
                    case DIRECT: {
                        VarInt.write(var02, 0);
                        var1.encode(var02, var12.value());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (Holder)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(var0);
            }

            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf var02) {
                int var1 = VarInt.read(var02) - 1;
                if (var1 == -1) {
                    HolderLookup.RegistryLookup var2 = var02.registryAccess().lookupOrThrow(var0);
                    return (HolderSet)var2.get(TagKey.create(var0, (Identifier)Identifier.STREAM_CODEC.decode(var02))).orElseThrow();
                }
                ArrayList<Holder> var2 = new ArrayList<Holder>(Math.min(var1, 65536));
                for (int var3 = 0; var3 < var1; ++var3) {
                    var2.add((Holder)this.holderCodec.decode(var02));
                }
                return HolderSet.direct(var2);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, HolderSet<T> var1) {
                Optional var2 = var1.unwrapKey();
                if (var2.isPresent()) {
                    VarInt.write(var02, 0);
                    Identifier.STREAM_CODEC.encode(var02, var2.get().location());
                } else {
                    VarInt.write(var02, var1.size() + 1);
                    for (Holder holder : var1) {
                        this.holderCodec.encode(var02, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (HolderSet)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<ByteBuf, JsonElement> lenientJson(final int var0) {
        return new StreamCodec<ByteBuf, JsonElement>(){
            private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

            @Override
            public JsonElement decode(ByteBuf var02) {
                String var1 = Utf8String.read(var02, var0);
                try {
                    return LenientJsonParser.parse(var1);
                }
                catch (JsonSyntaxException var2) {
                    throw new DecoderException("Failed to parse JSON", (Throwable)var2);
                }
            }

            @Override
            public void encode(ByteBuf var02, JsonElement var1) {
                String var2 = GSON.toJson(var1);
                Utf8String.write(var02, var2, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (JsonElement)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }
}

