/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import org.jspecify.annotations.Nullable;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;

    public static <T extends PacketListener, P extends BundlePacket<? super T>> BundlerInfo createForPacket(final PacketType<P> var0, final Function<Iterable<Packet<? super T>>, P> var1, final BundleDelimiterPacket<? super T> var2) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> var02, Consumer<Packet<?>> var12) {
                if (var02.type() == var0) {
                    BundlePacket var22 = (BundlePacket)var02;
                    var12.accept(var2);
                    var22.subPackets().forEach(var12);
                    var12.accept(var2);
                } else {
                    var12.accept(var02);
                }
            }

            @Override
            public @Nullable Bundler startPacketBundling(Packet<?> var02) {
                if (var02 == var2) {
                    return new Bundler(){
                        private final List<Packet<? super T>> bundlePackets = new ArrayList();

                        @Override
                        public @Nullable Packet<?> addPacket(Packet<?> var0) {
                            if (var0 == var2) {
                                return (Packet)var1.apply(this.bundlePackets);
                            }
                            Packet<?> var1 = var0;
                            if (this.bundlePackets.size() >= 4096) {
                                throw new IllegalStateException("Too many packets in a bundle");
                            }
                            this.bundlePackets.add(var1);
                            return null;
                        }
                    };
                }
                return null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    public @Nullable Bundler startPacketBundling(Packet<?> var1);

    public static interface Bundler {
        public @Nullable Packet<?> addPacket(Packet<?> var1);
    }
}

