/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PacketUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, ServerLevel var2) throws RunningOnDifferentThreadException {
        PacketUtils.ensureRunningOnSameThread(var0, var1, var2.getServer().packetProcessor());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, PacketProcessor var2) throws RunningOnDifferentThreadException {
        if (!var2.isSameThread()) {
            var2.scheduleIfPossible(var1, var0);
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception var0, Packet<T> var1, T var2) {
        if (var0 instanceof ReportedException) {
            ReportedException var3 = (ReportedException)var0;
            PacketUtils.fillCrashReport(var3.getReport(), var2, var1);
            return var3;
        }
        CrashReport var4 = CrashReport.forThrowable(var0, "Main thread packet handler");
        PacketUtils.fillCrashReport(var4, var2, var1);
        return new ReportedException(var4);
    }

    public static <T extends PacketListener> void fillCrashReport(CrashReport var0, T var1, @Nullable Packet<T> var2) {
        if (var2 != null) {
            CrashReportCategory var3 = var0.addCategory("Incoming Packet");
            var3.setDetail("Type", () -> var2.type().toString());
            var3.setDetail("Is Terminal", () -> Boolean.toString(var2.isTerminal()));
            var3.setDetail("Is Skippable", () -> Boolean.toString(var2.isSkippable()));
        }
        var1.fillCrashReport(var0);
    }
}

