/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.resources.Identifier;

public interface CustomPacketPayload {
    public Type<? extends CustomPacketPayload> type();

    public static <B extends ByteBuf, T extends CustomPacketPayload> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> var0, StreamDecoder<B, T> var1) {
        return StreamCodec.ofMember(var0, var1);
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String var0) {
        return new Type(Identifier.withDefaultNamespace(var0));
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, CustomPacketPayload> codec(final FallbackProvider<B> var02, List<TypeAndCodec<? super B, ?>> var1) {
        final Map<Identifier, StreamCodec> var2 = var1.stream().collect(Collectors.toUnmodifiableMap(var0 -> var0.type().id(), TypeAndCodec::codec));
        return new StreamCodec<B, CustomPacketPayload>(){

            private StreamCodec<? super B, ? extends CustomPacketPayload> findCodec(Identifier var0) {
                StreamCodec var1 = (StreamCodec)var2.get(var0);
                if (var1 != null) {
                    return var1;
                }
                return var02.create(var0);
            }

            private <T extends CustomPacketPayload> void writeCap(B var0, Type<T> var1, CustomPacketPayload var22) {
                ((FriendlyByteBuf)((Object)var0)).writeIdentifier(var1.id());
                StreamCodec var3 = this.findCodec(var1.id);
                var3.encode(var0, var22);
            }

            @Override
            public void encode(B var0, CustomPacketPayload var1) {
                this.writeCap(var0, var1.type(), var1);
            }

            @Override
            public CustomPacketPayload decode(B var0) {
                Identifier var1 = ((FriendlyByteBuf)((Object)var0)).readIdentifier();
                return (CustomPacketPayload)this.findCodec(var1).decode(var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((Object)((FriendlyByteBuf)((Object)object))), (CustomPacketPayload)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((Object)((FriendlyByteBuf)((Object)object))));
            }
        };
    }

    public static final class Type<T extends CustomPacketPayload>
    extends Record {
        final Identifier id;

        public Type(Identifier var0) {
            this.id = var0;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Type.class, "id", "id"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Type.class, "id", "id"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Type.class, "id", "id"}, this, var0);
        }

        public Identifier id() {
            return this.id;
        }
    }

    public static interface FallbackProvider<B extends FriendlyByteBuf> {
        public StreamCodec<B, ? extends CustomPacketPayload> create(Identifier var1);
    }

    public record TypeAndCodec<B extends FriendlyByteBuf, T extends CustomPacketPayload>(Type<T> type, StreamCodec<B, T> codec) {
    }
}

